/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.Arrays;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class RowImpl
implements Row {
    private long key;
    private final Value[] data;
    private int memory;
    private int version;
    private boolean deleted;
    private int sessionId;

    public RowImpl(Value[] data, int memory) {
        this.data = data;
        this.memory = memory;
    }

    @Override
    public Row getCopy() {
        Value[] d2 = Arrays.copyOf(this.data, this.data.length);
        RowImpl r2 = new RowImpl(d2, this.memory);
        r2.key = this.key;
        r2.version = this.version + 1;
        r2.sessionId = this.sessionId;
        return r2;
    }

    @Override
    public void setKeyAndVersion(SearchRow row) {
        this.setKey(row.getKey());
        this.setVersion(row.getVersion());
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public void setKey(long key) {
        this.key = key;
    }

    @Override
    public Value getValue(int i) {
        return i == -1 ? ValueLong.get(this.key) : this.data[i];
    }

    @Override
    public int getByteCount(Data dummy) {
        int size = 0;
        for (Value v : this.data) {
            size += dummy.getValueLen(v);
        }
        return size;
    }

    @Override
    public void setValue(int i, Value v) {
        if (i == -1) {
            this.key = v.getLong();
        } else {
            this.data[i] = v;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        int m = 40;
        if (this.data != null) {
            int len = this.data.length;
            m += 24 + len * 8;
            for (Value v : this.data) {
                if (v == null) continue;
                m += v.getMemory();
            }
        }
        this.memory = m;
        return m;
    }

    public String toString() {
        StatementBuilder buff = new StatementBuilder("( /* key:");
        buff.append(this.getKey());
        if (this.version != 0) {
            buff.append(" v:").append(this.version);
        }
        if (this.isDeleted()) {
            buff.append(" deleted");
        }
        buff.append(" */ ");
        if (this.data != null) {
            for (Value v : this.data) {
                buff.appendExceptFirst(", ");
                buff.append(v == null ? "null" : v.getTraceSQL());
            }
        }
        return buff.append(')').toString();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    @Override
    public void commit() {
        this.sessionId = 0;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Value[] getValueList() {
        return this.data;
    }
}

