/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.Reader;
import org.h2.util.IOUtils;

public final class RangeReader
extends Reader {
    private final Reader r;
    private long limit;

    public RangeReader(Reader r, long offset, long limit) throws IOException {
        this.r = r;
        this.limit = limit;
        IOUtils.skipFully(r, offset);
    }

    @Override
    public int read() throws IOException {
        if (this.limit <= 0L) {
            return -1;
        }
        int c = this.r.read();
        if (c >= 0) {
            --this.limit;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int cnt;
        if (this.limit <= 0L) {
            return -1;
        }
        if ((long)len > this.limit) {
            len = (int)this.limit;
        }
        if ((cnt = this.r.read(cbuf, off, len)) > 0) {
            this.limit -= (long)cnt;
        }
        return cnt;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > this.limit) {
            n = (int)this.limit;
        }
        n = this.r.skip(n);
        this.limit -= n;
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.limit > 0L) {
            return this.r.ready();
        }
        return false;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }
}

