/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.util.concurrent.TimeUnit;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileBase;

class FileNioMapped
extends FileBase {
    private static final long GC_TIMEOUT_MS = 10000L;
    private final String name;
    private final FileChannel.MapMode mode;
    private RandomAccessFile file;
    private MappedByteBuffer mapped;
    private long fileLength;
    private int pos;

    FileNioMapped(String fileName, String mode) throws IOException {
        this.mode = "r".equals(mode) ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.name = fileName;
        this.file = new RandomAccessFile(fileName, mode);
        this.reMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unMap() throws IOException {
        if (this.mapped == null) {
            return;
        }
        this.mapped.force();
        boolean useSystemGc = true;
        if (SysProperties.NIO_CLEANER_HACK) {
            try {
                Method cleanerMethod = this.mapped.getClass().getMethod("cleaner", new Class[0]);
                cleanerMethod.setAccessible(true);
                Object cleaner = cleanerMethod.invoke((Object)this.mapped, new Object[0]);
                if (cleaner != null) {
                    Method clearMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                    clearMethod.invoke(cleaner, new Object[0]);
                }
                useSystemGc = false;
            }
            catch (Throwable cleanerMethod) {
            }
            finally {
                this.mapped = null;
            }
        }
        if (useSystemGc) {
            WeakReference<MappedByteBuffer> bufferWeakRef = new WeakReference<MappedByteBuffer>(this.mapped);
            this.mapped = null;
            long start = System.nanoTime();
            while (bufferWeakRef.get() != null) {
                if (System.nanoTime() - start > TimeUnit.MILLISECONDS.toNanos(10000L)) {
                    throw new IOException("Timeout (10000 ms) reached while trying to GC mapped buffer");
                }
                System.gc();
                Thread.yield();
            }
        }
    }

    private void reMap() throws IOException {
        int oldPos = 0;
        if (this.mapped != null) {
            oldPos = this.pos;
            this.unMap();
        }
        this.fileLength = this.file.length();
        FileNioMapped.checkFileSizeLimit(this.fileLength);
        this.mapped = this.file.getChannel().map(this.mode, 0L, this.fileLength);
        int limit = this.mapped.limit();
        int capacity = this.mapped.capacity();
        if ((long)limit < this.fileLength || (long)capacity < this.fileLength) {
            throw new IOException("Unable to map: length=" + limit + " capacity=" + capacity + " length=" + this.fileLength);
        }
        if (SysProperties.NIO_LOAD_MAPPED) {
            this.mapped.load();
        }
        this.pos = Math.min(oldPos, (int)this.fileLength);
    }

    private static void checkFileSizeLimit(long length) throws IOException {
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File over 2GB is not supported yet when using this file system");
        }
    }

    @Override
    public void implCloseChannel() throws IOException {
        if (this.file != null) {
            this.unMap();
            this.file.close();
            this.file = null;
        }
    }

    @Override
    public long position() {
        return this.pos;
    }

    public String toString() {
        return "nioMapped:" + this.name;
    }

    @Override
    public synchronized long size() throws IOException {
        return this.fileLength;
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        try {
            int len = dst.remaining();
            if (len == 0) {
                return 0;
            }
            if ((len = (int)Math.min((long)len, this.fileLength - (long)this.pos)) <= 0) {
                return -1;
            }
            this.mapped.position(this.pos);
            this.mapped.get(dst.array(), dst.arrayOffset() + dst.position(), len);
            dst.position(dst.position() + len);
            this.pos += len;
            return len;
        }
        catch (IllegalArgumentException e) {
            EOFException e2 = new EOFException("EOF");
            e2.initCause(e);
            throw e2;
        }
        catch (BufferUnderflowException e) {
            EOFException e2 = new EOFException("EOF");
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public FileChannel position(long pos) throws IOException {
        FileNioMapped.checkFileSizeLimit(pos);
        this.pos = (int)pos;
        return this;
    }

    @Override
    public synchronized FileChannel truncate(long newLength) throws IOException {
        if (this.mode == FileChannel.MapMode.READ_ONLY) {
            throw new NonWritableChannelException();
        }
        if (newLength < this.size()) {
            this.setFileLength(newLength);
        }
        return this;
    }

    public synchronized void setFileLength(long newLength) throws IOException {
        FileNioMapped.checkFileSizeLimit(newLength);
        int oldPos = this.pos;
        this.unMap();
        int i = 0;
        while (true) {
            try {
                this.file.setLength(newLength);
            }
            catch (IOException e) {
                if (i > 16 || !e.toString().contains("user-mapped section open")) {
                    throw e;
                }
                System.gc();
                ++i;
                continue;
            }
            break;
        }
        this.reMap();
        this.pos = (int)Math.min(newLength, (long)oldPos);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.mapped.force();
        this.file.getFD().sync();
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        if (this.mapped.capacity() < this.pos + len) {
            this.setFileLength(this.pos + len);
        }
        this.mapped.position(this.pos);
        this.mapped.put(src);
        this.pos += len;
        return len;
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.file.getChannel().tryLock(position, size, shared);
    }
}

