/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.h2.message.DbException;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileChannelOutputStream;
import org.h2.store.fs.FileNioMem;
import org.h2.store.fs.FileNioMemData;
import org.h2.store.fs.FilePath;
import org.h2.util.New;

public class FilePathNioMem
extends FilePath {
    private static final TreeMap<String, FileNioMemData> MEMORY_FILES = new TreeMap();
    float compressLaterCachePercent = 1.0f;

    @Override
    public FilePathNioMem getPath(String path) {
        FilePathNioMem p = new FilePathNioMem();
        p.name = FilePathNioMem.getCanonicalPath(path);
        return p;
    }

    @Override
    public long size() {
        return this.getMemoryFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        TreeMap<String, FileNioMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            if (!atomicReplace && !this.name.equals(newName.name) && MEMORY_FILES.containsKey(newName.name)) {
                throw DbException.get(90024, this.name, newName + " (exists)");
            }
            FileNioMemData f = this.getMemoryFile();
            f.setName(newName.name);
            MEMORY_FILES.remove(this.name);
            MEMORY_FILES.put(newName.name, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createFile() {
        TreeMap<String, FileNioMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            if (this.exists()) {
                return false;
            }
            this.getMemoryFile();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        if (this.isRoot()) {
            return true;
        }
        TreeMap<String, FileNioMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            return MEMORY_FILES.get(this.name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        if (this.isRoot()) {
            return;
        }
        TreeMap<String, FileNioMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            MEMORY_FILES.remove(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FilePath> newDirectoryStream() {
        ArrayList<FilePath> list = New.arrayList();
        TreeMap<String, FileNioMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            for (String n : MEMORY_FILES.tailMap(this.name).keySet()) {
                if (!n.startsWith(this.name)) break;
                list.add(this.getPath(n));
            }
            return list;
        }
    }

    @Override
    public boolean setReadOnly() {
        return this.getMemoryFile().setReadOnly();
    }

    @Override
    public boolean canWrite() {
        return this.getMemoryFile().canWrite();
    }

    @Override
    public FilePathNioMem getParent() {
        int idx = this.name.lastIndexOf(47);
        return idx < 0 ? null : this.getPath(this.name.substring(0, idx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory() {
        if (this.isRoot()) {
            return true;
        }
        TreeMap<String, FileNioMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            return MEMORY_FILES.get(this.name) == null;
        }
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public FilePathNioMem toRealPath() {
        return this;
    }

    @Override
    public long lastModified() {
        return this.getMemoryFile().getLastModified();
    }

    @Override
    public void createDirectory() {
        if (this.exists() && this.isDirectory()) {
            throw DbException.get(90062, this.name + " (a file with this name already exists)");
        }
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        FileNioMemData obj = this.getMemoryFile();
        FileNioMem m = new FileNioMem(obj, false);
        return new FileChannelOutputStream(m, append);
    }

    @Override
    public InputStream newInputStream() {
        FileNioMemData obj = this.getMemoryFile();
        FileNioMem m = new FileNioMem(obj, true);
        return new FileChannelInputStream(m, true);
    }

    @Override
    public FileChannel open(String mode) {
        FileNioMemData obj = this.getMemoryFile();
        return new FileNioMem(obj, "r".equals(mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileNioMemData getMemoryFile() {
        TreeMap<String, FileNioMemData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            FileNioMemData m = MEMORY_FILES.get(this.name);
            if (m == null) {
                m = new FileNioMemData(this.name, this.compressed(), this.compressLaterCachePercent);
                MEMORY_FILES.put(this.name, m);
            }
            return m;
        }
    }

    protected boolean isRoot() {
        return this.name.equals(this.getScheme() + ":");
    }

    protected static String getCanonicalPath(String fileName) {
        fileName = fileName.replace('\\', '/');
        int idx = fileName.lastIndexOf(58) + 1;
        if (fileName.length() > idx && fileName.charAt(idx) != '/') {
            fileName = fileName.substring(0, idx) + "/" + fileName.substring(idx);
        }
        return fileName;
    }

    @Override
    public String getScheme() {
        return "nioMemFS";
    }

    boolean compressed() {
        return false;
    }
}

