/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Mode;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int KEY_COLUMN_USAGE = 31;
    private static final int REFERENTIAL_CONSTRAINTS = 32;
    private static final int META_TABLE_TYPE_COUNT = 33;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int id, int type) {
        super(schema, id, null, true, true);
        Column[] cols;
        this.type = type;
        String indexColumnName = null;
        switch (type) {
            case 0: {
                this.setObjectName("TABLES");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT", "COLUMN_TYPE", "COLUMN_ON_UPDATE");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS", "AFFINITY BIT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                cols = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                cols = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                cols = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                cols = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                cols = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                cols = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "MIN_VALUE BIGINT", "MAX_VALUE BIGINT", "IS_CYCLE BIT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                cols = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                cols = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                cols = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                cols = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                cols = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                cols = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                cols = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                cols = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                cols = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                cols = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                cols = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                cols = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                indexColumnName = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                cols = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                cols = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                cols = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                cols = this.createColumns("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START", "CONTAINS_UNCOMMITTED");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                cols = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                cols = this.createColumns("KEY", "SQL");
                break;
            }
            case 28: {
                this.setObjectName("QUERY_STATISTICS");
                cols = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME DOUBLE", "MAX_EXECUTION_TIME DOUBLE", "CUMULATIVE_EXECUTION_TIME DOUBLE", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            case 29: {
                this.setObjectName("SYNONYMS");
                cols = this.createColumns("SYNONYM_CATALOG", "SYNONYM_SCHEMA", "SYNONYM_NAME", "SYNONYM_FOR", "SYNONYM_FOR_SCHEMA", "TYPE_NAME", "STATUS", "REMARKS", "ID INT");
                indexColumnName = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setObjectName("TABLE_CONSTRAINTS");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "IS_DEFERRABLE", "INITIALLY_DEFERRED");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setObjectName("KEY_COLUMN_USAGE");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION", "POSITION_IN_UNIQUE_CONSTRAINT");
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 32: {
                this.setObjectName("REFERENTIAL_CONSTRAINTS");
                cols = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "UNIQUE_CONSTRAINT_CATALOG", "UNIQUE_CONSTRAINT_SCHEMA", "UNIQUE_CONSTRAINT_NAME", "MATCH_OPTION", "UPDATE_RULE", "DELETE_RULE");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + type);
            }
        }
        this.setColumns(cols);
        if (indexColumnName == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(indexColumnName).getColumnId();
            IndexColumn[] indexCols = IndexColumn.wrap(new Column[]{cols[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexCols, false);
        }
    }

    private Column[] createColumns(String ... names) {
        Column[] cols = new Column[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name;
            int dataType;
            String nameType = names[i];
            int idx = nameType.indexOf(32);
            if (idx < 0) {
                dataType = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                name = nameType;
            } else {
                dataType = DataType.getTypeByName((String)nameType.substring((int)(idx + 1)), (Mode)this.database.getMode()).type;
                name = nameType.substring(0, idx);
            }
            cols[i] = new Column(name, dataType);
        }
        return cols;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String s) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            s = s == null ? null : StringUtils.toLowerEnglish(s);
        }
        return s;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> tables = this.database.getAllTablesAndViews(true);
        ArrayList<Table> tempTables = session.getLocalTempTables();
        tables.addAll(tempTables);
        return tables;
    }

    private ArrayList<Table> getTablesByName(Session session, String tableName) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            tableName = StringUtils.toUpperEnglish(tableName);
        }
        ArrayList<Table> tables = this.database.getTableOrViewByName(tableName);
        for (Table temp : session.getLocalTempTables()) {
            if (!temp.getName().equals(tableName)) continue;
            tables.add(temp);
        }
        return tables;
    }

    private boolean checkIndex(Session session, String value, Value indexFrom, Value indexTo) {
        if (value == null || indexFrom == null && indexTo == null) {
            return true;
        }
        Database db = session.getDatabase();
        Value v = this.database.getMode().lowerCaseIdentifiers ? ValueStringIgnoreCase.get(value) : ValueString.get(value);
        if (indexFrom != null && db.compare(v, indexFrom) < 0) {
            return false;
        }
        return indexTo == null || db.compare(v, indexTo) <= 0;
    }

    private static String replaceNullWithEmpty(String s) {
        return s == null ? "" : s;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * Could not resolve type clashes
     * Iterators could be improved
     * Unable to fully structure code
     */
    public ArrayList<Row> generateRows(Session session, SearchRow first, SearchRow last) {
        indexFrom = null;
        indexTo = null;
        if (this.indexColumn >= 0) {
            if (first != null) {
                indexFrom = first.getValue(this.indexColumn);
            }
            if (last != null) {
                indexTo = last.getValue(this.indexColumn);
            }
        }
        rows = New.arrayList();
        catalog = this.identifier(this.database.getShortName());
        admin = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    tableName = this.identifier(table.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    storageType = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() != false ? "CACHED" : "MEMORY");
                    sql = table.getCreateSQL();
                    if (!admin && sql != null && sql.contains("--hide--")) {
                        sql = "-";
                    }
                    this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, table.getTableType().toString(), storageType, sql, MetaTable.replaceNullWithEmpty(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId(), null, table.getClass().getName(), "" + table.getRowCountApproximation()});
                }
                break;
            }
            case 1: {
                if (indexFrom != null && indexFrom.equals(indexTo)) {
                    tableName = this.identifier(indexFrom.getString());
                    tablesToList = this.getTablesByName(session, tableName);
                } else {
                    tablesToList = this.getAllTables(session);
                }
                for (Table table : tablesToList) {
                    tableName = this.identifier(table.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    cols = table.getColumns();
                    collation = this.database.getCompareMode().getName();
                    for (j = 0; j < cols.length; ++j) {
                        c = cols[j];
                        sequence = c.getSequence();
                        this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, this.identifier(c.getName()), String.valueOf(j + 1), c.getDefaultSQL(), c.isNullable() != false ? "YES" : "NO", "" + DataType.convertTypeToSQLType(c.getType()), "" + c.getPrecisionAsInt(), "" + c.getPrecisionAsInt(), "" + c.getPrecisionAsInt(), "10", "" + c.getScale(), "Unicode", collation, this.identifier(DataType.getDataType((int)c.getType()).name), "" + (c.isNullable() != false ? 1 : 0), "" + (c.getComputed() != false ? "TRUE" : "FALSE"), "" + c.getSelectivity(), c.getCheckConstraintSQL(session, c.getName()), sequence == null ? null : sequence.getName(), MetaTable.replaceNullWithEmpty(c.getComment()), null, c.getCreateSQLWithoutName(), c.getOnUpdateSQL()});
                    }
                }
                break;
            }
            case 2: {
                if (indexFrom != null && indexFrom.equals(indexTo)) {
                    tableName = this.identifier(indexFrom.getString());
                    tablesToList = this.getTablesByName(session, tableName);
                } else {
                    tablesToList = this.getAllTables(session);
                }
                for (Table table : tablesToList) {
                    tableName = this.identifier(table.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    indexes = table.getIndexes();
                    constraints = table.getConstraints();
                    for (j = 0; indexes != null && j < indexes.size(); ++j) {
                        index = indexes.get(j);
                        if (index.getCreateSQL() == null) continue;
                        constraintName = null;
                        for (k = 0; constraints != null && k < constraints.size(); ++k) {
                            constraint = constraints.get(k);
                            if (!constraint.usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (constraint.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                constraintName = constraint.getName();
                                continue;
                            }
                            constraintName = constraint.getName();
                        }
                        cols = index.getIndexColumns();
                        indexClass = index instanceof MultiVersionIndex != false ? ((MultiVersionIndex)index).getBaseIndex().getClass().getName() : index.getClass().getName();
                        for (k = 0; k < cols.length; ++k) {
                            idxCol = cols[k];
                            column = idxCol.column;
                            this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, index.getIndexType().isUnique() != false ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (k + 1), this.identifier(column.getName()), "0", index.getIndexType().isPrimaryKey() != false ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().getBelongsToConstraint() != false ? "TRUE" : "FALSE", "3", (idxCol.sortType & 1) != 0 ? "D" : "A", "0", "", MetaTable.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), "" + index.getId(), "" + idxCol.sortType, constraintName, indexClass, index.getIndexType().isAffinity() != false ? "TRUE" : "FALSE"});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(rows, new String[]{TableType.TABLE.toString()});
                this.add(rows, new String[]{TableType.TABLE_LINK.toString()});
                this.add(rows, new String[]{TableType.SYSTEM_TABLE.toString()});
                this.add(rows, new String[]{TableType.VIEW.toString()});
                this.add(rows, new String[]{TableType.EXTERNAL_TABLE_ENGINE.toString()});
                break;
            }
            case 5: {
                this.add(rows, new String[]{catalog});
                break;
            }
            case 6: {
                for (Object s : this.database.getAllSettings()) {
                    value = s.getStringValue();
                    if (value == null) {
                        value = "" + s.getIntValue();
                    }
                    this.add(rows, new String[]{this.identifier(s.getName()), value});
                }
                this.add(rows, new String[]{"info.BUILD_ID", "197"});
                this.add(rows, new String[]{"info.VERSION_MAJOR", "1"});
                this.add(rows, new String[]{"info.VERSION_MINOR", "4"});
                this.add(rows, new String[]{"info.VERSION", "" + Constants.getFullVersion()});
                if (admin) {
                    settings = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (String s : settings) {
                        this.add(rows, new String[]{"property." + s, Utils.getProperty(s, "")});
                    }
                }
                this.add(rows, new String[]{"EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE"});
                this.add(rows, new String[]{"MODE", this.database.getMode().getName()});
                this.add(rows, new String[]{"MULTI_THREADED", this.database.isMultiThreaded() != false ? "1" : "0"});
                this.add(rows, new String[]{"MVCC", this.database.isMultiVersion() != false ? "TRUE" : "FALSE"});
                this.add(rows, new String[]{"QUERY_TIMEOUT", "" + session.getQueryTimeout()});
                this.add(rows, new String[]{"RETENTION_TIME", "" + this.database.getRetentionTime()});
                this.add(rows, new String[]{"LOG", "" + this.database.getLogMode()});
                settingNames = New.arrayList();
                s = this.database.getSettings().getSettings();
                settingNames.addAll(s.keySet());
                Collections.sort(settingNames);
                for (String k : settingNames) {
                    this.add(rows, new String[]{k, (String)s.get(k)});
                }
                if (!this.database.isPersistent()) break;
                store = this.database.getPageStore();
                if (store != null) {
                    this.add(rows, new String[]{"info.FILE_WRITE_TOTAL", "" + store.getWriteCountTotal()});
                    this.add(rows, new String[]{"info.FILE_WRITE", "" + store.getWriteCount()});
                    this.add(rows, new String[]{"info.FILE_READ", "" + store.getReadCount()});
                    this.add(rows, new String[]{"info.PAGE_COUNT", "" + store.getPageCount()});
                    this.add(rows, new String[]{"info.PAGE_SIZE", "" + store.getPageSize()});
                    this.add(rows, new String[]{"info.CACHE_MAX_SIZE", "" + store.getCache().getMaxMemory()});
                    this.add(rows, new String[]{"info.CACHE_SIZE", "" + store.getCache().getMemory()});
                }
                if ((mvStore = this.database.getMvStore()) == null) break;
                fs = mvStore.getStore().getFileStore();
                this.add(rows, new String[]{"info.FILE_WRITE", "" + fs.getWriteCount()});
                this.add(rows, new String[]{"info.FILE_READ", "" + fs.getReadCount()});
                try {
                    size = fs.getFile().size();
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, "Can not get size");
                }
                pageSize = 4096;
                pageCount = size / (long)pageSize;
                this.add(rows, new String[]{"info.PAGE_COUNT", "" + pageCount});
                this.add(rows, new String[]{"info.PAGE_SIZE", "" + pageSize});
                this.add(rows, new String[]{"info.CACHE_MAX_SIZE", "" + mvStore.getStore().getCacheSize()});
                this.add(rows, new String[]{"info.CACHE_SIZE", "" + mvStore.getStore().getCacheSizeUsed()});
                break;
            }
            case 4: {
                for (DataType t : DataType.getTypes()) {
                    if (t.hidden || t.sqlType == 0) continue;
                    this.add(rows, new String[]{t.name, String.valueOf(t.sqlType), String.valueOf(MathUtils.convertLongToInt(t.maxPrecision)), t.prefix, t.suffix, t.params, String.valueOf(t.autoIncrement), String.valueOf(t.minScale), String.valueOf(t.maxScale), t.decimal != false ? "10" : null, String.valueOf(t.sqlTypePos), String.valueOf(t.caseSensitive), "1", "3"});
                }
                break;
            }
            case 7: {
                resource = "/org/h2/res/help.csv";
                try {
                    data = Utils.getResource(resource);
                    reader = new InputStreamReader(new ByteArrayInputStream(data));
                    csv = new Csv();
                    csv.setLineCommentCharacter('#');
                    rs = csv.read(reader, null);
                    i = 0;
                    while (rs.next()) {
                        this.add(rows, new String[]{String.valueOf(i), rs.getString(1).trim(), rs.getString(2).trim(), rs.getString(3).trim(), rs.getString(4).trim()});
                        ++i;
                    }
                    break;
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
            }
            case 8: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(3)) {
                    s = (Sequence)obj;
                    this.add(rows, new String[]{catalog, this.identifier(s.getSchema().getName()), this.identifier(s.getName()), String.valueOf(s.getCurrentValue()), String.valueOf(s.getIncrement()), s.getBelongsToTable() != false ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(s.getComment()), String.valueOf(s.getCacheSize()), String.valueOf(s.getMinValue()), String.valueOf(s.getMaxValue()), s.getCycle() != false ? "TRUE" : "FALSE", "" + s.getId()});
                }
                break;
            }
            case 9: {
                for (User u : this.database.getAllUsers()) {
                    if (!admin && session.getUser() != u) continue;
                    this.add(rows, new String[]{this.identifier(u.getName()), String.valueOf(u.isAdmin()), MetaTable.replaceNullWithEmpty(u.getComment()), "" + u.getId()});
                }
                break;
            }
            case 10: {
                for (Role r : this.database.getAllRoles()) {
                    if (!admin && !session.getUser().isRoleGranted(r)) continue;
                    this.add(rows, new String[]{this.identifier(r.getName()), MetaTable.replaceNullWithEmpty(r.getComment()), "" + r.getId()});
                }
                break;
            }
            case 11: {
                if (!admin) break;
                for (Right r : this.database.getAllRights()) {
                    role = r.getGrantedRole();
                    grantee = r.getGrantee();
                    v0 = rightType = grantee.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        object = r.getGrantedObject();
                        schema = null;
                        table = null;
                        if (object != null) {
                            if (object instanceof Schema) {
                                schema = (Schema)object;
                            } else if (object instanceof Table) {
                                table = (Table)object;
                                schema = table.getSchema();
                            }
                        }
                        tableName = table != null ? this.identifier(table.getName()) : "";
                        v1 = schemaName = schema != null ? this.identifier(schema.getName()) : "";
                        if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                        this.add(rows, new String[]{this.identifier(grantee.getName()), rightType, "", r.getRights(), schemaName, tableName, "" + r.getId()});
                        continue;
                    }
                    this.add(rows, new String[]{this.identifier(grantee.getName()), rightType, this.identifier(role.getName()), "", "", "", "" + r.getId()});
                }
                break;
            }
            case 12: {
                for (SchemaObject aliasAsSchemaObject : this.database.getAllSchemaObjects(9)) {
                    alias = (FunctionAlias)aliasAsSchemaObject;
                    try {
                        methods = alias.getJavaMethods();
                    }
                    catch (DbException e) {
                        methods = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod method : methods) {
                        returnsResult = method.getDataType() == 0 ? 1 : 2;
                        this.add(rows, new String[]{catalog, alias.getSchema().getName(), this.identifier(alias.getName()), alias.getJavaClassName(), alias.getJavaMethodName(), "" + DataType.convertTypeToSQLType(method.getDataType()), DataType.getDataType((int)method.getDataType()).name, "" + method.getParameterCount(), "" + returnsResult, MetaTable.replaceNullWithEmpty(alias.getComment()), "" + alias.getId(), alias.getSource()});
                    }
                }
                for (UserAggregate agg : this.database.getAllAggregates()) {
                    returnsResult = 2;
                    this.add(rows, new String[]{catalog, "PUBLIC", this.identifier(agg.getName()), agg.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), DataType.getDataType((int)0).name, "1", "" + returnsResult, MetaTable.replaceNullWithEmpty(agg.getComment()), "" + agg.getId(), ""});
                }
                break;
            }
            case 21: {
                for (SchemaObject aliasAsSchemaObject : this.database.getAllSchemaObjects(9)) {
                    alias = (FunctionAlias)aliasAsSchemaObject;
                    try {
                        methods = alias.getJavaMethods();
                    }
                    catch (DbException e) {
                        methods = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod method : methods) {
                        if (method.getDataType() != 0) {
                            dt = DataType.getDataType(method.getDataType());
                            this.add(rows, new String[]{catalog, alias.getSchema().getName(), this.identifier(alias.getName()), alias.getJavaClassName(), alias.getJavaMethodName(), "" + method.getParameterCount(), "0", "P0", "" + DataType.convertTypeToSQLType(method.getDataType()), dt.name, "" + MathUtils.convertLongToInt(dt.defaultPrecision), "" + dt.defaultScale, "10", "2", "5", "", null});
                        }
                        columnList = method.getColumnClasses();
                        for (k = 0; k < columnList.length; ++k) {
                            if (method.hasConnectionParam() && k == 0) continue;
                            clazz = columnList[k];
                            dataType = DataType.getTypeFromClass(clazz);
                            dt = DataType.getDataType(dataType);
                            nullable = clazz.isPrimitive() != false ? 0 : 1;
                            this.add(rows, new String[]{catalog, alias.getSchema().getName(), this.identifier(alias.getName()), alias.getJavaClassName(), alias.getJavaMethodName(), "" + method.getParameterCount(), "" + (k + (method.hasConnectionParam() != false ? 0 : 1)), "P" + (k + 1), "" + DataType.convertTypeToSQLType(dt.type), dt.name, "" + MathUtils.convertLongToInt(dt.defaultPrecision), "" + dt.defaultScale, "10", "" + nullable, "1", "", null});
                        }
                    }
                }
                break;
            }
            case 13: {
                collation = this.database.getCompareMode().getName();
                for (Schema schema : this.database.getAllSchemas()) {
                    this.add(rows, new String[]{catalog, this.identifier(schema.getName()), this.identifier(schema.getOwner().getName()), "Unicode", collation, "PUBLIC".equals(schema.getName()) != false ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(schema.getComment()), "" + schema.getId()});
                }
                break;
            }
            case 14: {
                for (Right r : this.database.getAllRights()) {
                    object = r.getGrantedObject();
                    if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    this.addPrivileges(rows, r.getGrantee(), catalog, table, null, r.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right r : this.database.getAllRights()) {
                    object = r.getGrantedObject();
                    if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    grantee = r.getGrantee();
                    mask = r.getRightMask();
                    for (Column column : table.getColumns()) {
                        this.addPrivileges(rows, grantee, catalog, table, column.getName(), mask);
                    }
                }
                break;
            }
            case 16: {
                for (Locale l : Collator.getAvailableLocales()) {
                    this.add(rows, new String[]{CompareMode.getName(l), l.toString()});
                }
                break;
            }
            case 17: {
                for (Table table : this.getAllTables(session)) {
                    if (table.getTableType() != TableType.VIEW || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    view = (TableView)table;
                    this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, table.getCreateSQL(), "NONE", "NO", view.isInvalid() != false ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(view.getComment()), "" + view.getId()});
                }
                break;
            }
            case 18: {
                prepared = this.database.getInDoubtTransactions();
                if (prepared == null || !admin) break;
                for (InDoubtTransaction prep : prepared) {
                    this.add(rows, new String[]{prep.getTransactionName(), prep.getState()});
                }
                break;
            }
            case 19: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                    ref = (ConstraintReferential)constraint;
                    cols = ref.getColumns();
                    refCols = ref.getRefColumns();
                    tab = ref.getTable();
                    refTab = ref.getRefTable();
                    tableName = this.identifier(refTab.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    update = MetaTable.getRefAction(ref.getUpdateAction());
                    delete = MetaTable.getRefAction(ref.getDeleteAction());
                    for (j = 0; j < cols.length; ++j) {
                        this.add(rows, new String[]{catalog, this.identifier(refTab.getSchema().getName()), this.identifier(refTab.getName()), this.identifier(refCols[j].column.getName()), catalog, this.identifier(tab.getSchema().getName()), this.identifier(tab.getName()), this.identifier(cols[j].column.getName()), String.valueOf(j + 1), String.valueOf(update), String.valueOf(delete), this.identifier(ref.getName()), this.identifier(ref.getUniqueIndex().getName()), "7"});
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    constraintType = constraint.getConstraintType();
                    checkExpression = null;
                    indexColumns = null;
                    table = constraint.getTable();
                    if (this.hideTable(table, session)) continue;
                    index = constraint.getUniqueIndex();
                    uniqueIndexName = null;
                    if (index != null) {
                        uniqueIndexName = index.getName();
                    }
                    if (!this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    if (constraintType == Constraint.Type.CHECK) {
                        checkExpression = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (constraintType == Constraint.Type.UNIQUE || constraintType == Constraint.Type.PRIMARY_KEY) {
                        indexColumns = ((ConstraintUnique)constraint).getColumns();
                    } else if (constraintType == Constraint.Type.REFERENTIAL) {
                        indexColumns = ((ConstraintReferential)constraint).getColumns();
                    }
                    columnList = null;
                    if (indexColumns != null) {
                        buff = new StatementBuilder();
                        for (IndexColumn col : indexColumns) {
                            buff.appendExceptFirst(",");
                            buff.append(col.column.getName());
                        }
                        columnList = buff.toString();
                    }
                    this.add(rows, new String[]{catalog, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), constraintType.toString(), catalog, this.identifier(table.getSchema().getName()), tableName, uniqueIndexName, checkExpression, columnList, MetaTable.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId()});
                }
                break;
            }
            case 22: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(11)) {
                    constant = (Constant)obj;
                    expr = constant.getValue();
                    this.add(rows, new String[]{catalog, this.identifier(constant.getSchema().getName()), this.identifier(constant.getName()), "" + DataType.convertTypeToSQLType(expr.getType()), MetaTable.replaceNullWithEmpty(constant.getComment()), expr.getSQL(), "" + constant.getId()});
                }
                break;
            }
            case 23: {
                for (UserDataType dt : this.database.getAllUserDataTypes()) {
                    col = dt.getColumn();
                    this.add(rows, new String[]{catalog, "PUBLIC", this.identifier(dt.getName()), col.getDefaultSQL(), col.isNullable() != false ? "YES" : "NO", "" + col.getDataType().sqlType, "" + col.getPrecisionAsInt(), "" + col.getScale(), col.getDataType().name, "" + col.getSelectivity(), "" + col.getCheckConstraintSQL(session, "VALUE"), MetaTable.replaceNullWithEmpty(dt.getComment()), "" + dt.getCreateSQL(), "" + dt.getId()});
                }
                break;
            }
            case 24: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(4)) {
                    trigger = (TriggerObject)obj;
                    table = trigger.getTable();
                    this.add(rows, new String[]{catalog, this.identifier(trigger.getSchema().getName()), this.identifier(trigger.getName()), trigger.getTypeNameList(), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + trigger.isBefore(), trigger.getTriggerClassName(), "" + trigger.getQueueSize(), "" + trigger.isNoWait(), MetaTable.replaceNullWithEmpty(trigger.getComment()), trigger.getCreateSQL(), "" + trigger.getId()});
                }
                break;
            }
            case 25: {
                now = System.currentTimeMillis();
                for (Session s : this.database.getSessions(false)) {
                    if (!admin && s != session) continue;
                    command = s.getCurrentCommand();
                    start = s.getCurrentCommandStart();
                    if (start == 0L) {
                        start = now;
                    }
                    this.add(rows, new String[]{"" + s.getId(), s.getUser().getName(), new Timestamp(s.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(start).toString(), "" + s.containsUncommitted()});
                }
                break;
            }
            case 26: {
                for (Session s : this.database.getSessions(false)) {
                    if (!admin && s != session) continue;
                    for (Table table : s.getLocks()) {
                        this.add(rows, new String[]{table.getSchema().getName(), table.getName(), "" + s.getId(), table.isLockedExclusivelyBy(s) != false ? "WRITE" : "READ"});
                    }
                }
                break;
            }
            case 27: {
                for (String name : session.getVariableNames()) {
                    v = session.getVariable(name);
                    this.add(rows, new String[]{"@" + name, "SET @" + name + " " + v.getSQL()});
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(rows, new String[]{"TABLE " + table.getName(), table.getCreateSQL()});
                }
                path = session.getSchemaSearchPath();
                if (path != null && path.length > 0) {
                    buff = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (String p : path) {
                        buff.appendExceptFirst(", ");
                        buff.append(StringUtils.quoteIdentifier(p));
                    }
                    this.add(rows, new String[]{"SCHEMA_SEARCH_PATH", buff.toString()});
                }
                if ((schema = session.getCurrentSchemaName()) == null) break;
                this.add(rows, new String[]{"SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(schema)});
                break;
            }
            case 28: {
                control = this.database.getQueryStatisticsData();
                if (control == null) break;
                for (QueryStatisticsData.QueryEntry entry : control.getQueries()) {
                    this.add(rows, new String[]{entry.sqlStatement, "" + entry.count, "" + (double)entry.executionTimeMinNanos / 1000.0 / 1000.0, "" + (double)entry.executionTimeMaxNanos / 1000.0 / 1000.0, "" + (double)entry.executionTimeCumulativeNanos / 1000.0 / 1000.0, "" + entry.executionTimeMeanNanos / 1000.0 / 1000.0, "" + entry.getExecutionTimeStandardDeviation() / 1000.0 / 1000.0, "" + entry.rowCountMin, "" + entry.rowCountMax, "" + entry.rowCountCumulative, "" + entry.rowCountMean, "" + entry.getRowCountStandardDeviation()});
                }
                break;
            }
            case 29: {
                for (TableSynonym synonym : this.database.getAllSynonyms()) {
                    this.add(rows, new String[]{catalog, this.identifier(synonym.getSchema().getName()), this.identifier(synonym.getName()), synonym.getSynonymForName(), synonym.getSynonymForSchema().getName(), "SYNONYM", "VALID", MetaTable.replaceNullWithEmpty(synonym.getComment()), "" + synonym.getId()});
                }
                break;
            }
            case 30: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    constraintType = constraint.getConstraintType();
                    table = constraint.getTable();
                    if (this.hideTable(table, session) || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    this.add(rows, new String[]{catalog, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), constraintType.getSqlName(), catalog, this.identifier(table.getSchema().getName()), tableName, "NO", "NO"});
                }
                break;
            }
            case 31: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    constraint = (Constraint)obj;
                    constraintType = constraint.getConstraintType();
                    indexColumns = null;
                    table = constraint.getTable();
                    if (this.hideTable(table, session) || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    if (constraintType == Constraint.Type.UNIQUE || constraintType == Constraint.Type.PRIMARY_KEY) {
                        indexColumns = ((ConstraintUnique)constraint).getColumns();
                    } else if (constraintType == Constraint.Type.REFERENTIAL) {
                        indexColumns = ((ConstraintReferential)constraint).getColumns();
                    }
                    if (indexColumns == null) continue;
                    referenced = constraintType == Constraint.Type.REFERENTIAL ? MetaTable.lookupUniqueForReferential((ConstraintReferential)constraint) : null;
                    for (i = 0; i < indexColumns.length; ++i) {
                        indexColumn = indexColumns[i];
                        ordinalPosition = Integer.toString(i + 1);
                        if (constraintType != Constraint.Type.REFERENTIAL) ** GOTO lbl451
                        positionInUniqueConstraint = ordinalPosition;
                        if (referenced == null) ** GOTO lbl452
                        c = ((ConstraintReferential)constraint).getRefColumns()[i].column;
                        refColumns = referenced.getColumns();
                        for (j = 0; j < refColumns.length; ++j) {
                            if (!refColumns[j].column.equals(c)) continue;
                            positionInUniqueConstraint = Integer.toString(j + 1);
                            ** GOTO lbl452
                        }
                        ** GOTO lbl452
lbl451:
                        // 1 sources

                        positionInUniqueConstraint = null;
lbl452:
                        // 4 sources

                        this.add(rows, new String[]{catalog, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), catalog, this.identifier(table.getSchema().getName()), tableName, indexColumn.columnName, ordinalPosition, positionInUniqueConstraint});
                    }
                }
                break;
            }
            case 32: {
                for (SchemaObject obj : this.database.getAllSchemaObjects(5)) {
                    if (((Constraint)obj).getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(table = (constraint = (ConstraintReferential)obj).getTable(), session)) continue;
                    unique = MetaTable.lookupUniqueForReferential(constraint);
                    if (unique == null) {
                        unique = constraint.getUniqueIndex();
                    }
                    this.add(rows, new String[]{catalog, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), catalog, this.identifier(unique.getSchema().getName()), unique.getName(), "NONE", constraint.getUpdateAction().getSqlName(), constraint.getDeleteAction().getSqlName()});
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return rows;
    }

    private static int getRefAction(ConstraintActionType action) {
        switch (action) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + (Object)((Object)action));
    }

    private static ConstraintUnique lookupUniqueForReferential(ConstraintReferential referential) {
        Table table = referential.getRefTable();
        for (Constraint c : table.getConstraints()) {
            ConstraintUnique unique;
            if (c.getConstraintType() != Constraint.Type.UNIQUE || !(unique = (ConstraintUnique)c).getReferencedColumns(table).equals(referential.getReferencedColumns(table))) continue;
            return unique;
        }
        return null;
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s) {
    }

    private void addPrivileges(ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, int rightMask) {
        if ((rightMask & 1) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "SELECT");
        }
        if ((rightMask & 4) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "INSERT");
        }
        if ((rightMask & 8) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "UPDATE");
        }
        if ((rightMask & 2) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, String right) {
        User user;
        String isGrantable = "NO";
        if (grantee.getType() == 2 && (user = (User)grantee).isAdmin()) {
            isGrantable = "YES";
        }
        if (column == null) {
            this.add(rows, null, this.identifier(grantee.getName()), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), right, isGrantable);
        } else {
            this.add(rows, null, this.identifier(grantee.getName()), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(column), right, isGrantable);
        }
    }

    private void add(ArrayList<Row> rows, String ... strings) {
        Value[] values = new Value[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String s = strings[i];
            Value v = s == null ? ValueNull.INSTANCE : ValueString.get(s);
            Column col = this.columns[i];
            v = col.convert(v);
            values[i] = v;
        }
        Row row = this.database.createRow(values, 1);
        row.setKey(rows.size());
        rows.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> list = New.arrayList();
        if (this.metaIndex == null) {
            return list;
        }
        list.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        list.add(this.metaIndex);
        return list;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 33;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

