/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.RangeIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableType;

public class RangeTable
extends Table {
    public static final String NAME = "SYSTEM_RANGE";
    public static final String ALIAS = "GENERATE_SERIES";
    private Expression min;
    private Expression max;
    private Expression step;
    private boolean optimized;

    public RangeTable(Schema schema, Expression min, Expression max, boolean noColumns) {
        super(schema, 0, NAME, true, true);
        Column[] columnArray;
        if (noColumns) {
            columnArray = new Column[]{};
        } else {
            Column[] columnArray2 = new Column[1];
            columnArray = columnArray2;
            columnArray2[0] = new Column("X", 5);
        }
        Column[] cols = columnArray;
        this.min = min;
        this.max = max;
        this.setColumns(cols);
    }

    public RangeTable(Schema schema, Expression min, Expression max, Expression step, boolean noColumns) {
        this(schema, min, max, noColumns);
        this.step = step;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getSQL() {
        String sql = "SYSTEM_RANGE(" + this.min.getSQL() + ", " + this.max.getSQL();
        if (this.step != null) {
            sql = sql + ", " + this.step.getSQL();
        }
        return sql + ")";
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        long step = this.getStep(session);
        if (step == 0L) {
            throw DbException.get(90142);
        }
        long delta = this.getMax(session) - this.getMin(session);
        if (step > 0L ? delta < 0L : delta > 0L) {
            return 0L;
        }
        return delta / step + 1L;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        if (this.getStep(session) == 0L) {
            throw DbException.get(90142);
        }
        return new RangeIndex(this, IndexColumn.wrap(this.columns));
    }

    public long getMin(Session session) {
        this.optimize(session);
        return this.min.getValue(session).getLong();
    }

    public long getMax(Session session) {
        this.optimize(session);
        return this.max.getValue(session).getLong();
    }

    public long getStep(Session session) {
        this.optimize(session);
        if (this.step == null) {
            return 1L;
        }
        return this.step.getValue(session).getLong();
    }

    private void optimize(Session s) {
        if (!this.optimized) {
            this.min = this.min.optimize(s);
            this.max = this.max.optimize(s);
            if (this.step != null) {
                this.step = this.step.optimize(s);
            }
            this.optimized = true;
        }
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

