/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import org.h2.command.ddl.CreateSynonymData;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;

public class TableSynonym
extends SchemaObjectBase {
    private CreateSynonymData data;
    private Table synonymFor;

    public TableSynonym(CreateSynonymData data) {
        this.initSchemaObjectBase(data.schema, data.id, data.synonymName, 11);
        this.data = data;
    }

    public Table getSynonymFor() {
        return this.synonymFor;
    }

    public void updateData(CreateSynonymData data) {
        this.data = data;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.synonymFor.getCreateSQLForCopy(table, quotedName);
    }

    @Override
    public void rename(String newName) {
        throw DbException.getUnsupportedException("SYNONYM");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.synonymFor.removeSynonym(this);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public String getCreateSQL() {
        return "CREATE SYNONYM " + this.getName() + " FOR " + this.data.synonymForSchema.getName() + "." + this.data.synonymFor;
    }

    @Override
    public String getDropSQL() {
        return "DROP SYNONYM " + this.getName();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYNONYM");
    }

    public String getSynonymForName() {
        return this.data.synonymFor;
    }

    public Schema getSynonymForSchema() {
        return this.data.synonymForSchema;
    }

    public boolean isInvalid() {
        return this.synonymFor.isValid();
    }

    public void updateSynonymFor() {
        if (this.synonymFor != null) {
            this.synonymFor.removeSynonym(this);
        }
        this.synonymFor = this.data.synonymForSchema.getTableOrView(this.data.session, this.data.synonymFor);
        this.synonymFor.addSynonym(this);
    }
}

