/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.Driver;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class RunScript
extends Tool {
    private boolean showResults;
    private boolean checkResults;

    public static void main(String ... args) throws SQLException {
        new RunScript().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String url = null;
        String user = "";
        String password = "";
        String script = "backup.sql";
        String options = null;
        boolean continueOnError = false;
        boolean showTime = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-url")) {
                url = args[++i];
                continue;
            }
            if (arg.equals("-user")) {
                user = args[++i];
                continue;
            }
            if (arg.equals("-password")) {
                password = args[++i];
                continue;
            }
            if (arg.equals("-continueOnError")) {
                continueOnError = true;
                continue;
            }
            if (arg.equals("-checkResults")) {
                this.checkResults = true;
                continue;
            }
            if (arg.equals("-showResults")) {
                this.showResults = true;
                continue;
            }
            if (arg.equals("-script")) {
                script = args[++i];
                continue;
            }
            if (arg.equals("-time")) {
                showTime = true;
                continue;
            }
            if (arg.equals("-driver")) {
                String driver = args[++i];
                JdbcUtils.loadUserClass(driver);
                continue;
            }
            if (arg.equals("-options")) {
                StringBuilder buff = new StringBuilder();
                ++i;
                while (i < args.length) {
                    buff.append(' ').append(args[i]);
                    ++i;
                }
                options = buff.toString();
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        if (url == null) {
            this.showUsage();
            throw new SQLException("URL not set");
        }
        long time = System.nanoTime();
        if (options != null) {
            RunScript.processRunscript(url, user, password, script, options);
        } else {
            this.process(url, user, password, script, null, continueOnError);
        }
        if (showTime) {
            time = System.nanoTime() - time;
            this.out.println("Done in " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        }
    }

    public static ResultSet execute(Connection conn, Reader reader) throws SQLException {
        String sql;
        Statement stat = conn.createStatement();
        ResultSet rs = null;
        ScriptReader r = new ScriptReader(reader);
        while ((sql = r.readStatement()) != null) {
            boolean resultSet;
            if (sql.trim().length() == 0 || !(resultSet = stat.execute(sql))) continue;
            if (rs != null) {
                rs.close();
                rs = null;
            }
            rs = stat.getResultSet();
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Connection conn, String fileName, boolean continueOnError, Charset charset) throws SQLException, IOException {
        InputStream in = FileUtils.newInputStream(fileName);
        String path = FileUtils.getParent(fileName);
        try {
            in = new BufferedInputStream(in, 4096);
            InputStreamReader reader = new InputStreamReader(in, charset);
            this.process(conn, continueOnError, path, reader, charset);
        }
        finally {
            IOUtils.closeSilently(in);
        }
    }

    private void process(Connection conn, boolean continueOnError, String path, Reader reader, Charset charset) throws SQLException, IOException {
        String sql;
        Statement stat = conn.createStatement();
        ScriptReader r = new ScriptReader(reader);
        while ((sql = r.readStatement()) != null) {
            String trim = sql.trim();
            if (trim.length() == 0) continue;
            if (trim.startsWith("@") && StringUtils.toUpperEnglish(trim).startsWith("@INCLUDE")) {
                sql = trim;
                if (!FileUtils.isAbsolute(sql = sql.substring("@INCLUDE".length()).trim())) {
                    sql = path + SysProperties.FILE_SEPARATOR + sql;
                }
                this.process(conn, sql, continueOnError, charset);
                continue;
            }
            try {
                if (this.showResults && !trim.startsWith("-->")) {
                    this.out.print(sql + ";");
                }
                if (this.showResults || this.checkResults) {
                    boolean query = stat.execute(sql);
                    if (!query) continue;
                    ResultSet rs = stat.getResultSet();
                    int columns = rs.getMetaData().getColumnCount();
                    StringBuilder buff = new StringBuilder();
                    while (rs.next()) {
                        buff.append("\n-->");
                        for (int i = 0; i < columns; ++i) {
                            String s = rs.getString(i + 1);
                            if (s != null) {
                                s = StringUtils.replaceAll(s, "\r\n", "\n");
                                s = StringUtils.replaceAll(s, "\n", "\n-->    ");
                                s = StringUtils.replaceAll(s, "\r", "\r-->    ");
                            }
                            buff.append(' ').append(s);
                        }
                    }
                    buff.append("\n;");
                    String result = buff.toString();
                    if (this.showResults) {
                        this.out.print(result);
                    }
                    if (!this.checkResults) continue;
                    String expected = r.readStatement() + ";";
                    expected = StringUtils.replaceAll(expected, "\r\n", "\n");
                    if ((expected = StringUtils.replaceAll(expected, "\r", "\n")).equals(result)) continue;
                    expected = StringUtils.replaceAll(expected, " ", "+");
                    result = StringUtils.replaceAll(result, " ", "+");
                    throw new SQLException("Unexpected output for:\n" + sql.trim() + "\nGot:\n" + result + "\nExpected:\n" + expected);
                }
                stat.execute(sql);
            }
            catch (Exception e) {
                if (continueOnError) {
                    e.printStackTrace(this.out);
                    continue;
                }
                throw DbException.toSQLException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRunscript(String url, String user, String password, String fileName, String options) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            String sql = "RUNSCRIPT FROM '" + fileName + "' " + options;
            stat.execute(sql);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(conn);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
    }

    public static void execute(String url, String user, String password, String fileName, Charset charset, boolean continueOnError) throws SQLException {
        new RunScript().process(url, user, password, fileName, charset, continueOnError);
    }

    void process(String url, String user, String password, String fileName, Charset charset, boolean continueOnError) throws SQLException {
        try {
            Driver.load();
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            try (Connection conn = DriverManager.getConnection(url, user, password);){
                this.process(conn, fileName, continueOnError, charset);
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, fileName);
        }
    }
}

