/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.server.web.ConnectionInfo;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.ScriptReader;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class Shell
extends Tool
implements Runnable {
    private static final int MAX_ROW_BUFFER = 5000;
    private static final int HISTORY_COUNT = 20;
    private static final char BOX_VERTICAL = '|';
    private PrintStream err = System.err;
    private InputStream in = System.in;
    private BufferedReader reader;
    private Connection conn;
    private Statement stat;
    private boolean listMode;
    private int maxColumnSize = 100;
    private final ArrayList<String> history = New.arrayList();
    private boolean stopHide;
    private String serverPropertiesDir = "~";

    public static void main(String ... args) throws SQLException {
        new Shell().runTool(args);
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setInReader(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String url = null;
        String user = "";
        String password = "";
        String sql = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-url")) {
                url = args[++i];
                continue;
            }
            if (arg.equals("-user")) {
                user = args[++i];
                continue;
            }
            if (arg.equals("-password")) {
                password = args[++i];
                continue;
            }
            if (arg.equals("-driver")) {
                String driver = args[++i];
                JdbcUtils.loadUserClass(driver);
                continue;
            }
            if (arg.equals("-sql")) {
                sql = args[++i];
                continue;
            }
            if (arg.equals("-properties")) {
                this.serverPropertiesDir = args[++i];
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            if (arg.equals("-list")) {
                this.listMode = true;
                continue;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        if (url != null) {
            Driver.load();
            this.conn = DriverManager.getConnection(url, user, password);
            this.stat = this.conn.createStatement();
        }
        if (sql == null) {
            this.promptLoop();
        } else {
            String s;
            ScriptReader r = new ScriptReader(new StringReader(sql));
            while ((s = r.readStatement()) != null) {
                this.execute(s);
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    public void runTool(Connection conn, String ... args) throws SQLException {
        this.conn = conn;
        this.stat = conn.createStatement();
        this.runTool(args);
    }

    private void showHelp() {
        this.println("Commands are case insensitive; SQL statements end with ';'");
        this.println("help or ?      Display this help");
        this.println("list           Toggle result list / stack trace mode");
        this.println("maxwidth       Set maximum column width (default is 100)");
        this.println("autocommit     Enable or disable autocommit");
        this.println("history        Show the last 20 statements");
        this.println("quit or exit   Close the connection and exit");
        this.println("");
    }

    private void promptLoop() {
        this.println("");
        this.println("Welcome to H2 Shell " + Constants.getFullVersion());
        this.println("Exit with Ctrl+C");
        if (this.conn != null) {
            this.showHelp();
        }
        String statement = null;
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.in));
        }
        block8: while (true) {
            try {
                while (true) {
                    String lower;
                    if (this.conn == null) {
                        this.connect();
                        this.showHelp();
                    }
                    if (statement == null) {
                        this.print("sql> ");
                    } else {
                        this.print("...> ");
                    }
                    String line = this.readLine();
                    if (line == null) break block8;
                    String trimmed = line.trim();
                    if (trimmed.length() == 0) continue;
                    boolean end = trimmed.endsWith(";");
                    if (end) {
                        line = line.substring(0, line.lastIndexOf(59));
                        trimmed = trimmed.substring(0, trimmed.length() - 1);
                    }
                    if ("exit".equals(lower = StringUtils.toLowerEnglish(trimmed)) || "quit".equals(lower)) break block8;
                    if ("help".equals(lower) || "?".equals(lower)) {
                        this.showHelp();
                        continue;
                    }
                    if ("list".equals(lower)) {
                        this.listMode = !this.listMode;
                        this.println("Result list mode is now " + (this.listMode ? "on" : "off"));
                        continue;
                    }
                    if ("history".equals(lower)) {
                        int size = this.history.size();
                        for (int i = 0; i < size; ++i) {
                            String s = this.history.get(i);
                            s = s.replace('\n', ' ').replace('\r', ' ');
                            this.println("#" + (1 + i) + ": " + s);
                        }
                        if (!this.history.isEmpty()) {
                            this.println("To re-run a statement, type the number and press and enter");
                            continue;
                        }
                        this.println("No history");
                        continue;
                    }
                    if (lower.startsWith("autocommit")) {
                        if ("true".equals(lower = lower.substring("autocommit".length()).trim())) {
                            this.conn.setAutoCommit(true);
                        } else if ("false".equals(lower)) {
                            this.conn.setAutoCommit(false);
                        } else {
                            this.println("Usage: autocommit [true|false]");
                        }
                        this.println("Autocommit is now " + this.conn.getAutoCommit());
                        continue;
                    }
                    if (lower.startsWith("maxwidth")) {
                        lower = lower.substring("maxwidth".length()).trim();
                        try {
                            this.maxColumnSize = Integer.parseInt(lower);
                        }
                        catch (NumberFormatException e) {
                            this.println("Usage: maxwidth <integer value>");
                        }
                        this.println("Maximum column width is now " + this.maxColumnSize);
                        continue;
                    }
                    boolean addToHistory = true;
                    if (statement == null) {
                        if (StringUtils.isNumber(line)) {
                            int pos = Integer.parseInt(line);
                            if (pos == 0 || pos > this.history.size()) {
                                this.println("Not found");
                            } else {
                                statement = this.history.get(pos - 1);
                                addToHistory = false;
                                this.println(statement);
                                end = true;
                            }
                        } else {
                            statement = line;
                        }
                    } else {
                        statement = statement + "\n" + line;
                    }
                    if (!end) continue;
                    if (addToHistory) {
                        this.history.add(0, statement);
                        if (this.history.size() > 20) {
                            this.history.remove(20);
                        }
                    }
                    this.execute(statement);
                    statement = null;
                }
            }
            catch (SQLException e) {
                this.println("SQL Exception: " + e.getMessage());
                statement = null;
                continue;
            }
            catch (IOException e) {
                this.println(e.getMessage());
            }
            catch (Exception e) {
                this.println("Exception: " + e.toString());
                e.printStackTrace(this.err);
            }
            break;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
                this.println("Connection closed");
            }
            catch (SQLException e) {
                this.println("SQL Exception: " + e.getMessage());
                e.printStackTrace(this.err);
            }
        }
    }

    private void connect() throws IOException, SQLException {
        String url = "jdbc:h2:~/test";
        String user = "";
        String driver = null;
        try {
            String d;
            Properties prop = "null".equals(this.serverPropertiesDir) ? new Properties() : SortedProperties.loadProperties(this.serverPropertiesDir + "/" + ".h2.server.properties");
            String data = null;
            boolean found = false;
            int i = 0;
            while ((d = prop.getProperty(String.valueOf(i))) != null) {
                found = true;
                data = d;
                ++i;
            }
            if (found) {
                ConnectionInfo info = new ConnectionInfo(data);
                url = info.url;
                user = info.user;
                driver = info.driver;
            }
        }
        catch (IOException prop) {
            // empty catch block
        }
        this.println("[Enter]   " + url);
        this.print("URL       ");
        url = this.readLine(url).trim();
        if (driver == null) {
            driver = JdbcUtils.getDriver(url);
        }
        if (driver != null) {
            this.println("[Enter]   " + driver);
        }
        this.print("Driver    ");
        driver = this.readLine(driver).trim();
        this.println("[Enter]   " + user);
        this.print("User      ");
        user = this.readLine(user);
        this.println("[Enter]   Hide");
        this.print("Password  ");
        String password = this.readLine();
        if (password.length() == 0) {
            password = this.readPassword();
        }
        this.conn = JdbcUtils.getConnection(driver, url, user, password);
        this.stat = this.conn.createStatement();
        this.println("Connected");
    }

    protected void print(String s) {
        this.out.print(s);
        this.out.flush();
    }

    private void println(String s) {
        this.out.println(s);
        this.out.flush();
    }

    private String readPassword() throws IOException {
        try {
            Object console = Utils.callStaticMethod("java.lang.System.console", new Object[0]);
            this.print("Password  ");
            char[] password = (char[])Utils.callMethod(console, "readPassword", new Object[0]);
            return password == null ? null : new String(password);
        }
        catch (Exception console) {
            Thread passwordHider = new Thread((Runnable)this, "Password hider");
            this.stopHide = false;
            passwordHider.start();
            this.print("Password  > ");
            String p = this.readLine();
            this.stopHide = true;
            try {
                passwordHider.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.print("\b\b");
            return p;
        }
    }

    @Override
    public void run() {
        while (!this.stopHide) {
            this.print("\b\b><");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String readLine(String defaultValue) throws IOException {
        String s = this.readLine();
        return s.length() == 0 ? defaultValue : s;
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            throw new IOException("Aborted");
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql) {
        block7: {
            if (sql.trim().length() == 0) {
                return;
            }
            long time = System.nanoTime();
            try {
                ResultSet rs;
                block6: {
                    rs = null;
                    try {
                        if (this.stat.execute(sql)) {
                            rs = this.stat.getResultSet();
                            int rowCount = this.printResult(rs, this.listMode);
                            time = System.nanoTime() - time;
                            this.println("(" + rowCount + (rowCount == 1 ? " row, " : " rows, ") + TimeUnit.NANOSECONDS.toMillis(time) + " ms)");
                            break block6;
                        }
                        int updateCount = this.stat.getUpdateCount();
                        time = System.nanoTime() - time;
                        this.println("(Update count: " + updateCount + ", " + TimeUnit.NANOSECONDS.toMillis(time) + " ms)");
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeSilently(rs);
                        throw throwable;
                    }
                }
                JdbcUtils.closeSilently(rs);
            }
            catch (SQLException e) {
                this.println("Error: " + e.toString());
                if (!this.listMode) break block7;
                e.printStackTrace(this.err);
            }
        }
    }

    private int printResult(ResultSet rs, boolean asList) throws SQLException {
        if (asList) {
            return this.printResultAsList(rs);
        }
        return this.printResultAsTable(rs);
    }

    private int printResultAsTable(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int len = meta.getColumnCount();
        boolean truncated = false;
        ArrayList<String[]> rows = New.arrayList();
        String[] columns = new String[len];
        for (int i = 0; i < len; ++i) {
            String s = meta.getColumnLabel(i + 1);
            columns[i] = s == null ? "" : s;
        }
        rows.add(columns);
        int rowCount = 0;
        while (rs.next()) {
            truncated |= this.loadRow(rs, len, rows);
            if (++rowCount <= 5000) continue;
            this.printRows(rows, len);
            rows.clear();
        }
        this.printRows(rows, len);
        rows.clear();
        if (truncated) {
            this.println("(data is partially truncated)");
        }
        return rowCount;
    }

    private boolean loadRow(ResultSet rs, int len, ArrayList<String[]> rows) throws SQLException {
        boolean truncated = false;
        String[] row = new String[len];
        for (int i = 0; i < len; ++i) {
            String s = rs.getString(i + 1);
            if (s == null) {
                s = "null";
            }
            if (len > 1 && s.length() > this.maxColumnSize) {
                s = s.substring(0, this.maxColumnSize);
                truncated = true;
            }
            row[i] = s;
        }
        rows.add(row);
        return truncated;
    }

    private int[] printRows(ArrayList<String[]> rows, int len) {
        int[] columnSizes = new int[len];
        for (int i = 0; i < len; ++i) {
            int max = 0;
            for (String[] row : rows) {
                max = Math.max(max, row[i].length());
            }
            if (len > 1) {
                Math.min(this.maxColumnSize, max);
            }
            columnSizes[i] = max;
        }
        for (String[] row : rows) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buff.append(' ').append('|').append(' ');
                }
                String s = row[i];
                buff.append(s);
                if (i >= len - 1) continue;
                for (int j = s.length(); j < columnSizes[i]; ++j) {
                    buff.append(' ');
                }
            }
            this.println(buff.toString());
        }
        return columnSizes;
    }

    private int printResultAsList(ResultSet rs) throws SQLException {
        String label;
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        int longestLabel = 0;
        int len = meta.getColumnCount();
        String[] columns = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            String s;
            columns[i2] = s = meta.getColumnLabel(i2 + 1);
            longestLabel = Math.max(longestLabel, s.length());
        }
        StringBuilder buff = new StringBuilder();
        int rowCount = 0;
        while (rs.next()) {
            buff.setLength(0);
            if (++rowCount > 1) {
                this.println("");
            }
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    buff.append('\n');
                }
                label = columns[i];
                buff.append(label);
                for (int j = label.length(); j < longestLabel; ++j) {
                    buff.append(' ');
                }
                buff.append(": ").append(rs.getString(i + 1));
            }
            this.println(buff.toString());
        }
        if (rowCount == 0) {
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    buff.append('\n');
                }
                label = columns[i];
                buff.append(label);
            }
            this.println(buff.toString());
        }
        return rowCount;
    }
}

