/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.UUID;

public final class Bits {
    public static int compareNotNullSigned(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            byte b = data1[i];
            byte b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    public static int compareNotNullUnsigned(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            int b = data1[i] & 0xFF;
            int b2 = data2[i] & 0xFF;
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    public static int readInt(byte[] buff, int pos) {
        return (buff[pos++] << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos] & 0xFF);
    }

    public static long readLong(byte[] buff, int pos) {
        return ((long)Bits.readInt(buff, pos) << 32) + ((long)Bits.readInt(buff, pos + 4) & 0xFFFFFFFFL);
    }

    public static byte[] uuidToBytes(long msb, long lsb) {
        byte[] buff = new byte[16];
        for (int i = 0; i < 8; ++i) {
            buff[i] = (byte)(msb >> 8 * (7 - i) & 0xFFL);
            buff[8 + i] = (byte)(lsb >> 8 * (7 - i) & 0xFFL);
        }
        return buff;
    }

    public static byte[] uuidToBytes(UUID uuid) {
        return Bits.uuidToBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static void writeInt(byte[] buff, int pos, int x) {
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos] = (byte)x;
    }

    public static void writeLong(byte[] buff, int pos, long x) {
        Bits.writeInt(buff, pos, (int)(x >> 32));
        Bits.writeInt(buff, pos + 4, (int)x);
    }

    private Bits() {
    }
}

