/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.util.ColumnNamerConfiguration;

public class ColumnNamer {
    private static final String DEFAULT_COLUMN_NAME = "DEFAULT";
    private final ColumnNamerConfiguration configuration;
    private final Session session;
    private final Set<String> existingColumnNames = new HashSet<String>();

    public ColumnNamer(Session session) {
        this.session = session;
        if (this.session != null && this.session.getColumnNamerConfiguration() != null) {
            this.configuration = this.session.getColumnNamerConfiguration();
        } else {
            this.configuration = ColumnNamerConfiguration.getDefault();
            if (session != null) {
                session.setColumnNamerConfiguration(this.configuration);
            }
        }
    }

    public String getColumnName(Expression columnExp, int indexOfColumn, String[] columnNameOverides) {
        String columnNameOverride = null;
        if (columnNameOverides != null && columnNameOverides.length > indexOfColumn) {
            columnNameOverride = columnNameOverides[indexOfColumn];
        }
        return this.getColumnName(columnExp, indexOfColumn, columnNameOverride);
    }

    public String getColumnName(Expression columnExp, int indexOfColumn, String columnNameOverride) {
        String columnName = null;
        if (columnNameOverride != null) {
            columnName = columnNameOverride;
            if (!this.isAllowableColumnName(columnName)) {
                columnName = this.fixColumnName(columnName);
            }
            if (!this.isAllowableColumnName(columnName)) {
                columnName = null;
            }
        }
        if (columnName == null && columnExp.getAlias() != null && !DEFAULT_COLUMN_NAME.equals(columnExp.getAlias())) {
            columnName = columnExp.getAlias();
            if (!this.isAllowableColumnName(columnName)) {
                columnName = this.fixColumnName(columnName);
            }
            if (!this.isAllowableColumnName(columnName)) {
                columnName = null;
            }
        }
        if (columnName == null && columnExp.getColumnName() != null && !DEFAULT_COLUMN_NAME.equals(columnExp.getColumnName())) {
            columnName = columnExp.getColumnName();
            if (!this.isAllowableColumnName(columnName)) {
                columnName = this.fixColumnName(columnName);
            }
            if (!this.isAllowableColumnName(columnName)) {
                columnName = null;
            }
        }
        if (columnName == null && columnExp.getSQL() != null && !DEFAULT_COLUMN_NAME.equals(columnExp.getSQL())) {
            columnName = columnExp.getSQL();
            if (!this.isAllowableColumnName(columnName)) {
                columnName = this.fixColumnName(columnName);
            }
            if (!this.isAllowableColumnName(columnName)) {
                columnName = null;
            }
        }
        if (columnName == null) {
            columnName = this.configuration.getDefaultColumnNamePattern().replace("$$", "" + (indexOfColumn + 1));
        }
        if (this.existingColumnNames.contains(columnName) && this.configuration.isGenerateUniqueColumnNames()) {
            columnName = this.generateUniqueName(columnName);
        }
        this.existingColumnNames.add(columnName);
        return columnName;
    }

    private String generateUniqueName(String columnName) {
        String newColumnName = columnName;
        int loopCount = 2;
        while (this.existingColumnNames.contains(newColumnName)) {
            String loopCountString = "_" + loopCount;
            newColumnName = columnName.substring(0, Math.min(columnName.length(), this.configuration.getMaxIdentiferLength() - loopCountString.length())) + loopCountString;
            ++loopCount;
        }
        return newColumnName;
    }

    private boolean isAllowableColumnName(String proposedName) {
        if (proposedName == null) {
            return false;
        }
        if (proposedName.length() > this.configuration.getMaxIdentiferLength() || proposedName.length() == 0) {
            return false;
        }
        Matcher match = this.configuration.getCompiledRegularExpressionMatchAllowed().matcher(proposedName);
        return match.matches();
    }

    private String fixColumnName(String proposedName) {
        Matcher match = this.configuration.getCompiledRegularExpressionMatchDisallowed().matcher(proposedName);
        proposedName = match.replaceAll("");
        if (proposedName.length() > this.configuration.getMaxIdentiferLength()) {
            proposedName = proposedName.substring(0, this.configuration.getMaxIdentiferLength());
        }
        return proposedName;
    }

    public ColumnNamerConfiguration getConfiguration() {
        return this.configuration;
    }
}

