/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.h2.tools.SimpleResultSet;
import org.h2.util.New;

public final class MergedResultSet {
    private final ArrayList<Map<ColumnInfo, Object>> data = New.arrayList();
    private final ArrayList<ColumnInfo> columns = New.arrayList();

    public void add(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        if (cols == 0) {
            return;
        }
        ColumnInfo[] info = new ColumnInfo[cols];
        for (int i = 1; i <= cols; ++i) {
            ColumnInfo ci;
            info[i - 1] = ci = new ColumnInfo(meta.getColumnName(i), meta.getColumnType(i), meta.getPrecision(i), meta.getScale(i));
            if (this.columns.contains(ci)) continue;
            this.columns.add(ci);
        }
        while (rs.next()) {
            if (cols == 1) {
                this.data.add(Collections.singletonMap(info[0], rs.getObject(1)));
                continue;
            }
            HashMap<ColumnInfo, Object> map = new HashMap<ColumnInfo, Object>();
            for (int i = 1; i <= cols; ++i) {
                ColumnInfo ci = info[i - 1];
                map.put(ci, rs.getObject(i));
            }
            this.data.add(map);
        }
    }

    public SimpleResultSet getResult() {
        SimpleResultSet rs = new SimpleResultSet();
        for (ColumnInfo columnInfo : this.columns) {
            rs.addColumn(columnInfo.name, columnInfo.type, columnInfo.precision, columnInfo.scale);
        }
        for (Map map : this.data) {
            Object[] row = new Object[this.columns.size()];
            for (Map.Entry entry : map.entrySet()) {
                row[this.columns.indexOf(entry.getKey())] = entry.getValue();
            }
            rs.addRow(row);
        }
        return rs;
    }

    public String toString() {
        return this.columns + ": " + this.data.size();
    }

    private static final class ColumnInfo {
        final String name;
        final int type;
        final int precision;
        final int scale;

        ColumnInfo(String name, int type, int precision, int scale) {
            this.name = name;
            this.type = type;
            this.precision = precision;
            this.scale = scale;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnInfo other = (ColumnInfo)obj;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

