/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.h2.api.TimestampWithTimeZone;
import org.h2.engine.Mode;
import org.h2.engine.SessionInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.LocalDateTimeUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class DataType {
    public static final int TYPE_RESULT_SET = -10;
    public static final Class<?> GEOMETRY_CLASS;
    private static final String GEOMETRY_CLASS_NAME = "org.locationtech.jts.geom.Geometry";
    private static final ArrayList<DataType> TYPES;
    private static final HashMap<String, DataType> TYPES_BY_NAME;
    private static final HashMap<Integer, DataType> TYPES_BY_VALUE_TYPE;
    public int type;
    public String name;
    public int sqlType;
    public int sqlTypePos;
    public long maxPrecision;
    public int minScale;
    public int maxScale;
    public boolean decimal;
    public String prefix;
    public String suffix;
    public String params;
    public boolean autoIncrement;
    public boolean caseSensitive;
    public boolean supportsPrecision;
    public boolean supportsScale;
    public long defaultPrecision;
    public int defaultScale;
    public int defaultDisplaySize;
    public boolean hidden;
    public int memory;

    private static void addDecimal() {
        DataType.add(6, 3, DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"DECIMAL", "DEC"}, 64);
    }

    private static void addNumeric() {
        DataType.add(6, 2, DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"NUMERIC", "NUMBER"}, 64);
    }

    private static void add(int type, int sqlType, DataType dataType, String[] names, int memory) {
        for (int i = 0; i < names.length; ++i) {
            DataType dt = new DataType();
            dt.type = type;
            dt.sqlType = sqlType;
            dt.name = names[i];
            dt.autoIncrement = dataType.autoIncrement;
            dt.decimal = dataType.decimal;
            dt.maxPrecision = dataType.maxPrecision;
            dt.maxScale = dataType.maxScale;
            dt.minScale = dataType.minScale;
            dt.params = dataType.params;
            dt.prefix = dataType.prefix;
            dt.suffix = dataType.suffix;
            dt.supportsPrecision = dataType.supportsPrecision;
            dt.supportsScale = dataType.supportsScale;
            dt.defaultPrecision = dataType.defaultPrecision;
            dt.defaultScale = dataType.defaultScale;
            dt.defaultDisplaySize = dataType.defaultDisplaySize;
            dt.caseSensitive = dataType.caseSensitive;
            dt.hidden = i > 0;
            dt.memory = memory;
            for (DataType t2 : TYPES) {
                if (t2.sqlType != dt.sqlType) continue;
                ++dt.sqlTypePos;
            }
            TYPES_BY_NAME.put(dt.name, dt);
            if (TYPES_BY_VALUE_TYPE.get(type) == null) {
                TYPES_BY_VALUE_TYPE.put(type, dt);
            }
            TYPES.add(dt);
        }
    }

    private static DataType createDecimal(int maxPrecision, int defaultPrecision, int defaultScale, int defaultDisplaySize, boolean needsPrecisionAndScale, boolean autoInc) {
        DataType dataType = new DataType();
        dataType.maxPrecision = maxPrecision;
        dataType.defaultPrecision = defaultPrecision;
        dataType.defaultScale = defaultScale;
        dataType.defaultDisplaySize = defaultDisplaySize;
        if (needsPrecisionAndScale) {
            dataType.params = "PRECISION,SCALE";
            dataType.supportsPrecision = true;
            dataType.supportsScale = true;
        }
        dataType.decimal = true;
        dataType.autoIncrement = autoInc;
        return dataType;
    }

    private static DataType createDate(int maxPrecision, int precision, String prefix, boolean supportsScale, int scale, int maxScale) {
        DataType dataType = new DataType();
        dataType.prefix = prefix + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = maxPrecision;
        dataType.supportsScale = supportsScale;
        dataType.maxScale = maxScale;
        dataType.defaultPrecision = precision;
        dataType.defaultScale = scale;
        dataType.defaultDisplaySize = precision;
        return dataType;
    }

    private static DataType createString(boolean caseSensitive) {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "LENGTH";
        dataType.caseSensitive = caseSensitive;
        dataType.supportsPrecision = true;
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        dataType.defaultDisplaySize = Integer.MAX_VALUE;
        return dataType;
    }

    private static DataType createLob() {
        DataType t = DataType.createString(true);
        t.maxPrecision = Long.MAX_VALUE;
        t.defaultPrecision = Long.MAX_VALUE;
        return t;
    }

    public static ArrayList<DataType> getTypes() {
        return TYPES;
    }

    public static Value readValue(SessionInterface session, ResultSet rs, int columnIndex, int type) {
        try {
            Value v;
            switch (type) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 12: {
                    Object o = rs.getObject(columnIndex);
                    if (o instanceof byte[]) {
                        v = ValueBytes.getNoCopy((byte[])o);
                        break;
                    }
                    if (o != null) {
                        v = ValueUuid.get((UUID)o);
                        break;
                    }
                    v = ValueNull.INSTANCE;
                    break;
                }
                case 20: {
                    Object o = rs.getObject(columnIndex);
                    if (o instanceof UUID) {
                        v = ValueUuid.get((UUID)o);
                        break;
                    }
                    if (o != null) {
                        v = ValueUuid.get((byte[])o);
                        break;
                    }
                    v = ValueNull.INSTANCE;
                    break;
                }
                case 1: {
                    boolean value = rs.getBoolean(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(value);
                    break;
                }
                case 2: {
                    byte value = rs.getByte(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueByte.get(value);
                    break;
                }
                case 10: {
                    Date value = rs.getDate(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : ValueDate.get(value);
                    break;
                }
                case 9: {
                    Time value = rs.getTime(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : ValueTime.get(value);
                    break;
                }
                case 11: {
                    Timestamp value = rs.getTimestamp(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : ValueTimestamp.get(value);
                    break;
                }
                case 24: {
                    TimestampWithTimeZone value = (TimestampWithTimeZone)rs.getObject(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : ValueTimestampTimeZone.get(value);
                    break;
                }
                case 6: {
                    BigDecimal value = rs.getBigDecimal(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : ValueDecimal.get(value);
                    break;
                }
                case 7: {
                    double value = rs.getDouble(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(value);
                    break;
                }
                case 8: {
                    float value = rs.getFloat(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueFloat.get(value);
                    break;
                }
                case 4: {
                    int value = rs.getInt(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueInt.get(value);
                    break;
                }
                case 5: {
                    long value = rs.getLong(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueLong.get(value);
                    break;
                }
                case 3: {
                    short value = rs.getShort(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueShort.get(value);
                    break;
                }
                case 14: {
                    String s = rs.getString(columnIndex);
                    v = s == null ? ValueNull.INSTANCE : ValueStringIgnoreCase.get(s);
                    break;
                }
                case 21: {
                    String s = rs.getString(columnIndex);
                    v = s == null ? ValueNull.INSTANCE : ValueStringFixed.get(s);
                    break;
                }
                case 13: {
                    String s = rs.getString(columnIndex);
                    v = s == null ? ValueNull.INSTANCE : ValueString.get(s);
                    break;
                }
                case 16: {
                    Reader in;
                    String s;
                    v = session == null ? ((s = rs.getString(columnIndex)) == null ? ValueNull.INSTANCE : ValueLobDb.createSmallLob(16, s.getBytes(StandardCharsets.UTF_8))) : ((in = rs.getCharacterStream(columnIndex)) == null ? ValueNull.INSTANCE : session.getDataHandler().getLobStorage().createClob(new BufferedReader(in), -1L));
                    if (session == null) break;
                    session.addTemporaryLob(v);
                    break;
                }
                case 15: {
                    if (session == null) {
                        byte[] buff = rs.getBytes(columnIndex);
                        return buff == null ? ValueNull.INSTANCE : ValueLobDb.createSmallLob(15, buff);
                    }
                    InputStream in = rs.getBinaryStream(columnIndex);
                    v = in == null ? ValueNull.INSTANCE : session.getDataHandler().getLobStorage().createBlob(in, -1L);
                    session.addTemporaryLob(v);
                    break;
                }
                case 19: {
                    if (SysProperties.serializeJavaObject) {
                        byte[] buff = rs.getBytes(columnIndex);
                        v = buff == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(null, buff, session.getDataHandler());
                        break;
                    }
                    Object o = rs.getObject(columnIndex);
                    v = o == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(o, null, session.getDataHandler());
                    break;
                }
                case 17: {
                    Array array = rs.getArray(columnIndex);
                    if (array == null) {
                        return ValueNull.INSTANCE;
                    }
                    Object[] list = (Object[])array.getArray();
                    if (list == null) {
                        return ValueNull.INSTANCE;
                    }
                    int len = list.length;
                    Value[] values = new Value[len];
                    for (int i = 0; i < len; ++i) {
                        values[i] = DataType.convertToValue(session, list[i], 0);
                    }
                    v = ValueArray.get(values);
                    break;
                }
                case 25: {
                    int value = rs.getInt(columnIndex);
                    v = rs.wasNull() ? ValueNull.INSTANCE : ValueInt.get(value);
                    break;
                }
                case 18: {
                    ResultSet x = (ResultSet)rs.getObject(columnIndex);
                    if (x == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueResultSet.get(x);
                }
                case 22: {
                    Object x = rs.getObject(columnIndex);
                    if (x == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueGeometry.getFromGeometry(x);
                }
                default: {
                    if (JdbcUtils.customDataTypesHandler != null) {
                        return JdbcUtils.customDataTypesHandler.getValue(type, rs.getObject(columnIndex), session.getDataHandler());
                    }
                    throw DbException.throwInternalError("type=" + type);
                }
            }
            return v;
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    public static String getTypeClassName(int type) {
        switch (type) {
            case 1: {
                return Boolean.class.getName();
            }
            case 2: {
                return Byte.class.getName();
            }
            case 3: {
                return Short.class.getName();
            }
            case 4: 
            case 25: {
                return Integer.class.getName();
            }
            case 5: {
                return Long.class.getName();
            }
            case 6: {
                return BigDecimal.class.getName();
            }
            case 9: {
                return Time.class.getName();
            }
            case 10: {
                return Date.class.getName();
            }
            case 11: {
                return Timestamp.class.getName();
            }
            case 24: {
                return TimestampWithTimeZone.class.getName();
            }
            case 12: 
            case 20: {
                return byte[].class.getName();
            }
            case 13: 
            case 14: 
            case 21: {
                return String.class.getName();
            }
            case 15: {
                return Blob.class.getName();
            }
            case 16: {
                return Clob.class.getName();
            }
            case 7: {
                return Double.class.getName();
            }
            case 8: {
                return Float.class.getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return Object.class.getName();
            }
            case -1: {
                return Object.class.getName();
            }
            case 17: {
                return Array.class.getName();
            }
            case 18: {
                return ResultSet.class.getName();
            }
            case 22: {
                return GEOMETRY_CLASS_NAME;
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getDataTypeClassName(type);
        }
        throw DbException.throwInternalError("type=" + type);
    }

    public static DataType getDataType(int type) {
        if (type == -1) {
            throw DbException.get(50004, "?");
        }
        DataType dt = TYPES_BY_VALUE_TYPE.get(type);
        if (dt == null && JdbcUtils.customDataTypesHandler != null) {
            dt = JdbcUtils.customDataTypesHandler.getDataTypeById(type);
        }
        if (dt == null) {
            dt = TYPES_BY_VALUE_TYPE.get(0);
        }
        return dt;
    }

    public static int convertTypeToSQLType(int type) {
        return DataType.getDataType((int)type).sqlType;
    }

    public static int convertSQLTypeToValueType(int sqlType, String sqlTypeName) {
        switch (sqlType) {
            case 1111: 
            case 2000: {
                if (!sqlTypeName.equalsIgnoreCase("geometry")) break;
                return 22;
            }
        }
        return DataType.convertSQLTypeToValueType(sqlType);
    }

    public static int getValueTypeFromResultSet(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return DataType.convertSQLTypeToValueType(meta.getColumnType(columnIndex), meta.getColumnTypeName(columnIndex));
    }

    public static int convertSQLTypeToValueType(int sqlType) {
        switch (sqlType) {
            case -15: 
            case 1: {
                return 21;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return 13;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case -6: {
                return 2;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 7;
            }
            case -4: 
            case -3: 
            case -2: {
                return 12;
            }
            case 1111: 
            case 2000: {
                return 19;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 11;
            }
            case 2014: {
                return 24;
            }
            case 2004: {
                return 15;
            }
            case 2005: 
            case 2011: {
                return 16;
            }
            case 0: {
                return 0;
            }
            case 2003: {
                return 17;
            }
            case -10: {
                return 18;
            }
        }
        throw DbException.get(50004, "" + sqlType);
    }

    public static int getTypeFromClass(Class<?> x) {
        if (x == null || Void.TYPE == x) {
            return 0;
        }
        if (x.isPrimitive()) {
            x = Utils.getNonPrimitiveClass(x);
        }
        if (String.class == x) {
            return 13;
        }
        if (Integer.class == x) {
            return 4;
        }
        if (Long.class == x) {
            return 5;
        }
        if (Boolean.class == x) {
            return 1;
        }
        if (Double.class == x) {
            return 7;
        }
        if (Byte.class == x) {
            return 2;
        }
        if (Short.class == x) {
            return 3;
        }
        if (Character.class == x) {
            throw DbException.get(22018, "char (not supported)");
        }
        if (Float.class == x) {
            return 8;
        }
        if (byte[].class == x) {
            return 12;
        }
        if (UUID.class == x) {
            return 20;
        }
        if (Void.class == x) {
            return 0;
        }
        if (BigDecimal.class.isAssignableFrom(x)) {
            return 6;
        }
        if (ResultSet.class.isAssignableFrom(x)) {
            return 18;
        }
        if (Value.ValueBlob.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Value.ValueClob.class.isAssignableFrom(x)) {
            return 16;
        }
        if (Date.class.isAssignableFrom(x)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(x)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(x)) {
            return 11;
        }
        if (java.util.Date.class.isAssignableFrom(x)) {
            return 11;
        }
        if (Reader.class.isAssignableFrom(x)) {
            return 16;
        }
        if (Clob.class.isAssignableFrom(x)) {
            return 16;
        }
        if (InputStream.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Blob.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Object[].class.isAssignableFrom(x)) {
            return 17;
        }
        if (DataType.isGeometryClass(x)) {
            return 22;
        }
        if (LocalDateTimeUtils.LOCAL_DATE == x) {
            return 10;
        }
        if (LocalDateTimeUtils.LOCAL_TIME == x) {
            return 9;
        }
        if (LocalDateTimeUtils.LOCAL_DATE_TIME == x) {
            return 11;
        }
        if (LocalDateTimeUtils.OFFSET_DATE_TIME == x || LocalDateTimeUtils.INSTANT == x) {
            return 24;
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getTypeIdFromClass(x);
        }
        return 19;
    }

    public static Value convertToValue(SessionInterface session, Object x, int type) {
        Value v = DataType.convertToValue1(session, x, type);
        if (session != null) {
            session.addTemporaryLob(v);
        }
        return v;
    }

    private static Value convertToValue1(SessionInterface session, Object x, int type) {
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        if (type == 19) {
            return ValueJavaObject.getNoCopy(x, null, session.getDataHandler());
        }
        if (x instanceof String) {
            return ValueString.get((String)x);
        }
        if (x instanceof Value) {
            return (Value)x;
        }
        if (x instanceof Long) {
            return ValueLong.get((Long)x);
        }
        if (x instanceof Integer) {
            return ValueInt.get((Integer)x);
        }
        if (x instanceof BigInteger) {
            return ValueDecimal.get(new BigDecimal((BigInteger)x));
        }
        if (x instanceof BigDecimal) {
            return ValueDecimal.get((BigDecimal)x);
        }
        if (x instanceof Boolean) {
            return ValueBoolean.get((Boolean)x);
        }
        if (x instanceof Byte) {
            return ValueByte.get((Byte)x);
        }
        if (x instanceof Short) {
            return ValueShort.get((Short)x);
        }
        if (x instanceof Float) {
            return ValueFloat.get(((Float)x).floatValue());
        }
        if (x instanceof Double) {
            return ValueDouble.get((Double)x);
        }
        if (x instanceof byte[]) {
            return ValueBytes.get((byte[])x);
        }
        if (x instanceof Date) {
            return ValueDate.get((Date)x);
        }
        if (x instanceof Time) {
            return ValueTime.get((Time)x);
        }
        if (x instanceof Timestamp) {
            return ValueTimestamp.get((Timestamp)x);
        }
        if (x instanceof java.util.Date) {
            return ValueTimestamp.fromMillis(((java.util.Date)x).getTime());
        }
        if (x instanceof Reader) {
            BufferedReader r = new BufferedReader((Reader)x);
            return session.getDataHandler().getLobStorage().createClob(r, -1L);
        }
        if (x instanceof Clob) {
            try {
                Clob clob = (Clob)x;
                BufferedReader r = new BufferedReader(clob.getCharacterStream());
                return session.getDataHandler().getLobStorage().createClob(r, clob.length());
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
        if (x instanceof InputStream) {
            return session.getDataHandler().getLobStorage().createBlob((InputStream)x, -1L);
        }
        if (x instanceof Blob) {
            try {
                Blob blob = (Blob)x;
                return session.getDataHandler().getLobStorage().createBlob(blob.getBinaryStream(), blob.length());
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
        if (x instanceof Array) {
            Array array = (Array)x;
            try {
                return DataType.convertToValue(session, array.getArray(), 17);
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
        if (x instanceof ResultSet) {
            if (x instanceof SimpleResultSet) {
                return ValueResultSet.get((ResultSet)x);
            }
            return ValueResultSet.getCopy((ResultSet)x, Integer.MAX_VALUE);
        }
        if (x instanceof UUID) {
            return ValueUuid.get((UUID)x);
        }
        Class<?> clazz = x.getClass();
        if (x instanceof Object[]) {
            Object[] o = (Object[])x;
            int len = o.length;
            Value[] v = new Value[len];
            for (int i = 0; i < len; ++i) {
                v[i] = DataType.convertToValue(session, o[i], type);
            }
            return ValueArray.get(clazz.getComponentType(), v);
        }
        if (x instanceof Character) {
            return ValueStringFixed.get(((Character)x).toString());
        }
        if (DataType.isGeometry(x)) {
            return ValueGeometry.getFromGeometry(x);
        }
        if (clazz == LocalDateTimeUtils.LOCAL_DATE) {
            return LocalDateTimeUtils.localDateToDateValue(x);
        }
        if (clazz == LocalDateTimeUtils.LOCAL_TIME) {
            return LocalDateTimeUtils.localTimeToTimeValue(x);
        }
        if (clazz == LocalDateTimeUtils.LOCAL_DATE_TIME) {
            return LocalDateTimeUtils.localDateTimeToValue(x);
        }
        if (clazz == LocalDateTimeUtils.INSTANT) {
            return LocalDateTimeUtils.instantToValue(x);
        }
        if (clazz == LocalDateTimeUtils.OFFSET_DATE_TIME) {
            return LocalDateTimeUtils.offsetDateTimeToValue(x);
        }
        if (x instanceof TimestampWithTimeZone) {
            return ValueTimestampTimeZone.get((TimestampWithTimeZone)x);
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getValue(type, x, session.getDataHandler());
        }
        return ValueJavaObject.getNoCopy(x, null, session.getDataHandler());
    }

    public static boolean isGeometryClass(Class<?> x) {
        if (x == null || GEOMETRY_CLASS == null) {
            return false;
        }
        return GEOMETRY_CLASS.isAssignableFrom(x);
    }

    public static boolean isGeometry(Object x) {
        if (x == null) {
            return false;
        }
        return DataType.isGeometryClass(x.getClass());
    }

    public static DataType getTypeByName(String s, Mode mode) {
        DataType result = mode.typeByNameMap.get(s);
        if (result == null && (result = TYPES_BY_NAME.get(s)) == null && JdbcUtils.customDataTypesHandler != null) {
            result = JdbcUtils.customDataTypesHandler.getDataTypeByName(s);
        }
        return result;
    }

    public static boolean isLargeObject(int type) {
        return type == 15 || type == 16;
    }

    public static boolean isStringType(int type) {
        return type == 13 || type == 21 || type == 14;
    }

    public static boolean supportsAdd(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case -1: 
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                return false;
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.supportsAdd(type);
        }
        return false;
    }

    public static int getAddProofType(int type) {
        switch (type) {
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case -1: 
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                return type;
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getAddProofType(type);
        }
        return type;
    }

    public static Object getDefaultForPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        throw DbException.throwInternalError("primitive=" + clazz.toString());
    }

    public static Object convertTo(JdbcConnection conn, Value v, Class<?> paramClass) {
        if (paramClass == Blob.class) {
            return new JdbcBlob(conn, v, 0);
        }
        if (paramClass == Clob.class) {
            return new JdbcClob(conn, v, 0);
        }
        if (paramClass == Array.class) {
            return new JdbcArray(conn, v, 0);
        }
        switch (v.getType()) {
            case 19: {
                Object o;
                Object object = o = SysProperties.serializeJavaObject ? JdbcUtils.deserialize(v.getBytes(), conn.getSession().getDataHandler()) : v.getObject();
                if (!paramClass.isAssignableFrom(o.getClass())) break;
                return o;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            default: {
                if (JdbcUtils.customDataTypesHandler == null) break;
                return JdbcUtils.customDataTypesHandler.getObject(v, paramClass);
            }
        }
        throw DbException.getUnsupportedException("converting to class " + paramClass.getName());
    }

    static {
        Class g;
        TYPES = new ArrayList(96);
        TYPES_BY_NAME = new HashMap(96);
        TYPES_BY_VALUE_TYPE = new HashMap(48);
        try {
            g = JdbcUtils.loadUserClass(GEOMETRY_CLASS_NAME);
        }
        catch (Exception e) {
            g = null;
        }
        GEOMETRY_CLASS = g;
        DataType.add(0, 0, new DataType(), new String[]{"NULL"}, 0);
        DataType.add(13, 12, DataType.createString(true), new String[]{"VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "CHARACTER VARYING", "TID"}, 48);
        DataType.add(13, -1, DataType.createString(true), new String[]{"LONGVARCHAR", "LONGNVARCHAR"}, 48);
        DataType.add(21, 1, DataType.createString(true), new String[]{"CHAR", "CHARACTER", "NCHAR"}, 48);
        DataType.add(14, 12, DataType.createString(false), new String[]{"VARCHAR_IGNORECASE"}, 48);
        DataType.add(1, 16, DataType.createDecimal(1, 1, 0, 5, false, false), new String[]{"BOOLEAN", "BIT", "BOOL"}, 0);
        DataType.add(2, -6, DataType.createDecimal(3, 3, 0, 4, false, false), new String[]{"TINYINT"}, 1);
        DataType.add(3, 5, DataType.createDecimal(5, 5, 0, 6, false, false), new String[]{"SMALLINT", "YEAR", "INT2"}, 20);
        DataType.add(4, 4, DataType.createDecimal(10, 10, 0, 11, false, false), new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"}, 20);
        DataType.add(4, 4, DataType.createDecimal(10, 10, 0, 11, false, true), new String[]{"SERIAL"}, 20);
        DataType.add(5, -5, DataType.createDecimal(19, 19, 0, 20, false, false), new String[]{"BIGINT", "INT8", "LONG"}, 24);
        DataType.add(5, -5, DataType.createDecimal(19, 19, 0, 20, false, true), new String[]{"IDENTITY", "BIGSERIAL"}, 24);
        if (SysProperties.BIG_DECIMAL_IS_DECIMAL) {
            DataType.addDecimal();
            DataType.addNumeric();
        } else {
            DataType.addNumeric();
            DataType.addDecimal();
        }
        DataType.add(8, 7, DataType.createDecimal(7, 7, 0, 15, false, false), new String[]{"REAL", "FLOAT4"}, 24);
        DataType.add(7, 8, DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"DOUBLE", "DOUBLE PRECISION"}, 24);
        DataType.add(7, 6, DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"FLOAT", "FLOAT8"}, 24);
        DataType.add(9, 92, DataType.createDate(18, 8, "TIME", true, 0, 9), new String[]{"TIME", "TIME WITHOUT TIME ZONE"}, 56);
        DataType.add(10, 91, DataType.createDate(10, 10, "DATE", false, 0, 0), new String[]{"DATE"}, 56);
        DataType.add(11, 93, DataType.createDate(29, 26, "TIMESTAMP", true, 6, 9), new String[]{"TIMESTAMP", "TIMESTAMP WITHOUT TIME ZONE", "DATETIME", "DATETIME2", "SMALLDATETIME"}, 56);
        DataType.add(24, 2014, DataType.createDate(35, 32, "TIMESTAMP_TZ", true, 6, 9), new String[]{"TIMESTAMP WITH TIME ZONE"}, 58);
        DataType.add(12, -3, DataType.createString(false), new String[]{"VARBINARY"}, 32);
        DataType.add(12, -2, DataType.createString(false), new String[]{"BINARY", "RAW", "BYTEA", "LONG RAW"}, 32);
        DataType.add(12, -4, DataType.createString(false), new String[]{"LONGVARBINARY"}, 32);
        DataType.add(20, -2, DataType.createString(false), new String[]{"UUID", "UNIQUEIDENTIFIER"}, 32);
        DataType.add(19, 1111, DataType.createString(false), new String[]{"OTHER", "OBJECT", "JAVA_OBJECT"}, 24);
        DataType.add(15, 2004, DataType.createLob(), new String[]{"BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE", "OID"}, 104);
        DataType.add(16, 2005, DataType.createLob(), new String[]{"CLOB", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT", "NCLOB"}, 104);
        DataType.add(22, 1111, DataType.createString(false), new String[]{"GEOMETRY"}, 32);
        DataType dataType = new DataType();
        dataType.prefix = "(";
        dataType.suffix = "')";
        DataType.add(17, 2003, dataType, new String[]{"ARRAY"}, 32);
        dataType = new DataType();
        DataType.add(18, -10, dataType, new String[]{"RESULT_SET"}, 400);
        dataType = DataType.createString(false);
        dataType.supportsPrecision = false;
        dataType.supportsScale = false;
        DataType.add(25, 1111, dataType, new String[]{"ENUM"}, 48);
        for (Integer i : TYPES_BY_VALUE_TYPE.keySet()) {
            Value.getOrder(i);
        }
    }
}

