/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueByte
extends Value {
    static final int PRECISION = 3;
    static final int DISPLAY_SIZE = 4;
    private final byte value;

    private ValueByte(byte value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueByte other = (ValueByte)v;
        return ValueByte.checkRange(this.value + other.value);
    }

    private static ValueByte checkRange(int x) {
        if (x < -128 || x > 127) {
            throw DbException.get(22003, Integer.toString(x));
        }
        return ValueByte.get((byte)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueByte.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueByte other = (ValueByte)v;
        return ValueByte.checkRange(this.value - other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueByte other = (ValueByte)v;
        return ValueByte.checkRange(this.value * other.value);
    }

    @Override
    public Value divide(Value v) {
        ValueByte other = (ValueByte)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value / other.value));
    }

    @Override
    public Value modulus(Value v) {
        ValueByte other = (ValueByte)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value % other.value));
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public byte getByte() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueByte v = (ValueByte)o;
        return Integer.compare(this.value, v.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 3L;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setByte(parameterIndex, this.value);
    }

    public static ValueByte get(byte i) {
        return (ValueByte)Value.cache(new ValueByte(i));
    }

    @Override
    public int getDisplaySize() {
        return 4;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueByte && this.value == ((ValueByte)other).value;
    }
}

