/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Locale;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueEnumBase;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

public class ValueEnum
extends ValueEnumBase {
    private final String[] enumerators;

    private ValueEnum(String[] enumerators, int ordinal) {
        super(enumerators[ordinal], ordinal);
        this.enumerators = enumerators;
    }

    public static void check(String[] enumerators) {
        switch (ValueEnum.validate(enumerators)) {
            case VALID: {
                return;
            }
            case EMPTY: {
                throw DbException.get(22032);
            }
            case DUPLICATE: {
                throw DbException.get(22033, ValueEnum.toString(enumerators));
            }
        }
        throw DbException.get(90008, ValueEnum.toString(enumerators));
    }

    private static void check(String[] enumerators, Value value) {
        ValueEnum.check(enumerators);
        if (ValueEnum.validate(enumerators, value) != Validation.VALID) {
            throw DbException.get(22030, ValueEnum.toString(enumerators), value.toString());
        }
    }

    @Override
    protected int compareSecure(Value v, CompareMode mode) {
        return Integer.compare(this.getInt(), v.getInt());
    }

    public static ValueEnum get(String[] enumerators, int value) {
        ValueEnum.check(enumerators, ValueInt.get(value));
        return new ValueEnum(enumerators, value);
    }

    public static ValueEnum get(String[] enumerators, String value) {
        ValueEnum.check(enumerators, ValueString.get(value));
        String cleanLabel = ValueEnum.sanitize(value);
        for (int i = 0; i < enumerators.length; ++i) {
            if (!cleanLabel.equals(ValueEnum.sanitize(enumerators[i]))) continue;
            return new ValueEnum(enumerators, i);
        }
        throw DbException.get(50000, "Unexpected error");
    }

    public String[] getEnumerators() {
        return this.enumerators;
    }

    public static boolean isValid(String[] enumerators, Value value) {
        return ValueEnum.validate(enumerators, value).equals((Object)Validation.VALID);
    }

    private static String sanitize(String label) {
        return label == null ? null : label.trim().toUpperCase(Locale.ENGLISH);
    }

    private static String[] sanitize(String[] enumerators) {
        if (enumerators == null || enumerators.length == 0) {
            return null;
        }
        String[] clean = new String[enumerators.length];
        for (int i = 0; i < enumerators.length; ++i) {
            clean[i] = ValueEnum.sanitize(enumerators[i]);
        }
        return clean;
    }

    private static String toString(String[] enumerators) {
        String result = "(";
        for (int i = 0; i < enumerators.length; ++i) {
            result = result + "'" + enumerators[i] + "'";
            if (i >= enumerators.length - 1) continue;
            result = result + ", ";
        }
        result = result + ")";
        return result;
    }

    private static Validation validate(String[] enumerators) {
        String[] cleaned = ValueEnum.sanitize(enumerators);
        if (cleaned == null || cleaned.length == 0) {
            return Validation.EMPTY;
        }
        for (int i = 0; i < cleaned.length; ++i) {
            if (cleaned[i] == null || cleaned[i].equals("")) {
                return Validation.EMPTY;
            }
            if (i >= cleaned.length - 1) continue;
            for (int j = i + 1; j < cleaned.length; ++j) {
                if (!cleaned[i].equals(cleaned[j])) continue;
                return Validation.DUPLICATE;
            }
        }
        return Validation.VALID;
    }

    private static Validation validate(String[] enumerators, Value value) {
        Validation validation = ValueEnum.validate(enumerators);
        if (!validation.equals((Object)Validation.VALID)) {
            return validation;
        }
        if (DataType.isStringType(value.getType())) {
            String cleanLabel = ValueEnum.sanitize(value.getString());
            for (String enumerator : enumerators) {
                if (!cleanLabel.equals(ValueEnum.sanitize(enumerator))) continue;
                return Validation.VALID;
            }
            return Validation.INVALID;
        }
        int ordinal = value.getInt();
        if (ordinal < 0 || ordinal >= enumerators.length) {
            return Validation.INVALID;
        }
        return Validation.VALID;
    }

    private static enum Validation {
        DUPLICATE,
        EMPTY,
        INVALID,
        VALID;

    }
}

