/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueEnumBase
extends Value {
    private static final int PRECISION = 10;
    private static final int DISPLAY_SIZE = 11;
    private final String label;
    private final int ordinal;

    protected ValueEnumBase(String label, int ordinal) {
        this.label = label;
        this.ordinal = ordinal;
    }

    @Override
    public Value add(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).add(iv);
    }

    @Override
    protected int compareSecure(Value v, CompareMode mode) {
        return Integer.compare(this.getInt(), v.getInt());
    }

    @Override
    public Value divide(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).divide(iv);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueEnumBase && this.getInt() == ((ValueEnumBase)other).getInt();
    }

    public static ValueEnumBase get(String label, int ordinal) {
        return new ValueEnumBase(label, ordinal);
    }

    @Override
    public int getDisplaySize() {
        return 11;
    }

    @Override
    public int getInt() {
        return this.ordinal;
    }

    @Override
    public long getLong() {
        return this.ordinal;
    }

    @Override
    public Object getObject() {
        return this.ordinal;
    }

    @Override
    public long getPrecision() {
        return 10L;
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.ordinal);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public String getString() {
        return this.label;
    }

    @Override
    public int getType() {
        return 25;
    }

    @Override
    public int hashCode() {
        int results = 31;
        results += this.getString().hashCode();
        return results += this.getInt();
    }

    @Override
    public Value modulus(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).modulus(iv);
    }

    @Override
    public Value multiply(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).multiply(iv);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setInt(parameterIndex, this.ordinal);
    }

    @Override
    public Value subtract(Value v) {
        Value iv = v.convertTo(4);
        return this.convertTo(4).subtract(iv);
    }
}

