/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Mode;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorageInterface;
import org.h2.store.RangeReader;
import org.h2.store.fs.FileUtils;
import org.h2.util.Bits;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class ValueLobDb
extends Value
implements Value.ValueClob,
Value.ValueBlob {
    private final int type;
    private final long lobId;
    private final byte[] hmac;
    private final byte[] small;
    private final DataHandler handler;
    private final long precision;
    private final String fileName;
    private final FileStore tempFile;
    private final int tableId;
    private int hash;
    private boolean isRecoveryReference;

    private ValueLobDb(int type, DataHandler handler, int tableId, long lobId, byte[] hmac, long precision) {
        this.type = type;
        this.handler = handler;
        this.tableId = tableId;
        this.lobId = lobId;
        this.hmac = hmac;
        this.precision = precision;
        this.small = null;
        this.fileName = null;
        this.tempFile = null;
    }

    private ValueLobDb(int type, byte[] small, long precision) {
        this.type = type;
        this.small = small;
        this.precision = precision;
        this.lobId = 0L;
        this.hmac = null;
        this.handler = null;
        this.fileName = null;
        this.tempFile = null;
        this.tableId = 0;
    }

    private ValueLobDb(DataHandler handler, Reader in, long remaining) throws IOException {
        this.type = 16;
        this.handler = handler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(handler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long tmpPrecision = 0L;
        try (FileStoreOutputStream out = new FileStoreOutputStream(this.tempFile, null, null);){
            char[] buff = new char[4096];
            while (true) {
                int len = ValueLobDb.getBufferSize(this.handler, false, remaining);
                if ((len = IOUtils.readFully(in, buff, len)) == 0) {
                    break;
                }
                byte[] data = new String(buff, 0, len).getBytes(StandardCharsets.UTF_8);
                out.write(data);
                tmpPrecision += (long)len;
            }
        }
        this.precision = tmpPrecision;
        this.tableId = 0;
    }

    private ValueLobDb(DataHandler handler, byte[] buff, int len, InputStream in, long remaining) throws IOException {
        this.type = 15;
        this.handler = handler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(handler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long tmpPrecision = 0L;
        boolean compress = this.handler.getLobCompressionAlgorithm(15) != null;
        try (FileStoreOutputStream out = new FileStoreOutputStream(this.tempFile, null, null);){
            do {
                tmpPrecision += (long)len;
                out.write(buff, 0, len);
                if ((remaining -= (long)len) <= 0L) {
                    break;
                }
                len = ValueLobDb.getBufferSize(this.handler, compress, remaining);
            } while ((len = IOUtils.readFully(in, buff, len)) > 0);
        }
        this.precision = tmpPrecision;
        this.tableId = 0;
    }

    private static String createTempLobFileName(DataHandler handler) throws IOException {
        String path = handler.getDatabasePath();
        if (path.length() == 0) {
            path = SysProperties.PREFIX_TEMP_FILE;
        }
        return FileUtils.createTempFile(path, ".temp.db", true, true);
    }

    public static ValueLobDb create(int type, DataHandler handler, int tableId, long id, byte[] hmac, long precision) {
        return new ValueLobDb(type, handler, tableId, id, hmac, precision);
    }

    @Override
    public Value convertTo(int t, int precision, Mode mode, Object column, String[] enumerators) {
        if (t == this.type) {
            return this;
        }
        if (t == 16) {
            if (this.handler != null) {
                return this.handler.getLobStorage().createClob(this.getReader(), -1L);
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(t, this.small);
            }
        } else if (t == 15) {
            if (this.handler != null) {
                return this.handler.getLobStorage().createBlob(this.getInputStream(), -1L);
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(t, this.small);
            }
        }
        return super.convertTo(t, precision, mode, column, null);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.small == null && this.tableId >= 0;
    }

    public boolean isStored() {
        return this.small == null && this.fileName == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            Object object = this.handler.getLobSyncObject();
            synchronized (object) {
                FileUtils.delete(this.fileName);
            }
        }
        if (this.handler != null) {
            this.handler.getLobStorage().removeLob(this);
        }
    }

    @Override
    public Value copy(DataHandler database, int tableId) {
        if (this.small == null) {
            return this.handler.getLobStorage().copyLob(this, tableId, this.getPrecision());
        }
        if (this.small.length > database.getMaxLengthInplaceLob()) {
            LobStorageInterface s = database.getLobStorage();
            Value v = this.type == 15 ? s.createBlob(this.getInputStream(), this.getPrecision()) : s.createClob(this.getReader(), this.getPrecision());
            Value v2 = v.copy(database, tableId);
            v.remove();
            return v2;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public String getString() {
        int len = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return new String(this.small, StandardCharsets.UTF_8);
                }
                return IOUtils.readStringAndClose(this.getReader(), len);
            }
            byte[] buff = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), len);
            return StringUtils.convertBytesToHex(buff);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] data = this.getBytesNoCopy();
        return Utils.cloneByteArray(data);
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.type == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    @Override
    protected int compareSecure(Value v, CompareMode mode) {
        Object v2;
        if (v instanceof ValueLobDb) {
            v2 = (ValueLobDb)v;
            if (v == this) {
                return 0;
            }
            if (this.lobId == ((ValueLobDb)v2).lobId && this.small == null && ((ValueLobDb)v2).small == null) {
                return 0;
            }
        }
        if (this.type == 16) {
            return Integer.signum(this.getString().compareTo(v.getString()));
        }
        v2 = v.getBytesNoCopy();
        return Bits.compareNotNullSigned(this.getBytesNoCopy(), (byte[])v2);
    }

    @Override
    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public Reader getReader(long oneBasedOffset, long length) {
        return ValueLob.rangeReader(this.getReader(), oneBasedOffset, length, this.type == 16 ? this.precision : -1L);
    }

    @Override
    public InputStream getInputStream() {
        if (this.small != null) {
            return new ByteArrayInputStream(this.small);
        }
        if (this.fileName != null) {
            FileStore store = this.handler.openFile(this.fileName, "r", true);
            boolean alwaysClose = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(store, this.handler, false, alwaysClose), 4096);
        }
        long byteCount = this.type == 15 ? this.precision : -1L;
        try {
            return this.handler.getLobStorage().getInputStream(this, this.hmac, byteCount);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public InputStream getInputStream(long oneBasedOffset, long length) {
        InputStream inputStream;
        long byteCount;
        if (this.small != null) {
            return super.getInputStream(oneBasedOffset, length);
        }
        if (this.fileName != null) {
            FileStore store = this.handler.openFile(this.fileName, "r", true);
            boolean alwaysClose = SysProperties.lobCloseBetweenReads;
            byteCount = store.length();
            inputStream = new BufferedInputStream(new FileStoreInputStream(store, this.handler, false, alwaysClose), 4096);
        } else {
            byteCount = this.type == 15 ? this.precision : -1L;
            try {
                inputStream = this.handler.getLobStorage().getInputStream(this, this.hmac, byteCount);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, this.toString());
            }
        }
        return ValueLob.rangeInputStream(inputStream, oneBasedOffset, length, byteCount);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        long p = this.getPrecision();
        if (p > Integer.MAX_VALUE || p <= 0L) {
            p = -1L;
        }
        if (this.type == 15) {
            prep.setBinaryStream(parameterIndex, this.getInputStream(), (int)p);
        } else {
            prep.setCharacterStream(parameterIndex, this.getReader(), (int)p);
        }
    }

    @Override
    public String getSQL() {
        if (this.type == 16) {
            String s = this.getString();
            return StringUtils.quoteStringSQL(s);
        }
        byte[] buff = this.getBytes();
        String s = StringUtils.convertBytesToHex(buff);
        return "X'" + s + "'";
    }

    @Override
    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder buff = new StringBuilder();
        if (this.type == 16) {
            buff.append("SPACE(").append(this.getPrecision());
        } else {
            buff.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        buff.append(" /* table: ").append(this.tableId).append(" id: ").append(this.lobId).append(" */)");
        return buff.toString();
    }

    @Override
    public byte[] getSmall() {
        return this.small;
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueLobDb && this.compareSecure((Value)other, null) == 0;
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 104;
        }
        return 140;
    }

    @Override
    public ValueLobDb copyToTemp() {
        return this;
    }

    @Override
    public ValueLobDb copyToResult() {
        if (this.handler == null) {
            return this;
        }
        LobStorageInterface s = this.handler.getLobStorage();
        if (s.isReadOnly()) {
            return this;
        }
        return s.copyLob(this, -3, this.getPrecision());
    }

    public long getLobId() {
        return this.lobId;
    }

    @Override
    public String toString() {
        return "lob: " + this.fileName + " table: " + this.tableId + " id: " + this.lobId;
    }

    public static ValueLobDb createTempClob(Reader in, long length, DataHandler handler) {
        if (length >= 0L) {
            try {
                in = new RangeReader(in, 0L, length);
            }
            catch (IOException e) {
                throw DbException.convert(e);
            }
        }
        BufferedReader reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in, 4096);
        try {
            char[] buff;
            int len;
            boolean compress = handler.getLobCompressionAlgorithm(16) != null;
            long remaining = Long.MAX_VALUE;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLobDb.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                String data = IOUtils.readStringAndClose(reader, -1);
                buff = data.toCharArray();
                len = buff.length;
            } else {
                buff = new char[len];
                reader.mark(len);
                len = IOUtils.readFully(reader, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = new String(buff, 0, len).getBytes(StandardCharsets.UTF_8);
                return ValueLobDb.createSmallLob(16, small, len);
            }
            reader.reset();
            return new ValueLobDb(handler, reader, remaining);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    public static ValueLobDb createTempBlob(InputStream in, long length, DataHandler handler) {
        try {
            byte[] buff;
            int len;
            boolean compress;
            long remaining = Long.MAX_VALUE;
            boolean bl = compress = handler.getLobCompressionAlgorithm(15) != null;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLobDb.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                buff = IOUtils.readBytesAndClose(in, -1);
                len = buff.length;
            } else {
                buff = Utils.newBytes(len);
                len = IOUtils.readFully(in, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = Utils.copyBytes(buff, len);
                return ValueLobDb.createSmallLob(15, small, small.length);
            }
            return new ValueLobDb(handler, buff, len, in, remaining);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private static int getBufferSize(DataHandler handler, boolean compress, long remaining) {
        long m;
        if (remaining < 0L || remaining > Integer.MAX_VALUE) {
            remaining = Integer.MAX_VALUE;
        }
        int inplace = handler.getMaxLengthInplaceLob();
        long l = m = compress ? 131072L : 4096L;
        if (m < remaining && m <= (long)inplace) {
            m = Math.min(remaining, (long)inplace + 1L);
            m = MathUtils.roundUpLong(m, 4096L);
        }
        m = Math.min(remaining, m);
        if ((m = (long)MathUtils.convertLongToInt(m)) < 0L) {
            m = Integer.MAX_VALUE;
        }
        return (int)m;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        ValueLobDb lob;
        if (this.precision <= precision) {
            return this;
        }
        if (this.type == 16) {
            if (this.handler == null) {
                try {
                    int p = MathUtils.convertLongToInt(precision);
                    String s = IOUtils.readStringAndClose(this.getReader(), p);
                    byte[] data = s.getBytes(StandardCharsets.UTF_8);
                    lob = ValueLobDb.createSmallLob(this.type, data, s.length());
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, null);
                }
            } else {
                lob = ValueLobDb.createTempClob(this.getReader(), precision, this.handler);
            }
        } else if (this.handler == null) {
            try {
                int p = MathUtils.convertLongToInt(precision);
                byte[] data = IOUtils.readBytesAndClose(this.getInputStream(), p);
                lob = ValueLobDb.createSmallLob(this.type, data, data.length);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        } else {
            lob = ValueLobDb.createTempBlob(this.getInputStream(), precision, this.handler);
        }
        return lob;
    }

    public static Value createSmallLob(int type, byte[] small) {
        int precision = type == 16 ? new String(small, StandardCharsets.UTF_8).length() : small.length;
        return ValueLobDb.createSmallLob(type, small, precision);
    }

    public static ValueLobDb createSmallLob(int type, byte[] small, long precision) {
        return new ValueLobDb(type, small, precision);
    }

    public void setRecoveryReference(boolean isRecoveryReference) {
        this.isRecoveryReference = isRecoveryReference;
    }

    public boolean isRecoveryReference() {
        return this.isRecoveryReference;
    }
}

