/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLong
extends Value {
    public static final ValueLong MIN = ValueLong.get(Long.MIN_VALUE);
    public static final ValueLong MAX = ValueLong.get(Long.MAX_VALUE);
    public static final BigInteger MAX_BI = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MIN_BD = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final int PRECISION = 19;
    public static final int DISPLAY_SIZE = 20;
    private static final BigInteger MIN_BI = BigInteger.valueOf(Long.MIN_VALUE);
    private static final int STATIC_SIZE = 100;
    private static final ValueLong[] STATIC_CACHE = new ValueLong[100];
    private final long value;

    private ValueLong(long value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueLong other = (ValueLong)v;
        long result = this.value + other.value;
        int sv = Long.signum(this.value);
        int so = Long.signum(other.value);
        int sr = Long.signum(result);
        if (sv != so || sr == so || sv == 0 || so == 0) {
            return ValueLong.get(result);
        }
        throw this.getOverflow();
    }

    @Override
    public int getSignum() {
        return Long.signum(this.value);
    }

    @Override
    public Value negate() {
        if (this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueLong.get(-this.value);
    }

    private DbException getOverflow() {
        return DbException.get(22003, Long.toString(this.value));
    }

    @Override
    public Value subtract(Value v) {
        int so;
        ValueLong other = (ValueLong)v;
        int sv = Long.signum(this.value);
        if (sv == (so = Long.signum(other.value)) || so == 0) {
            return ValueLong.get(this.value - other.value);
        }
        return this.add(other.negate());
    }

    private static boolean isInteger(long a) {
        return a >= Integer.MIN_VALUE && a <= Integer.MAX_VALUE;
    }

    @Override
    public Value multiply(Value v) {
        BigInteger bo;
        ValueLong other = (ValueLong)v;
        long result = this.value * other.value;
        if (this.value == 0L || this.value == 1L || other.value == 0L || other.value == 1L) {
            return ValueLong.get(result);
        }
        if (ValueLong.isInteger(this.value) && ValueLong.isInteger(other.value)) {
            return ValueLong.get(result);
        }
        BigInteger bv = BigInteger.valueOf(this.value);
        BigInteger br = bv.multiply(bo = BigInteger.valueOf(other.value));
        if (br.compareTo(MIN_BI) < 0 || br.compareTo(MAX_BI) > 0) {
            throw this.getOverflow();
        }
        return ValueLong.get(br.longValue());
    }

    @Override
    public Value divide(Value v) {
        ValueLong other = (ValueLong)v;
        if (other.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value / other.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueLong other = (ValueLong)v;
        if (other.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value % other.value);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueLong v = (ValueLong)o;
        return Long.compare(this.value, v.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 19L;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setLong(parameterIndex, this.value);
    }

    public static ValueLong get(long i) {
        if (i >= 0L && i < 100L) {
            return STATIC_CACHE[(int)i];
        }
        return (ValueLong)Value.cache(new ValueLong(i));
    }

    @Override
    public int getDisplaySize() {
        return 20;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueLong && this.value == ((ValueLong)other).value;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueLong.STATIC_CACHE[i] = new ValueLong(i);
        }
    }
}

