/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.h2.engine.Mode;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueTimestamp
extends Value {
    public static final int DEFAULT_PRECISION = 26;
    public static final int MAXIMUM_PRECISION = 29;
    static final int DEFAULT_SCALE = 6;
    public static final int MAXIMUM_SCALE = 9;
    private final long dateValue;
    private final long timeNanos;

    public static int getDisplaySize(int scale) {
        return scale == 0 ? 19 : 20 + scale;
    }

    private ValueTimestamp(long dateValue, long timeNanos) {
        this.dateValue = dateValue;
        if (timeNanos < 0L || timeNanos >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + timeNanos);
        }
        this.timeNanos = timeNanos;
    }

    public static ValueTimestamp fromDateValueAndNanos(long dateValue, long timeNanos) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(dateValue, timeNanos));
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        long ms = timestamp.getTime();
        long nanos = timestamp.getNanos() % 1000000;
        long dateValue = DateTimeUtils.dateValueFromDate(ms);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos += DateTimeUtils.nanosFromDate(ms));
    }

    public static ValueTimestamp fromMillisNanos(long ms, int nanos) {
        long dateValue = DateTimeUtils.dateValueFromDate(ms);
        long timeNanos = (long)nanos + DateTimeUtils.nanosFromDate(ms);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
    }

    public static ValueTimestamp fromMillis(long ms) {
        long dateValue = DateTimeUtils.dateValueFromDate(ms);
        long nanos = DateTimeUtils.nanosFromDate(ms);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
    }

    public static ValueTimestamp parse(String s) {
        return ValueTimestamp.parse(s, null);
    }

    public static ValueTimestamp parse(String s, Mode mode) {
        try {
            return (ValueTimestamp)DateTimeUtils.parseTimestamp(s, mode, false);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIMESTAMP", s);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    @Override
    public Timestamp getTimestamp() {
        return DateTimeUtils.convertDateValueToTimestamp(this.dateValue, this.timeNanos);
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public String getString() {
        StringBuilder buff = new StringBuilder(29);
        DateTimeUtils.appendDate(buff, this.dateValue);
        buff.append(' ');
        DateTimeUtils.appendTime(buff, this.timeNanos);
        return buff.toString();
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 29L;
    }

    @Override
    public int getScale() {
        return 9;
    }

    @Override
    public int getDisplaySize() {
        return 29;
    }

    @Override
    public boolean checkPrecision(long precision) {
        return true;
    }

    @Override
    public Value convertScale(boolean onlyToSmallerScale, int targetScale) {
        if (targetScale >= 9) {
            return this;
        }
        if (targetScale < 0) {
            throw DbException.getInvalidValueException("scale", targetScale);
        }
        long n = this.timeNanos;
        long n2 = DateTimeUtils.convertScale(n, targetScale);
        if (n2 == n) {
            return this;
        }
        long dv = this.dateValue;
        if (n2 >= 86400000000000L) {
            n2 -= 86400000000000L;
            dv = DateTimeUtils.incrementDateValue(dv);
        }
        return ValueTimestamp.fromDateValueAndNanos(dv, n2);
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueTimestamp t = (ValueTimestamp)o;
        int c = Long.compare(this.dateValue, t.dateValue);
        if (c != 0) {
            return c;
        }
        return Long.compare(this.timeNanos, t.timeNanos);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueTimestamp)) {
            return false;
        }
        ValueTimestamp x = (ValueTimestamp)other;
        return this.dateValue == x.dateValue && this.timeNanos == x.timeNanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setTimestamp(parameterIndex, this.getTimestamp());
    }

    @Override
    public Value add(Value v) {
        ValueTimestamp t = (ValueTimestamp)v.convertTo(11);
        long d1 = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long d2 = DateTimeUtils.absoluteDayFromDateValue(t.dateValue);
        return DateTimeUtils.normalizeTimestamp(d1 + d2, this.timeNanos + t.timeNanos);
    }

    @Override
    public Value subtract(Value v) {
        ValueTimestamp t = (ValueTimestamp)v.convertTo(11);
        long d1 = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long d2 = DateTimeUtils.absoluteDayFromDateValue(t.dateValue);
        return DateTimeUtils.normalizeTimestamp(d1 - d2, this.timeNanos - t.timeNanos);
    }
}

