/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SegmentedCacheServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class ScatteredCacheServiceConfigurator
extends SegmentedCacheServiceConfigurator {
    private volatile int invalidationBatchSize;
    private volatile long biasLifespan;

    ScatteredCacheServiceConfigurator(PathAddress address) {
        super(address, CacheMode.SCATTERED_SYNC);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.invalidationBatchSize = ScatteredCacheResourceDefinition.Attribute.INVALIDATION_BATCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.biasLifespan = ScatteredCacheResourceDefinition.Attribute.BIAS_LIFESPAN.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        builder.clustering().biasAcquisition(this.biasLifespan > 0L ? BiasAcquisition.ON_WRITE : BiasAcquisition.NEVER).biasLifespan(this.biasLifespan, TimeUnit.MILLISECONDS).invalidationBatchSize(this.invalidationBatchSize);
    }
}

