/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.eap.EAPServer7_4;
import org.jboss.migration.eap.EAPServerProvider7_3;
import org.jboss.migration.eap.EAPXPServer7_4;

public class EAPServerProvider7_4
extends EAPServerProvider7_3 {
    protected String getProductVersionRegex() {
        return "7.4\\..*";
    }

    protected Server constructServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        return this.isXp(baseDir) ? new EAPXPServer7_4(migrationName, new ProductInfo("JBoss EAP XP", productInfo.getVersion()), baseDir, migrationEnvironment) : new EAPServer7_4(migrationName, productInfo, baseDir, migrationEnvironment);
    }

    protected boolean isXp(Path baseDir) {
        if (Files.exists(baseDir.resolve(".installation").resolve("jboss-eap-xp-3.0.conf"), new LinkOption[0])) {
            return true;
        }
        return Files.isDirectory(baseDir.resolve("modules").resolve("system").resolve("layers").resolve("microprofile").resolve("org").resolve("wildfly").resolve("extension").resolve("microprofile"), new LinkOption[0]);
    }

    public String getName() {
        return "JBoss EAP 7.4";
    }
}

