/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.check;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.management.ActiveMQManagementProxy;
import org.apache.activemq.artemis.api.core.management.NodeInfo;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class CheckContext
extends ActionContext {
    private ActionContext actionContext;
    private ActiveMQConnectionFactory factory;
    private ActiveMQManagementProxy managementProxy;
    private String nodeId;
    private Map<String, NodeInfo> topology;

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public void setActionContext(ActionContext actionContext) {
        this.actionContext = actionContext;
    }

    public ActiveMQConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }

    public ActiveMQManagementProxy getManagementProxy() {
        return this.managementProxy;
    }

    public void setManagementProxy(ActiveMQManagementProxy managementProxy) {
        this.managementProxy = managementProxy;
    }

    public String getNodeId() throws Exception {
        if (this.nodeId == null) {
            this.nodeId = (String)this.managementProxy.invokeOperation(String.class, "broker", "getNodeID", new Object[0]);
        }
        return this.nodeId;
    }

    public Map<String, NodeInfo> getTopology() throws Exception {
        if (this.topology == null) {
            this.topology = Arrays.stream(NodeInfo.from((String)((String)this.managementProxy.invokeOperation(String.class, "broker", "listNetworkTopology", new Object[0])))).collect(Collectors.toMap(node -> node.getId(), node -> node));
        }
        return this.topology;
    }

    public CheckContext(ActionContext actionContext, ActiveMQConnectionFactory factory, ActiveMQManagementProxy managementProxy) {
        this.actionContext = actionContext;
        this.factory = factory;
        this.managementProxy = managementProxy;
    }
}

