/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.impl.BaseStateTransferInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferInterceptor
extends BaseStateTransferInterceptor {
    private static final Log log = LogFactory.getLog(StateTransferInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationFinallyFunction<TransactionBoundaryCommand> handleTxReturn = this::handleTxReturn;
    private final InvocationFinallyFunction<WriteCommand> handleTxWriteReturn = this::handleTxWriteReturn;
    private final InvocationFinallyFunction<WriteCommand> handleNonTxWriteReturn = this::handleNonTxWriteReturn;

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (trace) {
            log.tracef("handleTxCommand for command %s, origin %s", command, this.getOrigin(ctx));
        }
        this.updateTopologyId(command);
        return this.invokeNextAndHandle(ctx, command, this.handleTxReturn);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    private Object handleTxCommand(TxInvocationContext ctx, TransactionBoundaryCommand command) {
        if (trace) {
            log.tracef("handleTxCommand for command %s, origin %s", command, this.getOrigin(ctx));
        }
        this.updateTopologyId(command);
        return this.invokeNextAndHandle(ctx, command, this.handleTxReturn);
    }

    private Address getOrigin(TxInvocationContext ctx) {
        return ctx.isOriginLocal() ? ctx.getOrigin() : ctx.getGlobalTransaction().getAddress();
    }

    private Object handleTxReturn(InvocationContext ctx, TransactionBoundaryCommand txCommand, Object rv, Throwable t) throws Throwable {
        int retryTopologyId = -1;
        int currentTopology = this.currentTopologyId();
        if (t instanceof OutdatedTopologyException || t instanceof AllOwnersLostException) {
            retryTopologyId = Math.max(currentTopology, txCommand.getTopologyId() + 1);
        } else if (t != null) {
            throw t;
        }
        if (ctx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                txCommand.setTopologyId(retryTopologyId);
                if (txCommand instanceof PrepareCommand) {
                    ((PrepareCommand)txCommand).setRetriedCommand(true);
                }
                CompletableFuture<Void> transactionDataFuture = this.stateTransferLock.transactionDataFuture(retryTopologyId);
                return this.retryWhenDone(transactionDataFuture, retryTopologyId, ctx, txCommand, this.handleTxReturn);
            }
        } else if (currentTopology > txCommand.getTopologyId()) {
            return UnsureResponse.INSTANCE;
        }
        return rv;
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (ctx.isInTxScope()) {
            return this.handleTxWriteCommand(ctx, command);
        }
        return this.handleNonTxWriteCommand(ctx, command);
    }

    private Object handleTxWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (trace) {
            log.tracef("handleTxWriteCommand for command %s, origin %s", command, ctx.getOrigin());
        }
        this.updateTopologyId(command);
        return this.invokeNextAndHandle(ctx, command, this.handleTxWriteReturn);
    }

    private Object handleTxWriteReturn(InvocationContext rCtx, WriteCommand writeCommand, Object rv, Throwable t) throws Throwable {
        int retryTopologyId = -1;
        if (t instanceof OutdatedTopologyException || t instanceof AllOwnersLostException) {
            retryTopologyId = Math.max(this.currentTopologyId(), writeCommand.getTopologyId() + 1);
        } else if (t != null) {
            throw t;
        }
        if (rCtx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                writeCommand.setTopologyId(retryTopologyId);
                CompletableFuture<Void> transactionDataFuture = this.stateTransferLock.transactionDataFuture(retryTopologyId);
                return this.retryWhenDone(transactionDataFuture, retryTopologyId, rCtx, writeCommand, this.handleTxWriteReturn);
            }
        } else if (this.currentTopologyId() > writeCommand.getTopologyId()) {
            return UnsureResponse.INSTANCE;
        }
        return rv;
    }

    private Object handleNonTxWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (trace) {
            log.tracef("handleNonTxWriteCommand for command %s, topology id %d", command, command.getTopologyId());
        }
        this.updateTopologyId(command);
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextAndHandle(ctx, command, this.handleNonTxWriteReturn);
    }

    private Object handleExceptionOnNonTxWriteReturn(InvocationContext rCtx, WriteCommand writeCommand, Throwable t) throws Throwable {
        Throwable ce = t;
        while (ce instanceof RemoteException) {
            ce = ce.getCause();
        }
        if (!(ce instanceof OutdatedTopologyException || ce instanceof SuspectException || ce instanceof AllOwnersLostException)) {
            throw t;
        }
        int currentTopologyId = this.currentTopologyId();
        int newTopologyId = this.getNewTopologyId(ce, currentTopologyId, writeCommand);
        if (trace) {
            log.tracef("Retrying command because of %s, current topology is %d (requested: %d): %s", new Object[]{ce, currentTopologyId, newTopologyId, writeCommand});
        }
        writeCommand.setTopologyId(newTopologyId);
        writeCommand.addFlags(FlagBitSets.COMMAND_RETRY);
        CompletableFuture<Void> transactionDataFuture = this.stateTransferLock.transactionDataFuture(newTopologyId);
        return this.retryWhenDone(transactionDataFuture, newTopologyId, rCtx, writeCommand, this.handleNonTxWriteReturn);
    }

    private Object handleNonTxWriteReturn(InvocationContext rCtx, WriteCommand rCommand, Object rv, Throwable t) throws Throwable {
        if (t == null) {
            return rv;
        }
        return this.handleExceptionOnNonTxWriteReturn(rCtx, rCommand, t);
    }

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof TopologyAffectedCommand) {
            return this.handleTopologyAffectedCommand(ctx, command, ctx.getOrigin());
        }
        return this.invokeNext(ctx, command);
    }

    private Object handleTopologyAffectedCommand(InvocationContext ctx, VisitableCommand command, Address origin) {
        if (trace) {
            log.tracef("handleTopologyAffectedCommand for command %s, origin %s", command, origin);
        }
        this.updateTopologyId((TopologyAffectedCommand)((Object)command));
        return this.invokeNext(ctx, command);
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

