/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.IllegalDataException;
import nu.xom.Node;
import nu.xom.Text;
import nu.xom.Verifier;

public class Comment
extends Node {
    private String data;

    public Comment(String data) {
        this._setValue(data);
    }

    public Comment(Comment comment) {
        this.data = comment.data;
    }

    private Comment() {
    }

    static Comment build(String data) {
        Comment result = new Comment();
        result.data = data;
        return result;
    }

    @Override
    public final String getValue() {
        return this.data;
    }

    public void setValue(String data) {
        this._setValue(data);
    }

    private void _setValue(String data) {
        if (data == null) {
            data = "";
        } else {
            Verifier.checkPCDATA(data);
            if (data.indexOf("--") != -1) {
                IllegalDataException ex = new IllegalDataException("Comment data contains a double hyphen (--).");
                ex.setData(data);
                throw ex;
            }
            if (data.indexOf(13) != -1) {
                IllegalDataException ex = new IllegalDataException("Comment data cannot contain carriage returns.");
                ex.setData(data);
                throw ex;
            }
            if (data.endsWith("-")) {
                IllegalDataException ex = new IllegalDataException("Comment data ends with a hyphen.");
                ex.setData(data);
                throw ex;
            }
        }
        this.data = data;
    }

    @Override
    public final Node getChild(int position) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public Node copy() {
        return new Comment(this.data);
    }

    @Override
    public final String toXML() {
        StringBuffer result = new StringBuffer("<!--");
        result.append(this.data);
        result.append("-->");
        return result.toString();
    }

    public final String toString() {
        String value = this.getValue();
        if (value.length() <= 40) {
            return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(value) + "]";
        }
        return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(value.substring(0, 35)) + "...]";
    }

    @Override
    boolean isComment() {
        return true;
    }
}

