/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.wildfly.openssl.OpenSSLContextSPI;
import org.wildfly.openssl.OpenSSLEngine;
import org.wildfly.openssl.OpenSSLSocket;

public class OpenSSLServerSocket
extends SSLServerSocket {
    private final OpenSSLContextSPI openSSLContextSPI;
    private final SSLParameters sslParameters = new SSLParameters();

    public OpenSSLServerSocket(OpenSSLContextSPI openSSLContextSPI) throws IOException {
        this.openSSLContextSPI = openSSLContextSPI;
    }

    public OpenSSLServerSocket(int port, OpenSSLContextSPI openSSLContextSPI) throws IOException {
        super(port);
        this.openSSLContextSPI = openSSLContextSPI;
    }

    public OpenSSLServerSocket(int port, int backlog, OpenSSLContextSPI openSSLContextSPI) throws IOException {
        super(port, backlog);
        this.openSSLContextSPI = openSSLContextSPI;
    }

    public OpenSSLServerSocket(int port, int backlog, InetAddress bindAddr, OpenSSLContextSPI openSSLContextSPI) throws IOException {
        super(port, backlog, bindAddr);
        this.openSSLContextSPI = openSSLContextSPI;
    }

    @Override
    public Socket accept() throws IOException {
        Socket delegate = super.accept();
        OpenSSLEngine engine = (OpenSSLEngine)this.openSSLContextSPI.createSSLEngine();
        engine.setSSLParameters(this.sslParameters);
        return new OpenSSLSocket(delegate, true, engine);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return OpenSSLContextSPI.getAvailableCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        if (OpenSSLEngine.isTLS13Supported()) {
            return (String[])OpenSSLEngine.SUPPORTED_PROTOCOLS.clone();
        }
        return (String[])OpenSSLEngine.LEGACY_SUPPORTED_PROTOCOLS.clone();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public void setUseClientMode(boolean mode) {
    }

    @Override
    public boolean getUseClientMode() {
        return false;
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
    }

    @Override
    public boolean getEnableSessionCreation() {
        return false;
    }
}

