/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import io.netty.util.collection.LongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.NonExistentPage;
import org.apache.activemq.artemis.core.paging.cursor.PageCache;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCacheImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageReader;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.SoftValueLongObjectHashMap;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.jboss.logging.Logger;

public class PageCursorProviderImpl
implements PageCursorProvider {
    private static final Logger logger = Logger.getLogger(PageCursorProviderImpl.class);
    protected final AtomicInteger scheduledCleanup = new AtomicInteger(0);
    protected volatile boolean cleanupEnabled = true;
    protected final PagingStore pagingStore;
    protected final StorageManager storageManager;
    private final ArtemisExecutor executor;
    private final SoftValueLongObjectHashMap<PageCache> softCache;
    private LongObjectHashMap<Integer> numberOfMessages = null;
    private final LongObjectHashMap<CompletableFuture<PageCache>> inProgressReadPages;
    private final ConcurrentLongHashMap<PageSubscription> activeCursors = new ConcurrentLongHashMap();
    private static final long PAGE_READ_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(30L);
    private static final long CONCURRENT_PAGE_READ_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(10L);
    private static final long PAGE_READ_PERMISSION_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(10L);

    public PageCursorProviderImpl(PagingStore pagingStore, StorageManager storageManager, ArtemisExecutor executor, int maxCacheSize) {
        this(pagingStore, storageManager, executor, maxCacheSize, false);
    }

    public PageCursorProviderImpl(PagingStore pagingStore, StorageManager storageManager, ArtemisExecutor executor, int maxCacheSize, boolean readWholePage) {
        this.pagingStore = pagingStore;
        this.storageManager = storageManager;
        this.executor = executor;
        this.softCache = new SoftValueLongObjectHashMap(maxCacheSize);
        if (!readWholePage) {
            this.numberOfMessages = new LongObjectHashMap();
        }
        this.inProgressReadPages = new LongObjectHashMap();
    }

    @Override
    public synchronized PageSubscription createSubscription(long cursorID, Filter filter, boolean persistent) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.pagingStore.getAddress() + " creating subscription " + cursorID + " with filter " + filter), (Throwable)new Exception("trace"));
        }
        if (this.activeCursors.containsKey(cursorID)) {
            throw new IllegalStateException("Cursor " + cursorID + " had already been created");
        }
        PageSubscriptionImpl activeCursor = new PageSubscriptionImpl(this, this.pagingStore, this.storageManager, this.executor, filter, cursorID, persistent);
        this.activeCursors.put(cursorID, (Object)activeCursor);
        return activeCursor;
    }

    @Override
    public synchronized PageSubscription getSubscription(long cursorID) {
        return (PageSubscription)this.activeCursors.get(cursorID);
    }

    @Override
    public PagedMessage getMessage(PagePosition pos) {
        PageCache cache = this.getPageCache(pos.getPageNr());
        if (cache == null || pos.getMessageNr() >= cache.getNumberOfMessages()) {
            throw new NonExistentPage("Invalid messageNumber passed = " + pos + " on " + cache);
        }
        return cache.getMessage(pos);
    }

    @Override
    public PagedReference newReference(PagePosition pos, PagedMessage msg, PageSubscription subscription) {
        return new PagedReferenceImpl(pos, msg, subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageCache getPageCache(long pageId) {
        try {
            CompletableFuture inProgressReadPage;
            PageCache cache;
            if (pageId > (long)this.pagingStore.getCurrentWritingPage()) {
                return null;
            }
            boolean createPage = false;
            Page page = null;
            SoftValueLongObjectHashMap<PageCache> softValueLongObjectHashMap = this.softCache;
            synchronized (softValueLongObjectHashMap) {
                cache = (PageCache)this.softCache.get(pageId);
                if (cache != null) {
                    return cache;
                }
                if (!this.pagingStore.checkPageFileExists((int)pageId)) {
                    return null;
                }
                Page currentPage = this.pagingStore.getCurrentPage();
                if (currentPage != null && (long)currentPage.getPageId() == pageId && (cache = currentPage.getLiveCache()) != null) {
                    this.softCache.put(cache.getPageId(), (SoftValueLongObjectHashMap.ValueCache)cache);
                    return cache;
                }
                inProgressReadPage = (CompletableFuture)this.inProgressReadPages.get(pageId);
                if (inProgressReadPage == null) {
                    if (this.numberOfMessages != null && this.numberOfMessages.containsKey(pageId)) {
                        return new PageReader(this.pagingStore.createPage((int)pageId), (Integer)this.numberOfMessages.get(pageId));
                    }
                    CompletableFuture readPage = new CompletableFuture();
                    cache = this.createPageCache(pageId);
                    page = this.pagingStore.createPage((int)pageId);
                    createPage = true;
                    inProgressReadPage = readPage;
                    this.inProgressReadPages.put(pageId, readPage);
                }
            }
            if (createPage) {
                return this.readPage(pageId, page, cache, inProgressReadPage);
            }
            long startedWait = System.nanoTime();
            while (true) {
                try {
                    return (PageCache)inProgressReadPage.get(CONCURRENT_PAGE_READ_TIMEOUT_NS, TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException e) {
                    long elapsed = System.nanoTime() - startedWait;
                    long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(elapsed);
                    logger.warnf("Waiting a concurrent Page::read for pageNr=%d on cursor %s by %d ms", (Object)pageId, (Object)this.pagingStore.getAddress(), (Object)elapsedMillis);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageCache readPage(long pageId, Page page, PageCache cache, CompletableFuture<PageCache> inProgressReadPage) throws Exception {
        logger.tracef("adding pageCache pageNr=%d into cursor = %s", pageId, (Object)this.pagingStore.getAddress());
        boolean acquiredPageReadPermission = false;
        int num = -1;
        try {
            long startedRequest = System.nanoTime();
            while (!acquiredPageReadPermission) {
                acquiredPageReadPermission = this.storageManager.beforePageRead(PAGE_READ_PERMISSION_TIMEOUT_NS, TimeUnit.NANOSECONDS);
                if (acquiredPageReadPermission) continue;
                long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedRequest);
                logger.warnf("Cannot acquire page read permission of pageNr=%d on cursor %s after %d ms: consider increasing page-max-concurrent-io or use a faster disk", (Object)pageId, (Object)this.pagingStore.getAddress(), (Object)elapsedMillis);
            }
            page.open();
            long startedReadPage = System.nanoTime();
            List<PagedMessage> pgdMessages = page.read(this.storageManager);
            long elapsedReadPage = System.nanoTime() - startedReadPage;
            if (elapsedReadPage > PAGE_READ_TIMEOUT_NS) {
                logger.warnf("Page::read for pageNr=%d on cursor %s tooks %d ms to read %d bytes", new Object[]{pageId, this.pagingStore.getAddress(), TimeUnit.NANOSECONDS.toMillis(elapsedReadPage), page.getSize()});
            }
            num = pgdMessages.size();
            cache.setMessages(pgdMessages.toArray(new PagedMessage[num]));
        }
        catch (Throwable t) {
            inProgressReadPage.completeExceptionally(t);
            SoftValueLongObjectHashMap<PageCache> softValueLongObjectHashMap = this.softCache;
            synchronized (softValueLongObjectHashMap) {
                this.inProgressReadPages.remove(pageId);
            }
            throw t;
        }
        finally {
            try {
                if (page != null) {
                    page.close(false, false);
                }
            }
            catch (Throwable startedRequest) {}
            if (acquiredPageReadPermission) {
                this.storageManager.afterPageRead();
            }
        }
        inProgressReadPage.complete(cache);
        SoftValueLongObjectHashMap<PageCache> softValueLongObjectHashMap = this.softCache;
        synchronized (softValueLongObjectHashMap) {
            this.inProgressReadPages.remove(pageId);
            this.softCache.put(pageId, (SoftValueLongObjectHashMap.ValueCache)cache);
            if (this.numberOfMessages != null && num != -1) {
                this.numberOfMessages.put(pageId, (Object)num);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPageCache(PageCache cache) {
        logger.tracef("Add page cache %s", (Object)cache);
        SoftValueLongObjectHashMap<PageCache> softValueLongObjectHashMap = this.softCache;
        synchronized (softValueLongObjectHashMap) {
            this.softCache.put(cache.getPageId(), (SoftValueLongObjectHashMap.ValueCache)cache);
        }
    }

    @Override
    public void setCacheMaxSize(int size) {
        this.softCache.setMaxElements(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSize() {
        SoftValueLongObjectHashMap<PageCache> softValueLongObjectHashMap = this.softCache;
        synchronized (softValueLongObjectHashMap) {
            return this.softCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        SoftValueLongObjectHashMap<PageCache> softValueLongObjectHashMap = this.softCache;
        synchronized (softValueLongObjectHashMap) {
            this.softCache.clear();
        }
    }

    @Override
    public void processReload() throws Exception {
        long cursorsMinPage;
        List cursorList = this.activeCursors.values();
        for (PageSubscription cursor : cursorList) {
            cursor.processReload();
        }
        if (!cursorList.isEmpty() && (cursorsMinPage = this.checkMinPage(cursorList)) != Long.MAX_VALUE) {
            for (long startPage = this.pagingStore.getFirstPage(); startPage < cursorsMinPage; ++startPage) {
                for (PageSubscription cursor : cursorList) {
                    cursor.reloadPageInfo(startPage);
                }
            }
        }
        this.cleanup();
    }

    @Override
    public void stop() {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.stop();
        }
        int pendingCleanupTasks = this.scheduledCleanup.get();
        if (pendingCleanupTasks > 0) {
            logger.tracef("Stopping with %d cleanup tasks to be completed yet", pendingCleanupTasks);
        }
    }

    private void waitForFuture() {
        if (!this.executor.flush(10L, TimeUnit.SECONDS)) {
            ActiveMQServerLogger.LOGGER.timedOutStoppingPagingCursor((Executor)this.executor);
        }
    }

    @Override
    public void flushExecutors() {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.flushExecutors();
        }
        this.waitForFuture();
    }

    @Override
    public void close(PageSubscription cursor) {
        this.activeCursors.remove(cursor.getId());
        this.scheduleCleanup();
    }

    @Override
    public void scheduleCleanup() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"scheduling cleanup", (Throwable)new Exception("trace"));
        }
        if (!this.cleanupEnabled || this.scheduledCleanup.intValue() > 2) {
            return;
        }
        this.scheduledCleanup.incrementAndGet();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                PageCursorProviderImpl.this.storageManager.setContext(PageCursorProviderImpl.this.storageManager.newSingleThreadContext());
                try {
                    if (PageCursorProviderImpl.this.cleanupEnabled) {
                        PageCursorProviderImpl.this.cleanup();
                    }
                }
                finally {
                    PageCursorProviderImpl.this.storageManager.clearContext();
                    PageCursorProviderImpl.this.scheduledCleanup.decrementAndGet();
                }
            }
        });
    }

    @Override
    public void onPageModeCleared() {
        ArrayList<PageSubscription> subscriptions = this.cloneSubscriptions();
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        for (PageSubscription sub : subscriptions) {
            try {
                sub.onPageModeCleared(tx);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCleaningPagingOnQueue(e, sub.getQueue().getName().toString());
            }
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorCleaningPagingDuringCommit(e);
        }
    }

    @Override
    public void disableCleanup() {
        this.cleanupEnabled = false;
    }

    @Override
    public void resumeCleanup() {
        this.cleanupEnabled = true;
        this.scheduleCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanup() {
        ArrayList<Page> depagedPages;
        block19: {
            logger.tracef("performing page cleanup %s", (Object)this);
            depagedPages = new ArrayList<Page>();
            this.storageManager.readLock();
            do {
                if (!this.pagingStore.lock(100L)) continue;
                logger.tracef("%s locked", (Object)this);
                PageCursorProviderImpl pageCursorProviderImpl = this;
                synchronized (pageCursorProviderImpl) {
                    try {
                        Page page;
                        if (!this.pagingStore.isStarted()) {
                            return;
                        }
                        if (this.pagingStore.getNumberOfPages() == 0) {
                            return;
                        }
                        ArrayList<PageSubscription> cursorList = this.cloneSubscriptions();
                        long minPage = this.checkMinPage(cursorList);
                        this.deliverIfNecessary(cursorList, minPage);
                        logger.debugf("Asserting cleanup for address %s, firstPage=%d", (Object)this.pagingStore.getAddress(), (Object)minPage);
                        if (minPage == (long)this.pagingStore.getCurrentWritingPage() && this.pagingStore.getCurrentPage().getNumberOfMessages() > 0) {
                            boolean complete = this.checkPageCompletion(cursorList, minPage);
                            if (!this.pagingStore.isStarted()) {
                                return;
                            }
                            if (complete) {
                                this.cleanupComplete(cursorList);
                            }
                        }
                        for (long i = this.pagingStore.getFirstPage(); i <= minPage && this.checkPageCompletion(cursorList, i) && (page = this.pagingStore.depage()) != null; ++i) {
                            depagedPages.add(page);
                        }
                        if (this.pagingStore.getNumberOfPages() == 0 || this.pagingStore.getNumberOfPages() == 1 && this.pagingStore.getCurrentPage().getNumberOfMessages() == 0) {
                            this.pagingStore.stopPaging();
                            break block19;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Couldn't cleanup page on address " + this.pagingStore.getAddress() + " as numberOfPages == " + this.pagingStore.getNumberOfPages() + " and currentPage.numberOfMessages = " + this.pagingStore.getCurrentPage().getNumberOfMessages()));
                        }
                        break block19;
                    }
                    catch (Exception ex) {
                        ActiveMQServerLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        return;
                    }
                }
            } while (this.pagingStore.isStarted());
            return;
            {
                finally {
                    this.pagingStore.unlock();
                    this.storageManager.readUnLock();
                }
            }
        }
        this.finishCleanup(depagedPages);
    }

    protected void cleanupComplete(ArrayList<PageSubscription> cursorList) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Address " + this.pagingStore.getAddress() + " is leaving page mode as all messages are consumed and acknowledged from the page store"));
        }
        this.pagingStore.forceAnotherPage();
        Page currentPage = this.pagingStore.getCurrentPage();
        this.storeBookmark(cursorList, currentPage);
        this.pagingStore.stopPaging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishCleanup(ArrayList<Page> depagedPages) {
        logger.tracef("this(%s) finishing cleanup on %s", (Object)this, depagedPages);
        try {
            for (Page depagedPage : depagedPages) {
                PagedMessage[] pgdMessages;
                PageCache cache;
                SoftValueLongObjectHashMap<PageCache> softValueLongObjectHashMap = this.softCache;
                synchronized (softValueLongObjectHashMap) {
                    cache = (PageCache)this.softCache.get((long)depagedPage.getPageId());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Removing pageNr=" + depagedPage.getPageId() + " from page-cache"));
                }
                if (cache == null) {
                    this.storageManager.beforePageRead();
                    List<PagedMessage> pgdMessagesList = null;
                    try {
                        depagedPage.open();
                        pgdMessagesList = depagedPage.read(this.storageManager, true);
                    }
                    finally {
                        try {
                            depagedPage.close(false, false);
                        }
                        catch (Exception exception) {}
                        this.storageManager.afterPageRead();
                    }
                    pgdMessages = pgdMessagesList.isEmpty() ? null : pgdMessagesList.toArray(new PagedMessage[pgdMessagesList.size()]);
                } else {
                    pgdMessages = cache.getMessages();
                }
                depagedPage.delete(pgdMessages);
                softValueLongObjectHashMap = this.softCache;
                synchronized (softValueLongObjectHashMap) {
                    long pageId = depagedPage.getPageId();
                    this.softCache.remove(pageId);
                    if (this.numberOfMessages != null) {
                        this.numberOfMessages.remove(pageId);
                    }
                }
                this.onDeletePage(depagedPage);
            }
        }
        catch (Exception ex) {
            ActiveMQServerLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
            return;
        }
    }

    private boolean checkPageCompletion(ArrayList<PageSubscription> cursorList, long minPage) {
        logger.tracef("checkPageCompletion(%d)", minPage);
        boolean complete = true;
        for (PageSubscription cursor : cursorList) {
            if (!cursor.isComplete(minPage)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cursor " + cursor + " was considered incomplete at pageNr=" + minPage));
                }
                complete = false;
                break;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Cursor " + cursor + " was considered **complete** at pageNr=" + minPage));
        }
        return complete;
    }

    private synchronized ArrayList<PageSubscription> cloneSubscriptions() {
        ArrayList<PageSubscription> cursorList = new ArrayList<PageSubscription>(this.activeCursors.values());
        return cursorList;
    }

    protected void onDeletePage(Page deletedPage) throws Exception {
        ArrayList<PageSubscription> subscriptions = this.cloneSubscriptions();
        for (PageSubscription subs : subscriptions) {
            subs.onDeletePage(deletedPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBookmark(ArrayList<PageSubscription> cursorList, Page currentPage) throws Exception {
        try {
            for (PageSubscription cursor : cursorList) {
                cursor.confirmPosition(new PagePositionImpl(currentPage.getPageId(), -1));
            }
        }
        finally {
            for (PageSubscription cursor : cursorList) {
                cursor.enableAutoCleanup();
            }
        }
    }

    @Override
    public void printDebug() {
        System.out.println("Debug information for PageCursorProviderImpl:");
        for (PageCache cache : this.softCache.values()) {
            System.out.println("Cache " + cache);
        }
    }

    public String toString() {
        return "PageCursorProviderImpl{pagingStore=" + this.pagingStore + '}';
    }

    protected PageCacheImpl createPageCache(long pageId) {
        return new PageCacheImpl(pageId);
    }

    private long checkMinPage(Collection<PageSubscription> cursorList) {
        long minPage = Long.MAX_VALUE;
        for (PageSubscription cursor : cursorList) {
            long firstPage = cursor.getFirstPage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.pagingStore.getAddress() + " has a cursor " + cursor + " with first page=" + firstPage));
            }
            if (firstPage < 0L || firstPage >= minPage) continue;
            minPage = firstPage;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.pagingStore.getAddress() + " has minPage=" + minPage));
        }
        return minPage;
    }

    private void deliverIfNecessary(Collection<PageSubscription> cursorList, long minPage) {
        boolean currentWriting = minPage == (long)this.pagingStore.getCurrentWritingPage();
        for (PageSubscription cursor : cursorList) {
            long firstPage = cursor.getFirstPage();
            if (firstPage != minPage || cursor.getQueue().getMessageCount() != 0L || currentWriting && cursor.isComplete(firstPage)) continue;
            cursor.getQueue().deliverAsync();
            break;
        }
    }
}

