/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TP;
import org.jgroups.util.Runner;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class DiagnosticsHandler
extends ReceiverAdapter {
    public static final String UDP_THREAD_NAME = "UdpDiagHandler";
    public static final String TCP_THREAD_NAME = "TcpDiagHandler";
    protected TP transport;
    protected volatile boolean udp_enabled = true;
    protected volatile boolean tcp_enabled = true;
    protected ServerSocket srv_sock;
    protected Runner udp_runner;
    protected Runner tcp_runner;
    protected MulticastSocket udp_mcast_sock;
    protected DatagramSocket udp_ucast_sock;
    protected InetAddress diagnostics_addr;
    protected InetAddress diagnostics_bind_addr;
    protected int diagnostics_port = 7500;
    protected int diagnostics_port_range = 50;
    protected int ttl = 8;
    protected List<NetworkInterface> bind_interfaces;
    protected final Set<ProbeHandler> handlers = new CopyOnWriteArraySet<ProbeHandler>();
    protected final Log log;
    protected final SocketFactory socket_factory;
    protected final ThreadFactory thread_factory;
    protected final String passcode;
    protected final BiConsumer<SocketAddress, String> udp_response_sender = (sender, response) -> this.sendResponse(this.udp_ucast_sock, (SocketAddress)sender, response.getBytes());

    public DiagnosticsHandler(InetAddress diagnostics_addr, int diagnostics_port, Log log, SocketFactory socket_factory, ThreadFactory thread_factory) {
        this(diagnostics_addr, diagnostics_port, log, socket_factory, thread_factory, null);
    }

    public DiagnosticsHandler(InetAddress diagnostics_addr, int diagnostics_port, Log log, SocketFactory socket_factory, ThreadFactory thread_factory, String passcode) {
        this.diagnostics_addr = diagnostics_addr;
        this.diagnostics_port = diagnostics_port;
        this.log = log;
        this.socket_factory = socket_factory;
        this.thread_factory = thread_factory;
        this.passcode = passcode;
    }

    public DiagnosticsHandler(InetAddress diagnostics_addr, int diagnostics_port, List<NetworkInterface> bind_interfaces, int diagnostics_ttl, Log log, SocketFactory socket_factory, ThreadFactory thread_factory, String passcode) {
        this(diagnostics_addr, diagnostics_port, log, socket_factory, thread_factory, passcode);
        this.bind_interfaces = bind_interfaces;
        this.ttl = diagnostics_ttl;
    }

    public TP transport() {
        return this.transport;
    }

    public DiagnosticsHandler transport(TP tp) {
        this.transport = tp;
        return this;
    }

    public DiagnosticsHandler setDiagnosticsBindAddress(InetAddress a) {
        this.diagnostics_bind_addr = a;
        return this;
    }

    public InetAddress getDiagnosticsBindAddress() {
        return this.diagnostics_bind_addr;
    }

    public boolean udpEnabled() {
        return this.udp_enabled;
    }

    public DiagnosticsHandler enableUdp(boolean f) {
        this.udp_enabled = f;
        return this;
    }

    public boolean tcpEnabled() {
        return this.tcp_enabled;
    }

    public DiagnosticsHandler enableTcp(boolean f) {
        this.tcp_enabled = f;
        return this;
    }

    public int getDiagnosticsPortRange() {
        return this.diagnostics_port_range;
    }

    public DiagnosticsHandler setDiagnosticsPortRange(int r) {
        this.diagnostics_port_range = r;
        return this;
    }

    public DiagnosticsHandler setThreadNames() {
        Thread tmp;
        if (this.udp_runner != null && (tmp = this.udp_runner.getThread()) != null) {
            this.thread_factory.renameThread(UDP_THREAD_NAME, tmp);
        }
        if (this.tcp_runner != null && this.tcp_runner.isRunning() && (tmp = this.tcp_runner.getThread()) != null) {
            this.thread_factory.renameThread(TCP_THREAD_NAME, tmp);
        }
        return this;
    }

    public DiagnosticsHandler unsetThreadNames() {
        if (this.udp_runner != null) {
            this.udp_runner.threadName(UDP_THREAD_NAME);
        }
        if (this.tcp_runner != null) {
            this.tcp_runner.threadName(TCP_THREAD_NAME);
        }
        return this;
    }

    public Set<ProbeHandler> getProbeHandlers() {
        return this.handlers;
    }

    public void registerProbeHandler(ProbeHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    public void unregisterProbeHandler(ProbeHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void start() throws Exception {
        if (!this.udp_enabled && !this.tcp_enabled) {
            throw new IllegalStateException("both UDP and TCP are disabled - enable at least 1 of them");
        }
        if (this.udp_enabled) {
            this.startUDP();
        }
        if (this.tcp_enabled) {
            this.startTCP();
        }
    }

    public void stop() {
        Util.close(this.udp_runner, this.tcp_runner);
    }

    public boolean isRunning() {
        return this.udp_runner != null && this.udp_runner.isRunning() || this.tcp_runner != null && this.tcp_runner.isRunning();
    }

    protected void runUDP() {
        byte[] buf = new byte[10000];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        try {
            this.udp_mcast_sock.receive(packet);
            int payloadStartOffset = 0;
            if (this.passcode != null) {
                payloadStartOffset = this.authorizeProbeRequest(packet);
            }
            this.handleDiagnosticProbe(packet.getSocketAddress(), new String(packet.getData(), packet.getOffset() + payloadStartOffset, packet.getLength()), this.udp_response_sender);
        }
        catch (IOException payloadStartOffset) {
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("FailureHandlingDiagnosticsRequest"), e);
        }
    }

    protected void runTCP() {
        SocketAddress sender = null;
        try (Socket client_sock = this.srv_sock.accept();
             InputStream input = client_sock.getInputStream();
             OutputStream output = client_sock.getOutputStream();){
            sender = client_sock.getRemoteSocketAddress();
            String request = Util.readLine(input);
            this.handleDiagnosticProbe(sender, request, (snd, response) -> {
                try {
                    output.write(response.getBytes());
                }
                catch (IOException e) {
                    this.log.error("%s: failed handling TCP probe request: %s", this.transport.getLocalAddress(), e.getMessage());
                }
            });
        }
        catch (Throwable t) {
            this.log.error("%s: failed processing TCP client request from %s: %s", this.transport.getLocalAddress(), sender, t);
        }
    }

    protected DiagnosticsHandler startUDP() throws Exception {
        if (this.udp_ucast_sock == null || this.udp_ucast_sock.isClosed()) {
            this.udp_ucast_sock = this.socket_factory.createDatagramSocket("jgroups.tp.diag.udp_ucast_sock");
        }
        if (this.udp_mcast_sock == null || this.udp_mcast_sock.isClosed()) {
            this.udp_mcast_sock = Util.can_bind_to_mcast_addr ? Util.createMulticastSocket(this.socket_factory, "jgroups.tp.diag.udp_mcast_sock", this.diagnostics_addr, this.diagnostics_port, this.log) : this.socket_factory.createMulticastSocket("jgroups.tp.diag.udp_mcast_sock", this.diagnostics_port);
            try {
                this.udp_mcast_sock.setTimeToLive(this.ttl);
            }
            catch (Exception ex) {
                this.log.error("failed setting TTL %d in MulticastSocket: %s", this.ttl, ex.getMessage());
            }
            List<NetworkInterface> interfaces = this.bind_interfaces != null ? this.bind_interfaces : Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.udp_mcast_sock);
        }
        if (this.udp_runner == null) {
            this.udp_runner = new Runner(this.thread_factory, UDP_THREAD_NAME, this::runUDP, () -> Util.close(this.udp_mcast_sock, this.udp_ucast_sock)).daemon(true);
        }
        this.udp_runner.start();
        return this;
    }

    protected DiagnosticsHandler startTCP() throws Exception {
        if (this.srv_sock == null || this.srv_sock.isClosed()) {
            this.srv_sock = Util.createServerSocket(this.socket_factory, "jgroups.tp.diag.tcp_sock", this.diagnostics_bind_addr, this.diagnostics_port, this.diagnostics_port + this.diagnostics_port_range);
        }
        if (this.tcp_runner == null) {
            this.tcp_runner = new Runner(this.thread_factory, TCP_THREAD_NAME, this::runTCP, () -> Util.close((Closeable)this.srv_sock));
        }
        this.tcp_runner.start();
        return this;
    }

    protected void handleDiagnosticProbe(SocketAddress sender, String request, BiConsumer<SocketAddress, String> rsp_sender) {
        StringTokenizer tok = new StringTokenizer(request);
        ArrayList<String> list = new ArrayList<String>(10);
        while (tok.hasMoreTokens()) {
            String req = tok.nextToken().trim();
            if (req.isEmpty()) continue;
            if (req.startsWith("cluster=")) {
                if (this.sameCluster(req)) continue;
                return;
            }
            list.add(req);
        }
        if (list.isEmpty()) {
            if (this.transport != null) {
                Address local_addr = this.transport.localAddress();
                String default_rsp = String.format("local_addr=%s\nphysical_addr=%s\nview=%s\ncluster=%s\nversion=%s\n", local_addr != null ? local_addr : "n/a", this.transport.getLocalPhysicalAddress(), this.transport.view(), this.transport.getClusterName(), Version.description);
                rsp_sender.accept(sender, default_rsp);
            }
            return;
        }
        String[] tokens = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tokens[i] = (String)list.get(i);
        }
        for (ProbeHandler handler : this.handlers) {
            Map<String, String> map = null;
            try {
                map = handler.handleProbe(tokens);
            }
            catch (IllegalArgumentException ex) {
                this.log.warn(ex.getMessage());
                return;
            }
            if (map == null || map.isEmpty()) continue;
            StringBuilder info = new StringBuilder(this.defaultHeaders());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                info.append(String.format("%s=%s\r\n", entry.getKey(), entry.getValue()));
            }
            String diag_rsp = info.toString();
            rsp_sender.accept(sender, diag_rsp);
        }
    }

    protected String defaultHeaders() {
        if (this.transport == null) {
            return "";
        }
        Address local_addr = this.transport.localAddress();
        View view = this.transport.view();
        int num_members = view != null ? view.size() : 0;
        return String.format("local_addr=%s [ip=%s, version=%s, cluster=%s, %d mbr(s)]\n", local_addr != null ? local_addr : "n/a", this.transport.getLocalPhysicalAddress(), Version.description, this.transport.getClusterName(), num_members);
    }

    protected boolean sameCluster(String req) {
        if (!req.startsWith("cluster=")) {
            return true;
        }
        String cluster_name_pattern = req.substring("cluster=".length()).trim();
        String cname = this.transport.getClusterName();
        if (cluster_name_pattern != null && !Util.patternMatch(cluster_name_pattern, cname)) {
            this.log.debug("Probe request dropped as cluster name %s does not match pattern %s", cname, cluster_name_pattern);
            return false;
        }
        return true;
    }

    protected int authorizeProbeRequest(DatagramPacket packet) throws Exception {
        int offset = 0;
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.getData());
        DataInputStream in = new DataInputStream(bis);
        long t1 = in.readLong();
        double q1 = in.readDouble();
        int length = in.readInt();
        byte[] digest = new byte[length];
        in.readFully(digest);
        offset = 20 + digest.length;
        byte[] local = Util.createDigest(this.passcode, t1, q1);
        if (!MessageDigest.isEqual(digest, local)) {
            throw new Exception("Authorization failed! Make sure correct passcode is used");
        }
        return offset;
    }

    protected void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) {
        try {
            DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
            sock.send(p);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedSendingDiagRspTo") + sender, t);
        }
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s) {
        InetSocketAddress group_addr = new InetSocketAddress(this.diagnostics_addr, this.diagnostics_port);
        for (NetworkInterface i : interfaces) {
            try {
                List<InterfaceAddress> inet_addrs;
                if (!Util.isUp(i) || (inet_addrs = i.getInterfaceAddresses()) == null || inet_addrs.isEmpty()) continue;
                s.joinGroup(group_addr, i);
                this.log.trace("joined %s on %s", group_addr, i.getName());
            }
            catch (Exception e) {
                this.log.warn("failed to join " + group_addr + " on " + i.getName() + ": " + e);
            }
        }
    }

    public static interface ProbeHandler {
        public Map<String, String> handleProbe(String ... var1);

        public String[] supportedKeys();
    }
}

