/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.encoding.CachedCodeBase;
import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.impl.transport.CorbaResponseWaitingRoomImpl;
import com.sun.corba.se.impl.transport.EventHandlerBase;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ConnectionCache;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.EventHandler;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.pept.transport.ResponseWaitingRoom;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.CorbaResponseWaitingRoom;
import com.sun.corba.se.spi.transport.ReadTimeouts;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import sun.corba.OutputStreamFactory;

public class SocketOrChannelConnectionImpl
extends EventHandlerBase
implements CorbaConnection,
Work {
    public static boolean dprintWriteLocks = false;
    protected long enqueueTime;
    protected SocketChannel socketChannel;
    protected CorbaContactInfo contactInfo;
    protected Acceptor acceptor;
    protected ConnectionCache connectionCache;
    protected Socket socket;
    protected long timeStamp = 0L;
    protected boolean isServer = false;
    protected int requestId = 5;
    protected CorbaResponseWaitingRoom responseWaitingRoom;
    protected int state;
    protected Object stateEvent = new Object();
    protected Object writeEvent = new Object();
    protected boolean writeLocked;
    protected int serverRequestCount = 0;
    Map serverRequestMap = null;
    protected boolean postInitialContexts = false;
    protected IOR codeBaseServerIOR;
    protected CachedCodeBase cachedCodeBase = new CachedCodeBase(this);
    protected ORBUtilSystemException wrapper;
    protected ReadTimeouts readTimeouts;
    protected boolean shouldReadGiopHeaderOnly;
    protected CorbaMessageMediator partialMessageMediator = null;
    protected CodeSetComponentInfo.CodeSetContext codeSetContext = null;
    protected MessageMediator clientReply_1_1;
    protected MessageMediator serverRequest_1_1;

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    protected SocketOrChannelConnectionImpl(ORB orb) {
        this.orb = orb;
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.transport");
        this.setWork(this);
        this.responseWaitingRoom = new CorbaResponseWaitingRoomImpl(orb, this);
        this.setReadTimeouts(orb.getORBData().getTransportTCPReadTimeouts());
    }

    protected SocketOrChannelConnectionImpl(ORB orb, boolean useSelectThreadToWait, boolean useWorkerThread) {
        this(orb);
        this.setUseSelectThreadToWait(useSelectThreadToWait);
        this.setUseWorkerThreadForEvent(useWorkerThread);
    }

    public SocketOrChannelConnectionImpl(ORB orb, CorbaContactInfo contactInfo, boolean useSelectThreadToWait, boolean useWorkerThread, String socketType, String hostname, int port) {
        this(orb, useSelectThreadToWait, useWorkerThread);
        this.contactInfo = contactInfo;
        try {
            this.socket = orb.getORBData().getSocketFactory().createSocket(socketType, new InetSocketAddress(hostname, port));
            this.socketChannel = this.socket.getChannel();
            if (this.socketChannel != null) {
                boolean isBlocking = !useSelectThreadToWait;
                this.socketChannel.configureBlocking(isBlocking);
            } else {
                this.setUseSelectThreadToWait(false);
            }
            if (orb.transportDebugFlag) {
                this.dprint(".initialize: connection created: " + this.socket);
            }
        }
        catch (Throwable t) {
            throw this.wrapper.connectFailure(t, (Object)socketType, (Object)hostname, (Object)Integer.toString(port));
        }
        this.state = 1;
    }

    public SocketOrChannelConnectionImpl(ORB orb, CorbaContactInfo contactInfo, String socketType, String hostname, int port) {
        this(orb, contactInfo, orb.getORBData().connectionSocketUseSelectThreadToWait(), orb.getORBData().connectionSocketUseWorkerThreadForEvent(), socketType, hostname, port);
    }

    public SocketOrChannelConnectionImpl(ORB orb, Acceptor acceptor, Socket socket, boolean useSelectThreadToWait, boolean useWorkerThread) {
        this(orb, useSelectThreadToWait, useWorkerThread);
        this.socket = socket;
        this.socketChannel = socket.getChannel();
        if (this.socketChannel != null) {
            try {
                boolean isBlocking = !useSelectThreadToWait;
                this.socketChannel.configureBlocking(isBlocking);
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException();
                rte.initCause(e);
                throw rte;
            }
        }
        this.acceptor = acceptor;
        this.serverRequestMap = Collections.synchronizedMap(new HashMap());
        this.isServer = true;
        this.state = 2;
    }

    public SocketOrChannelConnectionImpl(ORB orb, Acceptor acceptor, Socket socket) {
        this(orb, acceptor, socket, socket.getChannel() == null ? false : orb.getORBData().connectionSocketUseSelectThreadToWait(), socket.getChannel() == null ? false : orb.getORBData().connectionSocketUseWorkerThreadForEvent());
    }

    @Override
    public boolean shouldRegisterReadEvent() {
        return true;
    }

    @Override
    public boolean shouldRegisterServerReadEvent() {
        return true;
    }

    @Override
    public boolean read() {
        try {
            CorbaMessageMediator messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".read->: " + this);
            }
            if ((messageMediator = this.readBits()) != null) {
                boolean bl = this.dispatch(messageMediator);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".read<-: " + this);
            }
        }
    }

    protected CorbaMessageMediator readBits() {
        try {
            MessageMediator messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".readBits->: " + this);
            }
            if (this.contactInfo != null) {
                messageMediator = this.contactInfo.createMessageMediator(this.orb, this);
            } else if (this.acceptor != null) {
                messageMediator = this.acceptor.createMessageMediator(this.orb, this);
            } else {
                throw new RuntimeException("SocketOrChannelConnectionImpl.readBits");
            }
            CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
            return corbaMessageMediator;
        }
        catch (ThreadDeath td) {
            block20: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".readBits: " + this + ": ThreadDeath: " + td, td);
                }
                try {
                    this.purgeCalls(this.wrapper.connectionAbort(td), false, false);
                }
                catch (Throwable t) {
                    if (!this.orb.transportDebugFlag) break block20;
                    this.dprint(".readBits: " + this + ": purgeCalls: Throwable: " + t, t);
                }
            }
            throw td;
        }
        catch (Throwable ex) {
            block21: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".readBits: " + this + ": Throwable: " + ex, ex);
                }
                try {
                    if (ex instanceof INTERNAL) {
                        this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException e) {
                    if (!this.orb.transportDebugFlag) break block21;
                    this.dprint(".readBits: " + this + ": sendMessageError: IOException: " + e, e);
                }
            }
            Selector selector = this.orb.getTransportManager().getSelector(0);
            if (selector != null) {
                selector.unregisterForEvent(this);
            }
            this.purgeCalls(this.wrapper.connectionAbort(ex), true, false);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".readBits<-: " + this);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator finishReadingBits(MessageMediator messageMediator) {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".finishReadingBits->: " + this);
            }
            if (this.contactInfo != null) {
                messageMediator = this.contactInfo.finishCreatingMessageMediator(this.orb, this, messageMediator);
            } else if (this.acceptor != null) {
                messageMediator = this.acceptor.finishCreatingMessageMediator(this.orb, this, messageMediator);
            } else {
                throw new RuntimeException("SocketOrChannelConnectionImpl.finishReadingBits");
            }
            CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
            return corbaMessageMediator;
        }
        catch (ThreadDeath td) {
            block19: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".finishReadingBits: " + this + ": ThreadDeath: " + td, td);
                }
                try {
                    this.purgeCalls(this.wrapper.connectionAbort(td), false, false);
                }
                catch (Throwable t) {
                    if (!this.orb.transportDebugFlag) break block19;
                    this.dprint(".finishReadingBits: " + this + ": purgeCalls: Throwable: " + t, t);
                }
            }
            throw td;
        }
        catch (Throwable ex) {
            block20: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".finishReadingBits: " + this + ": Throwable: " + ex, ex);
                }
                try {
                    if (ex instanceof INTERNAL) {
                        this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException e) {
                    if (!this.orb.transportDebugFlag) break block20;
                    this.dprint(".finishReadingBits: " + this + ": sendMessageError: IOException: " + e, e);
                }
            }
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
            this.purgeCalls(this.wrapper.connectionAbort(ex), true, false);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".finishReadingBits<-: " + this);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatch(CorbaMessageMediator messageMediator) {
        try {
            boolean result;
            if (this.orb.transportDebugFlag) {
                this.dprint(".dispatch->: " + this);
            }
            boolean bl = result = messageMediator.getProtocolHandler().handleRequest(messageMediator);
            return bl;
        }
        catch (ThreadDeath td) {
            block15: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".dispatch: ThreadDeath", td);
                }
                try {
                    this.purgeCalls(this.wrapper.connectionAbort(td), false, false);
                }
                catch (Throwable t) {
                    if (!this.orb.transportDebugFlag) break block15;
                    this.dprint(".dispatch: purgeCalls: Throwable", t);
                }
            }
            throw td;
        }
        catch (Throwable ex) {
            block16: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".dispatch: Throwable", ex);
                }
                try {
                    if (ex instanceof INTERNAL) {
                        this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException e) {
                    if (!this.orb.transportDebugFlag) break block16;
                    this.dprint(".dispatch: sendMessageError: IOException", e);
                }
            }
            this.purgeCalls(this.wrapper.connectionAbort(ex), false, false);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".dispatch<-: " + this);
            }
        }
        return true;
    }

    @Override
    public boolean shouldUseDirectByteBuffers() {
        return this.getSocketChannel() != null;
    }

    @Override
    public ByteBuffer read(int size, int offset, int length, long max_wait_time) throws IOException {
        if (this.shouldUseDirectByteBuffers()) {
            ByteBuffer byteBuffer = this.orb.getByteBufferPool().getByteBuffer(size);
            if (this.orb.transportDebugFlag) {
                int bbAddress = System.identityHashCode(byteBuffer);
                StringBuffer sb = new StringBuffer(80);
                sb.append(".read: got ByteBuffer id (");
                sb.append(bbAddress).append(") from ByteBufferPool.");
                String msgStr = sb.toString();
                this.dprint(msgStr);
            }
            byteBuffer.position(offset);
            byteBuffer.limit(size);
            this.readFully(byteBuffer, length, max_wait_time);
            return byteBuffer;
        }
        byte[] buf = new byte[size];
        this.readFully(this.getSocket().getInputStream(), buf, offset, length, max_wait_time);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public ByteBuffer read(ByteBuffer byteBuffer, int offset, int length, long max_wait_time) throws IOException {
        int size = offset + length;
        if (this.shouldUseDirectByteBuffers()) {
            if (!byteBuffer.isDirect()) {
                throw this.wrapper.unexpectedNonDirectByteBufferWithChannelSocket();
            }
            if (size > byteBuffer.capacity()) {
                if (this.orb.transportDebugFlag) {
                    int bbAddress = System.identityHashCode(byteBuffer);
                    StringBuffer bbsb = new StringBuffer(80);
                    bbsb.append(".read: releasing ByteBuffer id (").append(bbAddress).append(") to ByteBufferPool.");
                    String bbmsg = bbsb.toString();
                    this.dprint(bbmsg);
                }
                this.orb.getByteBufferPool().releaseByteBuffer(byteBuffer);
                byteBuffer = this.orb.getByteBufferPool().getByteBuffer(size);
            }
            byteBuffer.position(offset);
            byteBuffer.limit(size);
            this.readFully(byteBuffer, length, max_wait_time);
            byteBuffer.position(0);
            byteBuffer.limit(size);
            return byteBuffer;
        }
        if (byteBuffer.isDirect()) {
            throw this.wrapper.unexpectedDirectByteBufferWithNonChannelSocket();
        }
        byte[] buf = new byte[size];
        this.readFully(this.getSocket().getInputStream(), buf, offset, length, max_wait_time);
        return ByteBuffer.wrap(buf);
    }

    public void readFully(ByteBuffer byteBuffer, int size, long max_wait_time) throws IOException {
        int n = 0;
        int bytecount = 0;
        long time_to_wait = this.readTimeouts.get_initial_time_to_wait();
        long total_time_in_wait = 0L;
        do {
            if ((bytecount = this.getSocketChannel().read(byteBuffer)) < 0) {
                throw new IOException("End-of-stream");
            }
            if (bytecount == 0) {
                try {
                    Thread.sleep(time_to_wait);
                    total_time_in_wait += time_to_wait;
                    time_to_wait = (long)((double)time_to_wait * this.readTimeouts.get_backoff_factor());
                }
                catch (InterruptedException ie) {
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint("readFully(): unexpected exception " + ie.toString());
                }
                continue;
            }
            n += bytecount;
        } while (n < size && total_time_in_wait < max_wait_time);
        if (n < size && total_time_in_wait >= max_wait_time) {
            throw this.wrapper.transportReadTimeoutExceeded(new Integer(size), new Integer(n), new Long(max_wait_time), new Long(total_time_in_wait));
        }
        this.getConnectionCache().stampTime(this);
    }

    public void readFully(InputStream is, byte[] buf, int offset, int size, long max_wait_time) throws IOException {
        int n = 0;
        int bytecount = 0;
        long time_to_wait = this.readTimeouts.get_initial_time_to_wait();
        long total_time_in_wait = 0L;
        do {
            if ((bytecount = is.read(buf, offset + n, size - n)) < 0) {
                throw new IOException("End-of-stream");
            }
            if (bytecount == 0) {
                try {
                    Thread.sleep(time_to_wait);
                    total_time_in_wait += time_to_wait;
                    time_to_wait = (long)((double)time_to_wait * this.readTimeouts.get_backoff_factor());
                }
                catch (InterruptedException ie) {
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint("readFully(): unexpected exception " + ie.toString());
                }
                continue;
            }
            n += bytecount;
        } while (n < size && total_time_in_wait < max_wait_time);
        if (n < size && total_time_in_wait >= max_wait_time) {
            throw this.wrapper.transportReadTimeoutExceeded(new Integer(size), new Integer(n), new Long(max_wait_time), new Long(total_time_in_wait));
        }
        this.getConnectionCache().stampTime(this);
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        if (this.shouldUseDirectByteBuffers()) {
            do {
                this.getSocketChannel().write(byteBuffer);
            } while (byteBuffer.hasRemaining());
        } else {
            if (!byteBuffer.hasArray()) {
                throw this.wrapper.unexpectedDirectByteBufferWithNonChannelSocket();
            }
            byte[] tmpBuf = byteBuffer.array();
            this.getSocket().getOutputStream().write(tmpBuf, 0, byteBuffer.limit());
            this.getSocket().getOutputStream().flush();
        }
        this.getConnectionCache().stampTime(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            block20: {
                block19: {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".close->: " + this);
                    }
                    this.writeLock();
                    if (this.isBusy()) {
                        this.writeUnlock();
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".close: isBusy so no close: " + this);
                        }
                        return;
                    }
                    try {
                        try {
                            this.sendCloseConnection(GIOPVersion.V1_0);
                        }
                        catch (Throwable t) {
                            this.wrapper.exceptionWhenSendingCloseConnection(t);
                        }
                        Object t = this.stateEvent;
                        synchronized (t) {
                            this.state = 3;
                            this.stateEvent.notifyAll();
                        }
                        this.purgeCalls(this.wrapper.connectionRebind(), false, true);
                    }
                    catch (Exception ex) {
                        if (!this.orb.transportDebugFlag) break block19;
                        this.dprint(".close: exception: " + this, ex);
                    }
                }
                try {
                    Selector selector = this.orb.getTransportManager().getSelector(0);
                    if (selector != null) {
                        selector.unregisterForEvent(this);
                    }
                    if (this.socketChannel != null) {
                        this.socketChannel.close();
                    }
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!this.orb.transportDebugFlag) break block20;
                    this.dprint(".close: " + this, e);
                }
            }
            this.closeConnectionResources();
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-: " + this);
            }
        }
    }

    @Override
    public void closeConnectionResources() {
        block7: {
            Selector selector;
            if (this.orb.transportDebugFlag) {
                this.dprint(".closeConnectionResources->: " + this);
            }
            if ((selector = this.orb.getTransportManager().getSelector(0)) != null) {
                selector.unregisterForEvent(this);
            }
            try {
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                }
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                if (!this.orb.transportDebugFlag) break block7;
                this.dprint(".closeConnectionResources: " + this, e);
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".closeConnectionResources<-: " + this);
        }
    }

    @Override
    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public EventHandler getEventHandler() {
        return this;
    }

    public OutputObject createOutputObject(MessageMediator messageMediator) {
        throw new RuntimeException("*****SocketOrChannelConnectionImpl.createOutputObject - should not be called.");
    }

    @Override
    public boolean isServer() {
        return this.isServer;
    }

    @Override
    public boolean isBusy() {
        return this.serverRequestCount > 0 || this.getResponseWaitingRoom().numberRegistered() > 0;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setTimeStamp(long time) {
        this.timeStamp = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(String stateString) {
        Object object = this.stateEvent;
        synchronized (object) {
            if (stateString.equals("ESTABLISHED")) {
                this.state = 2;
                this.stateEvent.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void writeLock() {
        try {
            if (SocketOrChannelConnectionImpl.dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeLock->: " + this);
            }
            block23: while (true) {
                localState = this.state;
                switch (localState) {
                    case 1: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state != 1) {
                            // MONITOREXIT : var2_2
                            continue block23;
                        }
                        try {
                            this.stateEvent.wait();
                        }
                        catch (InterruptedException ie) {
                            if (!this.orb.transportDebugFlag) ** GOTO lbl19
                            this.dprint(".writeLock: OPENING InterruptedException: " + this);
                        }
lbl19:
                        // 3 sources

                        continue block23;
                    }
                    case 2: {
                        var2_2 = this.writeEvent;
                        // MONITORENTER : var2_2
                        if (!this.writeLocked) {
                            this.writeLocked = true;
                            // MONITOREXIT : var2_2
                            return;
                        }
                        try {
                            while (this.state == 2 && this.writeLocked) {
                                this.writeEvent.wait(100L);
                            }
                        }
                        catch (InterruptedException ie) {
                            if (!this.orb.transportDebugFlag) ** GOTO lbl36
                            this.dprint(".writeLock: ESTABLISHED InterruptedException: " + this);
                        }
lbl36:
                        // 3 sources

                        continue block23;
                    }
                    case 5: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state == 5) throw this.wrapper.writeErrorSend();
                        // MONITOREXIT : var2_2
                        continue block23;
                    }
                    case 4: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state == 4) throw this.wrapper.connectionCloseRebind();
                        // MONITOREXIT : var2_2
                        continue block23;
                    }
                }
                if (this.orb.transportDebugFlag == false) throw new RuntimeException(".writeLock: bad state");
                this.dprint(".writeLock: default: " + this);
                throw new RuntimeException(".writeLock: bad state");
            }
        }
        finally {
            if (SocketOrChannelConnectionImpl.dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeLock<-: " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnlock() {
        try {
            if (dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeUnlock->: " + this);
            }
            Object object = this.writeEvent;
            synchronized (object) {
                this.writeLocked = false;
                this.writeEvent.notify();
            }
        }
        finally {
            if (dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeUnlock<-: " + this);
            }
        }
    }

    @Override
    public void sendWithoutLock(OutputObject outputObject) {
        try {
            CDROutputObject cdrOutputObject = (CDROutputObject)outputObject;
            cdrOutputObject.writeTo(this);
        }
        catch (IOException e1) {
            COMM_FAILURE exc = this.wrapper.writeErrorSend(e1);
            this.purgeCalls(exc, false, true);
            throw exc;
        }
    }

    @Override
    public void registerWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.registerWaiter(messageMediator);
    }

    @Override
    public void unregisterWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.unregisterWaiter(messageMediator);
    }

    @Override
    public InputObject waitForResponse(MessageMediator messageMediator) {
        return this.responseWaitingRoom.waitForResponse(messageMediator);
    }

    @Override
    public void setConnectionCache(ConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    @Override
    public ConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public void setUseSelectThreadToWait(boolean x) {
        this.useSelectThreadToWait = x;
        this.setReadGiopHeaderOnly(this.shouldUseSelectThreadToWait());
    }

    @Override
    public void handleEvent() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent->: " + this);
        }
        this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() & ~this.getInterestOps());
        if (this.shouldUseWorkerThreadForEvent()) {
            Exception throwable = null;
            try {
                int poolToUse = 0;
                if (this.shouldReadGiopHeaderOnly()) {
                    this.partialMessageMediator = this.readBits();
                    poolToUse = this.partialMessageMediator.getThreadPoolToUse();
                }
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: addWork to pool: " + poolToUse);
                }
                this.orb.getThreadPoolManager().getThreadPool(poolToUse).getWorkQueue(0).addWork(this.getWork());
            }
            catch (NoSuchThreadPoolException e) {
                throwable = e;
            }
            catch (NoSuchWorkQueueException e) {
                throwable = e;
            }
            if (throwable != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: " + throwable);
                }
                INTERNAL i = new INTERNAL("NoSuchThreadPoolException");
                i.initCause(throwable);
                throw i;
            }
        } else {
            if (this.orb.transportDebugFlag) {
                this.dprint(".handleEvent: doWork");
            }
            this.getWork().doWork();
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent<-: " + this);
        }
    }

    @Override
    public SelectableChannel getChannel() {
        return this.socketChannel;
    }

    @Override
    public int getInterestOps() {
        return 1;
    }

    @Override
    public Connection getConnection() {
        return this;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork->: " + this);
            }
            if (!this.shouldReadGiopHeaderOnly()) {
                this.read();
            } else {
                CorbaMessageMediator messageMediator = this.getPartialMessageMediator();
                if ((messageMediator = this.finishReadingBits(messageMediator)) != null) {
                    this.dispatch(messageMediator);
                }
            }
        }
        catch (Throwable t) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Throwable: " + t + " " + this);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork<-: " + this);
            }
        }
    }

    @Override
    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public boolean shouldReadGiopHeaderOnly() {
        return this.shouldReadGiopHeaderOnly;
    }

    protected void setReadGiopHeaderOnly(boolean shouldReadHeaderOnly) {
        this.shouldReadGiopHeaderOnly = shouldReadHeaderOnly;
    }

    @Override
    public ResponseWaitingRoom getResponseWaitingRoom() {
        return this.responseWaitingRoom;
    }

    @Override
    public void serverRequestMapPut(int requestId, CorbaMessageMediator messageMediator) {
        this.serverRequestMap.put(new Integer(requestId), messageMediator);
    }

    @Override
    public CorbaMessageMediator serverRequestMapGet(int requestId) {
        return (CorbaMessageMediator)this.serverRequestMap.get(new Integer(requestId));
    }

    @Override
    public void serverRequestMapRemove(int requestId) {
        this.serverRequestMap.remove(new Integer(requestId));
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public synchronized void serverRequestProcessingBegins() {
        ++this.serverRequestCount;
    }

    @Override
    public synchronized void serverRequestProcessingEnds() {
        --this.serverRequestCount;
    }

    @Override
    public synchronized int getNextRequestId() {
        return this.requestId++;
    }

    @Override
    public ORB getBroker() {
        return this.orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeSetComponentInfo.CodeSetContext getCodeSetContext() {
        if (this.codeSetContext == null) {
            SocketOrChannelConnectionImpl socketOrChannelConnectionImpl = this;
            synchronized (socketOrChannelConnectionImpl) {
                return this.codeSetContext;
            }
        }
        return this.codeSetContext;
    }

    @Override
    public synchronized void setCodeSetContext(CodeSetComponentInfo.CodeSetContext csc) {
        if (this.codeSetContext == null) {
            if (OSFCodeSetRegistry.lookupEntry(csc.getCharCodeSet()) == null || OSFCodeSetRegistry.lookupEntry(csc.getWCharCodeSet()) == null) {
                throw this.wrapper.badCodesetsFromClient();
            }
            this.codeSetContext = csc;
        }
    }

    @Override
    public MessageMediator clientRequestMapGet(int requestId) {
        return this.responseWaitingRoom.getMessageMediator(requestId);
    }

    @Override
    public void clientReply_1_1_Put(MessageMediator x) {
        this.clientReply_1_1 = x;
    }

    @Override
    public MessageMediator clientReply_1_1_Get() {
        return this.clientReply_1_1;
    }

    @Override
    public void clientReply_1_1_Remove() {
        this.clientReply_1_1 = null;
    }

    @Override
    public void serverRequest_1_1_Put(MessageMediator x) {
        this.serverRequest_1_1 = x;
    }

    @Override
    public MessageMediator serverRequest_1_1_Get() {
        return this.serverRequest_1_1;
    }

    @Override
    public void serverRequest_1_1_Remove() {
        this.serverRequest_1_1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStateString(int state) {
        Object object = this.stateEvent;
        synchronized (object) {
            switch (state) {
                case 1: {
                    return "OPENING";
                }
                case 2: {
                    return "ESTABLISHED";
                }
                case 3: {
                    return "CLOSE_SENT";
                }
                case 4: {
                    return "CLOSE_RECVD";
                }
                case 5: {
                    return "ABORT";
                }
            }
            return "???";
        }
    }

    @Override
    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    @Override
    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void purgeCalls(SystemException systemException, boolean die, boolean lockHeld) {
        int minor_code = systemException.minor;
        try {
            block23: {
                block22: {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".purgeCalls->: " + minor_code + "/" + die + "/" + lockHeld + " " + this);
                    }
                    Object object = this.stateEvent;
                    synchronized (object) {
                        if (this.state == 5 || this.state == 4) {
                            if (!this.orb.transportDebugFlag) return;
                            this.dprint(".purgeCalls: exiting since state is: " + this.getStateString(this.state) + " " + this);
                            return;
                        }
                    }
                    try {
                        if (!lockHeld) {
                            this.writeLock();
                        }
                    }
                    catch (SystemException ex) {
                        if (!this.orb.transportDebugFlag) break block22;
                        this.dprint(".purgeCalls: SystemException" + ex + "; continuing " + this);
                    }
                }
                Object object = this.stateEvent;
                synchronized (object) {
                    if (minor_code == 1398079697) {
                        this.state = 4;
                        systemException.completed = CompletionStatus.COMPLETED_NO;
                    } else {
                        this.state = 5;
                        systemException.completed = CompletionStatus.COMPLETED_MAYBE;
                    }
                    this.stateEvent.notifyAll();
                }
                try {
                    this.socket.getInputStream().close();
                    this.socket.getOutputStream().close();
                    this.socket.close();
                }
                catch (Exception ex) {
                    if (!this.orb.transportDebugFlag) break block23;
                    this.dprint(".purgeCalls: Exception closing socket: " + ex + " " + this);
                }
            }
            this.responseWaitingRoom.signalExceptionToAllWaiters(systemException);
            return;
        }
        finally {
            if (this.contactInfo != null) {
                ((OutboundConnectionCache)this.getConnectionCache()).remove(this.contactInfo);
            } else if (this.acceptor != null) {
                ((InboundConnectionCache)this.getConnectionCache()).remove(this);
            }
            this.writeUnlock();
            if (this.orb.transportDebugFlag) {
                this.dprint(".purgeCalls<-: " + minor_code + "/" + die + "/" + lockHeld + " " + this);
            }
        }
    }

    @Override
    public void sendCloseConnection(GIOPVersion giopVersion) throws IOException {
        Message msg = MessageBase.createCloseConnection(giopVersion);
        this.sendHelper(giopVersion, msg);
    }

    @Override
    public void sendMessageError(GIOPVersion giopVersion) throws IOException {
        Message msg = MessageBase.createMessageError(giopVersion);
        this.sendHelper(giopVersion, msg);
    }

    @Override
    public void sendCancelRequest(GIOPVersion giopVersion, int requestId) throws IOException {
        CancelRequestMessage msg = MessageBase.createCancelRequest(giopVersion, requestId);
        this.sendHelper(giopVersion, msg);
    }

    protected void sendHelper(GIOPVersion giopVersion, Message msg) throws IOException {
        CDROutputObject outputObject = OutputStreamFactory.newCDROutputObject(this.orb, null, giopVersion, this, msg, (byte)1);
        msg.write(outputObject);
        outputObject.writeTo(this);
    }

    @Override
    public void sendCancelRequestWithLock(GIOPVersion giopVersion, int requestId) throws IOException {
        this.writeLock();
        try {
            this.sendCancelRequest(giopVersion, requestId);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public final void setCodeBaseIOR(IOR ior) {
        this.codeBaseServerIOR = ior;
    }

    @Override
    public final IOR getCodeBaseIOR() {
        return this.codeBaseServerIOR;
    }

    @Override
    public final CodeBase getCodeBase() {
        return this.cachedCodeBase;
    }

    protected void setReadTimeouts(ReadTimeouts readTimeouts) {
        this.readTimeouts = readTimeouts;
    }

    protected void setPartialMessageMediator(CorbaMessageMediator messageMediator) {
        this.partialMessageMediator = messageMediator;
    }

    protected CorbaMessageMediator getPartialMessageMediator() {
        return this.partialMessageMediator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.stateEvent;
        synchronized (object) {
            return "SocketOrChannelConnectionImpl[ " + (this.socketChannel == null ? this.socket.toString() : this.socketChannel.toString()) + " " + this.getStateString(this.state) + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + " " + this.shouldReadGiopHeaderOnly() + "]";
        }
    }

    @Override
    public void dprint(String msg) {
        ORBUtility.dprint("SocketOrChannelConnectionImpl", msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }
}

