/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharScanner;
import antlr.RecognitionException;

public class NoViableAltForCharException
extends RecognitionException {
    public char foundChar;

    public NoViableAltForCharException(char c, CharScanner scanner) {
        super("NoViableAlt", scanner.getFilename(), scanner.getLine(), scanner.getColumn());
        this.foundChar = c;
    }

    public NoViableAltForCharException(char c, String fileName, int line) {
        this(c, fileName, line, -1);
    }

    public NoViableAltForCharException(char c, String fileName, int line, int column) {
        super("NoViableAlt", fileName, line, column);
        this.foundChar = c;
    }

    @Override
    public String getMessage() {
        String mesg = "unexpected char: ";
        if (this.foundChar >= ' ' && this.foundChar <= '~') {
            mesg = mesg + '\'';
            mesg = mesg + this.foundChar;
            mesg = mesg + '\'';
        } else {
            mesg = mesg + "0x" + Integer.toHexString(this.foundChar).toUpperCase();
        }
        return mesg;
    }
}

