/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class QualifiedAllocationExpression
extends AllocationExpression {
    public Expression enclosingInstance;
    public TypeDeclaration anonymousType;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(TypeDeclaration anonymousType) {
        this.anonymousType = anonymousType;
        anonymousType.allocation = this;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        ReferenceBinding superclass;
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(currentScope, flowContext, flowInfo);
        } else if (this.binding != null && this.binding.declaringClass != null && (superclass = this.binding.declaringClass.superclass()) != null && superclass.isMemberType() && !superclass.isStatic()) {
            currentScope.tagAsAccessingEnclosingInstanceStateOf(superclass.enclosingType(), false);
        }
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)(this.anonymousType == null ? this.binding.declaringClass.erasure() : this.binding.declaringClass.superclass().erasure()), currentScope, flowInfo);
        if (this.arguments != null) {
            boolean analyseResources = currentScope.compilerOptions().analyseResourceLeaks;
            boolean hasResourceWrapperType = analyseResources && this.resolvedType instanceof ReferenceBinding && ((ReferenceBinding)this.resolvedType).hasTypeBit(4);
            int count = this.arguments.length;
            for (int i = 0; i < count; ++i) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo);
                if (analyseResources && !hasResourceWrapperType) {
                    flowInfo = FakedTrackingVariable.markPassedToOutside(currentScope, this.arguments[i], flowInfo, flowContext, false);
                }
                this.arguments[i].checkNPEbyUnboxing(currentScope, flowContext, flowInfo);
            }
            this.analyseArguments(currentScope, flowContext, flowInfo, this.binding, this.arguments);
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(currentScope, flowContext, flowInfo);
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                thrownExceptions = currentScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), currentScope);
        }
        if (currentScope.compilerOptions().analyseResourceLeaks && FakedTrackingVariable.isAnyCloseable(this.resolvedType)) {
            FakedTrackingVariable.analyseCloseableAllocation(currentScope, flowInfo, this);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
        flowContext.recordAbruptExit();
        return flowInfo;
    }

    @Override
    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        boolean isUnboxing;
        this.cleanUpInferenceContexts();
        if (!valueRequired) {
            currentScope.problemReporter().unusedObjectAllocation(this);
        }
        int pc = codeStream.position;
        MethodBinding codegenBinding = this.binding.original();
        ReferenceBinding allocatedType = codegenBinding.declaringClass;
        codeStream.new_(this.type, allocatedType);
        boolean bl = isUnboxing = (this.implicitConversion & 0x400) != 0;
        if (valueRequired || isUnboxing) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(pc, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(currentScope, allocatedType, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, currentScope, codeStream);
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(currentScope, allocatedType, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invoke((byte)-73, codegenBinding, null, this.typeArguments);
        } else {
            int max = this.syntheticAccessor.parameters.length - codegenBinding.parameters.length;
            for (int i = 0; i < max; ++i) {
                codeStream.aconst_null();
            }
            codeStream.invoke((byte)-73, this.syntheticAccessor, null, this.typeArguments);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (isUnboxing) {
            codeStream.generateImplicitConversion(this.implicitConversion);
            switch (this.postConversionType((Scope)currentScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        if (this.anonymousType != null) {
            this.anonymousType.generateCode(currentScope, codeStream);
        }
    }

    @Override
    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    @Override
    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding allocatedTypeErasure;
        if ((flowInfo.tagBits & 1) == 0 && (allocatedTypeErasure = (ReferenceBinding)this.binding.declaringClass.erasure()).isNestedType() && (currentScope.enclosingSourceType().isLocalType() || currentScope.isLambdaSubscope())) {
            if (allocatedTypeErasure.isLocalType()) {
                ((LocalTypeBinding)allocatedTypeErasure).addInnerEmulationDependent(currentScope, this.enclosingInstance != null);
            } else {
                currentScope.propagateInnerEmulation(allocatedTypeErasure, this.enclosingInstance != null);
            }
        }
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.enclosingInstance != null) {
            this.enclosingInstance.printExpression(0, output).append('.');
        }
        super.printExpression(0, output);
        if (this.anonymousType != null) {
            this.anonymousType.print(indent, output);
        }
        return output;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        if (this.anonymousType == null && this.enclosingInstance == null) {
            return super.resolveType(scope);
        }
        TypeBinding result = this.resolveTypeForQualifiedAllocationExpression(scope);
        if (result != null && !result.isPolyType() && this.binding != null) {
            CompilerOptions compilerOptions = scope.compilerOptions();
            if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
                if ((this.binding.tagBits & 0x1000L) == 0L) {
                    new ImplicitNullAnnotationVerifier(scope.environment(), compilerOptions.inheritNullAnnotations).checkImplicitNullAnnotations(this.binding, null, false, scope);
                }
                if (compilerOptions.sourceLevel >= 0x340000L && this.binding instanceof ParameterizedGenericMethodBinding && this.typeArguments != null) {
                    TypeBinding[] typeVariables = this.binding.original().typeVariables();
                    for (int i = 0; i < this.typeArguments.length; ++i) {
                        this.typeArguments[i].checkNullConstraints(scope, (ParameterizedGenericMethodBinding)this.binding, typeVariables, i);
                    }
                }
            }
            if (compilerOptions.sourceLevel >= 0x340000L && this.binding.getTypeAnnotations() != Binding.NO_ANNOTATIONS) {
                this.resolvedType = scope.environment().createAnnotatedType(this.resolvedType, this.binding.getTypeAnnotations());
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TypeBinding resolveTypeForQualifiedAllocationExpression(BlockScope scope) {
        TypeBinding receiverType;
        block63: {
            ReferenceBinding referenceReceiver;
            block64: {
                MethodBinding closestMatch;
                int i;
                TypeBinding[] pseudoArgs;
                block65: {
                    ReferenceBinding expectedType;
                    long sourceLevel;
                    TypeBinding enclosingInstanceType;
                    boolean isDiamond;
                    block61: {
                        block62: {
                            boolean hasError;
                            block55: {
                                ReferenceBinding currentType;
                                block60: {
                                    block52: {
                                        block59: {
                                            block53: {
                                                boolean enclosingInstanceContainsCast;
                                                block58: {
                                                    ReferenceBinding enclosingInstanceReference;
                                                    block57: {
                                                        block56: {
                                                            block54: {
                                                                isDiamond = this.type != null && (this.type.bits & 0x80000) != 0;
                                                                enclosingInstanceType = null;
                                                                receiverType = null;
                                                                sourceLevel = scope.compilerOptions().sourceLevel;
                                                                if (this.constant == Constant.NotAConstant) break block52;
                                                                this.constant = Constant.NotAConstant;
                                                                enclosingInstanceReference = null;
                                                                hasError = false;
                                                                enclosingInstanceContainsCast = false;
                                                                if (this.enclosingInstance == null) break block53;
                                                                if (this.enclosingInstance instanceof CastExpression) {
                                                                    this.enclosingInstance.bits |= 0x20;
                                                                    enclosingInstanceContainsCast = true;
                                                                }
                                                                if ((enclosingInstanceType = this.enclosingInstance.resolveType(scope)) != null) break block54;
                                                                hasError = true;
                                                                break block55;
                                                            }
                                                            if (!enclosingInstanceType.isBaseType() && !enclosingInstanceType.isArrayType()) break block56;
                                                            scope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(enclosingInstanceType, this.enclosingInstance);
                                                            hasError = true;
                                                            break block55;
                                                        }
                                                        if (!(this.type instanceof QualifiedTypeReference)) break block57;
                                                        scope.problemReporter().illegalUsageOfQualifiedTypeReference((QualifiedTypeReference)this.type);
                                                        hasError = true;
                                                        break block55;
                                                    }
                                                    enclosingInstanceReference = (ReferenceBinding)enclosingInstanceType;
                                                    if (enclosingInstanceReference.canBeSeenBy(scope)) break block58;
                                                    enclosingInstanceType = new ProblemReferenceBinding(enclosingInstanceReference.compoundName, enclosingInstanceReference, 2);
                                                    scope.problemReporter().invalidType(this.enclosingInstance, enclosingInstanceType);
                                                    hasError = true;
                                                    break block55;
                                                }
                                                this.resolvedType = receiverType = ((SingleTypeReference)this.type).resolveTypeEnclosing(scope, (ReferenceBinding)enclosingInstanceType);
                                                this.checkIllegalNullAnnotation(scope, receiverType);
                                                if (receiverType == null || !enclosingInstanceContainsCast) break block55;
                                                CastExpression.checkNeedForEnclosingInstanceCast(scope, this.enclosingInstance, enclosingInstanceType, receiverType);
                                                break block55;
                                            }
                                            if (this.type != null) break block59;
                                            receiverType = scope.enclosingSourceType();
                                            break block55;
                                        }
                                        receiverType = this.type.resolveType(scope, true);
                                        this.checkIllegalNullAnnotation(scope, receiverType);
                                        if (receiverType == null || !receiverType.isValidBinding() || !(this.type instanceof ParameterizedQualifiedTypeReference)) break block55;
                                        currentType = (ReferenceBinding)receiverType;
                                        break block60;
                                    }
                                    if (this.enclosingInstance != null) {
                                        enclosingInstanceType = this.enclosingInstance.resolvedType;
                                        this.resolvedType = receiverType = this.type.resolvedType;
                                    }
                                    break block61;
                                }
                                block0: while ((currentType.modifiers & 8) == 0 && !currentType.isRawType()) {
                                    if ((currentType = currentType.enclosingType()) != null) continue;
                                    ParameterizedQualifiedTypeReference qRef = (ParameterizedQualifiedTypeReference)this.type;
                                    for (int i2 = qRef.typeArguments.length - 2; i2 >= 0; --i2) {
                                        if (qRef.typeArguments[i2] == null) continue;
                                        scope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, receiverType);
                                        break block0;
                                    }
                                }
                            }
                            if (receiverType == null || !receiverType.isValidBinding()) {
                                hasError = true;
                            }
                            if (this.typeArguments != null) {
                                int i3;
                                int length = this.typeArguments.length;
                                this.argumentsHaveErrors = sourceLevel < 0x310000L;
                                this.genericTypeArguments = new TypeBinding[length];
                                for (i3 = 0; i3 < length; ++i3) {
                                    TypeReference typeReference = this.typeArguments[i3];
                                    this.genericTypeArguments[i3] = typeReference.resolveType(scope, true);
                                    if (this.genericTypeArguments[i3] == null) {
                                        this.argumentsHaveErrors = true;
                                    }
                                    if (!this.argumentsHaveErrors || !(typeReference instanceof Wildcard)) continue;
                                    scope.problemReporter().illegalUsageOfWildcard(typeReference);
                                }
                                if (isDiamond) {
                                    scope.problemReporter().diamondNotWithExplicitTypeArguments(this.typeArguments);
                                    return null;
                                }
                                if (this.argumentsHaveErrors) {
                                    if (this.arguments != null) {
                                        int max = this.arguments.length;
                                        for (i3 = 0; i3 < max; ++i3) {
                                            this.arguments[i3].resolveType(scope);
                                        }
                                    }
                                    return null;
                                }
                            }
                            this.argumentTypes = Binding.NO_PARAMETERS;
                            if (this.arguments != null) {
                                int length = this.arguments.length;
                                this.argumentTypes = new TypeBinding[length];
                                for (int i4 = 0; i4 < length; ++i4) {
                                    Expression argument = this.arguments[i4];
                                    if (argument instanceof CastExpression) {
                                        argument.bits |= 0x20;
                                        this.argsContainCast = true;
                                    }
                                    argument.setExpressionContext(ExpressionContext.INVOCATION_CONTEXT);
                                    this.argumentTypes[i4] = argument.resolveType(scope);
                                    if (this.argumentTypes[i4] != null) continue;
                                    hasError = true;
                                    this.argumentsHaveErrors = true;
                                }
                            }
                            if (!hasError) break block62;
                            if (isDiamond) {
                                return null;
                            }
                            if (!(receiverType instanceof ReferenceBinding)) break block63;
                            referenceReceiver = (ReferenceBinding)receiverType;
                            if (!receiverType.isValidBinding()) break block64;
                            int length = this.arguments == null ? 0 : this.arguments.length;
                            pseudoArgs = new TypeBinding[length];
                            i = length;
                            break block65;
                        }
                        if (this.anonymousType == null) {
                            if (!receiverType.canBeInstantiated()) {
                                scope.problemReporter().cannotInstantiate(this.type, receiverType);
                                this.resolvedType = receiverType;
                                return this.resolvedType;
                            }
                        } else {
                            if (isDiamond) {
                                scope.problemReporter().diamondNotWithAnoymousClasses(this.type);
                                return null;
                            }
                            ReferenceBinding superType = (ReferenceBinding)receiverType;
                            if (superType.isTypeVariable()) {
                                superType = new ProblemReferenceBinding(new char[][]{superType.sourceName()}, superType, 9);
                                scope.problemReporter().invalidType(this, superType);
                                return null;
                            }
                            if (this.type != null && superType.isEnum()) {
                                scope.problemReporter().cannotInstantiate(this.type, superType);
                                this.resolvedType = superType;
                                return this.resolvedType;
                            }
                            ReferenceBinding anonymousSuperclass = superType.isInterface() ? scope.getJavaLangObject() : superType;
                            scope.addAnonymousType(this.anonymousType, superType);
                            this.anonymousType.resolve(scope);
                            this.resolvedType = this.anonymousType.binding;
                            if ((this.resolvedType.tagBits & 0x20000L) != 0L) {
                                return null;
                            }
                            MethodBinding inheritedBinding = this.findConstructorBinding(scope, this, anonymousSuperclass, this.argumentTypes);
                            if (!inheritedBinding.isValidBinding()) {
                                if (inheritedBinding.declaringClass == null) {
                                    inheritedBinding.declaringClass = anonymousSuperclass;
                                }
                                if (this.type != null && !this.type.resolvedType.isValidBinding()) {
                                    return null;
                                }
                                scope.problemReporter().invalidConstructor(this, inheritedBinding);
                                return this.resolvedType;
                            }
                            if ((inheritedBinding.tagBits & 0x80L) != 0L) {
                                scope.problemReporter().missingTypeInConstructor(this, inheritedBinding);
                            }
                            if (this.enclosingInstance != null) {
                                ReferenceBinding targetEnclosing = inheritedBinding.declaringClass.enclosingType();
                                if (targetEnclosing == null) {
                                    scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.enclosingInstance, superType);
                                    return this.resolvedType;
                                }
                                if (!enclosingInstanceType.isCompatibleWith(targetEnclosing) && !scope.isBoxingCompatibleWith(enclosingInstanceType, targetEnclosing)) {
                                    scope.problemReporter().typeMismatchError(enclosingInstanceType, targetEnclosing, this.enclosingInstance, null);
                                    return this.resolvedType;
                                }
                                this.enclosingInstance.computeConversion(scope, targetEnclosing, enclosingInstanceType);
                            }
                            if (this.arguments != null && QualifiedAllocationExpression.checkInvocationArguments(scope, null, anonymousSuperclass, inheritedBinding, this.arguments, this.argumentTypes, this.argsContainCast, this)) {
                                this.bits |= 0x10000;
                            }
                            if (this.typeArguments != null && inheritedBinding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
                                scope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(inheritedBinding, this.genericTypeArguments, this.typeArguments);
                            }
                            this.binding = this.anonymousType.createDefaultConstructorWithBinding(inheritedBinding, (this.bits & 0x10000) != 0 && this.genericTypeArguments == null);
                            return this.resolvedType;
                        }
                    }
                    if (isDiamond) {
                        this.binding = this.inferConstructorOfElidedParameterizedType(scope);
                        if (this.binding == null || !this.binding.isValidBinding()) {
                            scope.problemReporter().cannotInferElidedTypes(this);
                            this.resolvedType = null;
                            return null;
                        }
                        if (this.typeExpected == null && sourceLevel >= 0x340000L && this.expressionContext.definesTargetType()) {
                            return new PolyTypeBinding(this);
                        }
                        this.type.resolvedType = receiverType = this.binding.declaringClass;
                        this.resolvedType = receiverType;
                        QualifiedAllocationExpression.resolvePolyExpressionArguments(this, this.binding, this.argumentTypes, scope);
                    } else {
                        this.binding = this.findConstructorBinding(scope, this, (ReferenceBinding)receiverType, this.argumentTypes);
                    }
                    if (this.binding.isValidBinding()) {
                        if (this.isMethodUseDeprecated(this.binding, scope, true)) {
                            scope.problemReporter().deprecatedMethod(this.binding, this);
                        }
                        if (QualifiedAllocationExpression.checkInvocationArguments(scope, null, receiverType, this.binding, this.arguments, this.argumentTypes, this.argsContainCast, this)) {
                            this.bits |= 0x10000;
                        }
                        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
                            scope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
                        }
                    } else {
                        if (this.binding.declaringClass == null) {
                            this.binding.declaringClass = (ReferenceBinding)receiverType;
                        }
                        if (this.type != null && !this.type.resolvedType.isValidBinding()) {
                            return null;
                        }
                        scope.problemReporter().invalidConstructor(this, this.binding);
                        this.resolvedType = receiverType;
                        return this.resolvedType;
                    }
                    if ((this.binding.tagBits & 0x80L) != 0L) {
                        scope.problemReporter().missingTypeInConstructor(this, this.binding);
                    }
                    if (!isDiamond && receiverType.isParameterizedTypeWithActualArguments()) {
                        this.checkTypeArgumentRedundancy((ParameterizedTypeBinding)receiverType, scope);
                    }
                    if (TypeBinding.notEquals(expectedType = this.binding.declaringClass.enclosingType(), enclosingInstanceType)) {
                        scope.compilationUnitScope().recordTypeConversion(expectedType, enclosingInstanceType);
                    }
                    if (!enclosingInstanceType.isCompatibleWith(expectedType) && !scope.isBoxingCompatibleWith(enclosingInstanceType, expectedType)) {
                        scope.problemReporter().typeMismatchError(enclosingInstanceType, expectedType, this.enclosingInstance, null);
                        this.resolvedType = receiverType;
                        return this.resolvedType;
                    }
                    this.enclosingInstance.computeConversion(scope, expectedType, enclosingInstanceType);
                    this.resolvedType = receiverType;
                    return this.resolvedType;
                }
                while (--i >= 0) {
                    pseudoArgs[i] = this.argumentTypes[i] == null ? TypeBinding.NULL : this.argumentTypes[i];
                }
                this.binding = scope.findMethod(referenceReceiver, TypeConstants.INIT, pseudoArgs, this, false);
                if (this.binding != null && !this.binding.isValidBinding() && (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                    if (closestMatch.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                        closestMatch = scope.environment().createParameterizedGenericMethod(closestMatch.original(), (RawTypeBinding)null);
                    }
                    this.binding = closestMatch;
                    MethodBinding closestMatchOriginal = closestMatch.original();
                    if (closestMatchOriginal.isOrEnclosedByPrivateType() && !scope.isDefinedInMethod(closestMatchOriginal)) {
                        closestMatchOriginal.modifiers |= 0x8000000;
                    }
                }
            }
            if (this.anonymousType != null) {
                scope.addAnonymousType(this.anonymousType, referenceReceiver);
                this.anonymousType.resolve(scope);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
        }
        this.resolvedType = receiverType;
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(visitor, scope);
            }
            if (this.typeArguments != null) {
                int typeArgumentsLength = this.typeArguments.length;
                for (int i = 0; i < typeArgumentsLength; ++i) {
                    this.typeArguments[i].traverse(visitor, scope);
                }
            }
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                for (int i = 0; i < argumentsLength; ++i) {
                    this.arguments[i].traverse(visitor, scope);
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

