/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;

public class SecurityRoleMetaDataParser
extends MetaDataElementParser {
    public static SecurityRoleMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return SecurityRoleMetaDataParser.parse(reader, PropertyReplacers.noop());
    }

    public static SecurityRoleMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        SecurityRoleMetaData securityRole = new SecurityRoleMetaData();
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (SecurityRoleMetaDataParser.attributeHasNamespace(reader, i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    securityRole.setId(value);
                    continue block7;
                }
                default: {
                    throw SecurityRoleMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions, propertyReplacer)) {
                if (securityRole.getDescriptions() != null) continue;
                securityRole.setDescriptions(descriptions);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ROLE_NAME: {
                    securityRole.setRoleName(SecurityRoleMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block8;
                }
                case PRINCIPAL_NAME: {
                    Set<String> principalNames = securityRole.getPrincipals();
                    if (principalNames == null) {
                        principalNames = new HashSet<String>();
                        securityRole.setPrincipals(principalNames);
                    }
                    principalNames.add(SecurityRoleMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block8;
                }
            }
            throw SecurityRoleMetaDataParser.unexpectedElement(reader);
        }
        return securityRole;
    }
}

