/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.handler.Handler;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerAddHandler;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterAddHandler;
import org.wildfly.extension.picketlink.federation.service.EntityProviderService;

public abstract class AbstractEntityProviderAddHandler
extends AbstractAddStepHandler {
    protected static void configureHandler(OperationContext context, ModelNode model, EntityProviderService service) throws OperationFailedException {
        if (model.hasDefined(ModelElement.COMMON_HANDLER.getName())) {
            for (Property handlerProperty : model.get(ModelElement.COMMON_HANDLER.getName()).asPropertyList()) {
                ModelNode handler = handlerProperty.getValue();
                Handler newHandler = HandlerAddHandler.toHandlerConfig(context, handler);
                if (handler.hasDefined(ModelElement.COMMON_HANDLER_PARAMETER.getName())) {
                    for (Property handlerParameter : handler.get(ModelElement.COMMON_HANDLER_PARAMETER.getName()).asPropertyList()) {
                        String paramName = handlerParameter.getName();
                        ModelNode parameterNode = handlerParameter.getValue();
                        KeyValueType kv = HandlerParameterAddHandler.toHandlerParameterConfig(context, paramName, parameterNode);
                        newHandler.add(kv);
                    }
                }
                service.addHandler(newHandler);
            }
        }
    }
}

