/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.jctools.maps.NonBlockingHashSet;

public class AddressImpl
implements Address {
    private static final WildcardConfiguration DEFAULT_WILDCARD_CONFIGURATION = new WildcardConfiguration();
    private final SimpleString address;
    private final SimpleString[] addressParts;
    private final boolean containsWildCard;
    private Set<Address> linkedAddresses = null;
    private final WildcardConfiguration wildcardConfiguration;

    public AddressImpl(SimpleString address) {
        this(address, DEFAULT_WILDCARD_CONFIGURATION);
    }

    public AddressImpl(SimpleString address, WildcardConfiguration wildcardConfiguration) {
        this.address = address;
        this.wildcardConfiguration = wildcardConfiguration;
        this.addressParts = address.split(wildcardConfiguration.getDelimiter());
        this.containsWildCard = address.containsEitherOf(wildcardConfiguration.getSingleWord(), wildcardConfiguration.getAnyWords());
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public SimpleString[] getAddressParts() {
        return this.addressParts;
    }

    @Override
    public boolean containsWildCard() {
        return this.containsWildCard;
    }

    @Override
    public Collection<Address> getLinkedAddresses() {
        Set<Address> linkedAddresses = this.linkedAddresses;
        if (linkedAddresses == null) {
            return Collections.emptySet();
        }
        return linkedAddresses;
    }

    @Override
    public void addLinkedAddress(Address address) {
        if (this.linkedAddresses == null) {
            this.linkedAddresses = PlatformDependent.hasUnsafe() ? new NonBlockingHashSet() : new ConcurrentHashSet();
        }
        this.linkedAddresses.add(address);
    }

    @Override
    public void removeLinkedAddress(Address actualAddress) {
        if (this.linkedAddresses == null) {
            return;
        }
        this.linkedAddresses.remove(actualAddress);
    }

    @Override
    public boolean matches(Address otherAddr) {
        if (otherAddr == null) {
            return false;
        }
        if (this.address.equals((Object)otherAddr.getAddress())) {
            return true;
        }
        char sepAnyWords = this.wildcardConfiguration.getAnyWords();
        char sepSingleWord = this.wildcardConfiguration.getSingleWord();
        int thisAddrPartsLen = this.addressParts.length;
        int thisAddrPartsLastIdx = thisAddrPartsLen - 1;
        SimpleString[] otherAddrParts = otherAddr.getAddressParts();
        int otherAddrPartsLen = otherAddrParts.length;
        int otherAddrPartsLastIdx = otherAddrPartsLen - 1;
        int thisIdx = 0;
        int otherIdx = 0;
        while (otherIdx < otherAddrPartsLen) {
            boolean otherCurrPartIsSingleChar;
            if (thisIdx > thisAddrPartsLastIdx) {
                if (otherIdx == otherAddrPartsLastIdx) {
                    SimpleString otherAddrLastPart = otherAddrParts[otherAddrPartsLastIdx];
                    return otherAddrLastPart.length() > 0 && otherAddrLastPart.charAt(0) == sepAnyWords;
                }
                return false;
            }
            SimpleString thisCurr = this.addressParts[thisIdx];
            SimpleString otherCurr = otherAddrParts[otherIdx];
            boolean bl = otherCurrPartIsSingleChar = otherCurr.length() == 1;
            if (otherCurrPartIsSingleChar && otherCurr.charAt(0) == sepSingleWord) {
                ++thisIdx;
                ++otherIdx;
                continue;
            }
            if (otherCurrPartIsSingleChar && otherCurr.charAt(0) == sepAnyWords) {
                if (otherIdx == otherAddrPartsLastIdx) {
                    return true;
                }
                SimpleString thisNext = thisIdx < thisAddrPartsLastIdx ? this.addressParts[thisIdx + 1] : thisCurr;
                SimpleString otherNext = otherAddrParts[otherIdx + 1];
                while (thisCurr != null && !thisCurr.equals((Object)otherNext)) {
                    thisCurr = thisNext;
                    thisNext = thisAddrPartsLastIdx > ++thisIdx ? this.addressParts[thisIdx + 1] : null;
                }
                if (thisCurr == null) {
                    return false;
                }
                ++otherIdx;
                continue;
            }
            if (!thisCurr.equals((Object)otherCurr)) {
                return false;
            }
            ++thisIdx;
            ++otherIdx;
        }
        return thisIdx == thisAddrPartsLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.address.equals((Object)((AddressImpl)o).address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

