/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.engine.impl.AbstractHSQuery;
import org.hibernate.search.query.engine.impl.QueryFilters;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetCombine;
import org.hibernate.search.query.facet.FacetSelection;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.util.impl.CollectionHelper;

public class FacetManagerImpl
implements FacetManager {
    private Map<String, FacetingRequest> facetRequests;
    private Map<String, FacetSelectionImpl> facetSelection;
    private Map<String, List<Facet>> facetResults;
    private QueryFilters facetFilterset;
    private final AbstractHSQuery query;

    public FacetManagerImpl(AbstractHSQuery query) {
        this.query = query;
    }

    @Override
    public FacetManager enableFaceting(FacetingRequest facetingRequest) {
        if (this.facetRequests == null) {
            this.facetRequests = CollectionHelper.newHashMap();
        }
        this.facetRequests.put(facetingRequest.getFacetingName(), (FacetingRequestImpl)facetingRequest);
        this.queryHasChanged();
        return this;
    }

    @Override
    public void disableFaceting(String facetingName) {
        if (this.facetRequests != null) {
            this.facetRequests.remove(facetingName);
        }
        if (this.facetResults != null) {
            this.facetResults.remove(facetingName);
        }
        this.queryHasChanged();
    }

    @Override
    public List<Facet> getFacets(String facetingName) {
        if (this.facetRequests == null || this.facetRequests.isEmpty() || !this.facetRequests.containsKey(facetingName)) {
            return Collections.emptyList();
        }
        List<Facet> facets = null;
        if (this.facetResults != null) {
            facets = this.facetResults.get(facetingName);
        }
        if (facets != null) {
            return facets;
        }
        this.query.extractFacetResults();
        if (this.facetResults == null) {
            return Collections.emptyList();
        }
        List<Facet> results = this.facetResults.get(facetingName);
        if (results != null) {
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    public FacetSelection getFacetGroup(String groupName) {
        FacetSelectionImpl selection;
        if (groupName == null) {
            throw new IllegalArgumentException("null is not a valid facet selection group name");
        }
        if (this.facetSelection == null) {
            this.facetSelection = CollectionHelper.newHashMap();
        }
        if ((selection = this.facetSelection.get(groupName)) == null) {
            selection = new FacetSelectionImpl();
            this.facetSelection.put(groupName, selection);
        }
        return selection;
    }

    public Map<String, FacetingRequest> getFacetRequests() {
        return this.facetRequests != null ? this.facetRequests : Collections.emptyMap();
    }

    public void setFacetResults(Map<String, List<Facet>> facetResults) {
        this.facetResults = facetResults;
    }

    void queryHasChanged() {
        this.facetFilterset = null;
        this.facetResults = null;
        this.query.clearCachedResults();
    }

    public QueryFilters getFacetFilters() {
        if (this.facetFilterset == null) {
            int size;
            int n = size = this.facetSelection == null ? 0 : this.facetSelection.values().size();
            if (size != 0) {
                ArrayList<Query> filterQueries = new ArrayList<Query>(size);
                for (FacetSelectionImpl selection : this.facetSelection.values()) {
                    if (selection.getFacetList().isEmpty()) continue;
                    Query selectionGroupQuery = this.createSelectionGroupQuery(selection);
                    filterQueries.add(selectionGroupQuery);
                }
                this.facetFilterset = filterQueries.size() != 0 ? new QueryFilters(filterQueries) : QueryFilters.EMPTY_FILTERSET;
            } else {
                this.facetFilterset = QueryFilters.EMPTY_FILTERSET;
            }
        }
        return this.facetFilterset;
    }

    private Query createSelectionGroupQuery(FacetSelectionImpl selection) {
        BooleanQuery.Builder boolQueryBuilder = new BooleanQuery.Builder();
        for (Facet facet : selection.getFacetList()) {
            boolQueryBuilder.add(facet.getFacetQuery(), selection.getOccurType());
        }
        return boolQueryBuilder.build();
    }

    class FacetSelectionImpl
    implements FacetSelection {
        private final List<Facet> facetList = CollectionHelper.newArrayList();
        private BooleanClause.Occur occurType = BooleanClause.Occur.SHOULD;

        FacetSelectionImpl() {
        }

        public List<Facet> getFacetList() {
            return this.facetList;
        }

        @Override
        public void selectFacets(Facet ... facets) {
            this.selectFacets(FacetCombine.OR, facets);
        }

        @Override
        public void selectFacets(FacetCombine combineBy, Facet ... facets) {
            if (facets == null) {
                return;
            }
            this.occurType = FacetCombine.OR.equals((Object)combineBy) ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
            this.facetList.addAll(Arrays.asList(facets));
            FacetManagerImpl.this.queryHasChanged();
        }

        @Override
        public List<Facet> getSelectedFacets() {
            return Collections.unmodifiableList(this.facetList);
        }

        @Override
        public void deselectFacets(Facet ... facets) {
            boolean hasChanged = this.facetList.removeAll(Arrays.asList(facets));
            if (hasChanged) {
                FacetManagerImpl.this.queryHasChanged();
            }
        }

        @Override
        public void clearSelectedFacets() {
            this.facetList.clear();
            FacetManagerImpl.this.queryHasChanged();
        }

        @Override
        public BooleanClause.Occur getOccurType() {
            return this.occurType;
        }
    }
}

