/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging.engines;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.util.TransportTimer;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.BusinessActivityConstants;
import com.arjuna.webservices11.wsba.ParticipantCompletionParticipantInboundEvents;
import com.arjuna.webservices11.wsba.State;
import com.arjuna.webservices11.wsba.client.ParticipantCompletionCoordinatorClient;
import com.arjuna.webservices11.wsba.processors.ParticipantCompletionParticipantProcessor;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst11.ConfirmCompletedParticipant;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManager;
import org.jboss.jbossts.xts11.recovery.participant.ba.BAParticipantRecoveryRecord;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsba._2006._06.NotificationType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.StatusType;

public class ParticipantCompletionParticipantEngine
implements ParticipantCompletionParticipantInboundEvents {
    private final String id;
    private final InstanceIdentifier instanceIdentifier;
    private final W3CEndpointReference coordinator;
    private final BusinessAgreementWithParticipantCompletionParticipant participant;
    private State state;
    private TimerTask timerTask;
    private long resendPeriod;
    private long initialResendPeriod;
    private long maxResendPeriod;
    private long timeout;
    private boolean recovered;
    private boolean persisted;
    private boolean checkStatus;

    public ParticipantCompletionParticipantEngine(String id, W3CEndpointReference coordinator, BusinessAgreementWithParticipantCompletionParticipant participant) {
        this(id, coordinator, participant, State.STATE_ACTIVE, false);
    }

    public ParticipantCompletionParticipantEngine(String id, W3CEndpointReference coordinator, BusinessAgreementWithParticipantCompletionParticipant participant, State state, boolean recovered) {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + " constructor. Id: " + id + ", coordinator" + coordinator + ", participant: " + participant + " state: " + state + ", recovered: " + recovered));
        }
        this.id = id;
        this.instanceIdentifier = new InstanceIdentifier(id);
        this.coordinator = coordinator;
        this.participant = participant;
        this.state = state;
        this.recovered = recovered;
        this.persisted = recovered;
        this.initialResendPeriod = TransportTimer.getTransportPeriod();
        this.maxResendPeriod = TransportTimer.getMaximumTransportPeriod();
        this.timeout = TransportTimer.getTransportTimeout();
        this.resendPeriod = this.initialResendPeriod;
        this.checkStatus = recovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(NotificationType cancel, MAP map, ArjunaContext arjunaContext) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".cancel"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_CANCELING);
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".cancel. State: " + current));
        }
        if (current == State.STATE_ACTIVE) {
            this.executeCancel();
        } else if (current == State.STATE_COMPLETED) {
            this.sendCompleted();
        } else if (current == State.STATE_FAILING_ACTIVE || current == State.STATE_FAILING_CANCELING) {
            this.sendFail(current.getValue());
        } else if (current == State.STATE_NOT_COMPLETING) {
            this.sendCannotComplete();
        } else if (current == State.STATE_EXITING) {
            this.sendExit();
        } else if (current == State.STATE_ENDED) {
            this.sendCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(NotificationType close, MAP map, ArjunaContext arjunaContext) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".close"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_COMPLETED) {
                this.changeState(State.STATE_CLOSING);
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".close. State: " + current));
        }
        if (current == State.STATE_COMPLETED) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            this.executeClose();
        } else if (current == State.STATE_ENDED) {
            this.sendClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compensate(NotificationType compensate, MAP map, ArjunaContext arjunaContext) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".compensate"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_COMPLETED) {
                this.changeState(State.STATE_COMPENSATING);
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".compensate. State: " + current));
        }
        if (current == State.STATE_COMPLETED) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            this.executeCompensate();
        } else if (current == State.STATE_FAILING_COMPENSATING) {
            this.sendFail(current.getValue());
        } else if (current == State.STATE_ENDED) {
            this.sendCompensated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exited(NotificationType exited, MAP map, ArjunaContext arjunaContext) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".exited"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_EXITING) {
                this.ended();
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".exited. State: " + current));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(NotificationType failed, MAP map, ArjunaContext arjunaContext) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".failed"));
        }
        boolean deleteRequired = false;
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_FAILING_ACTIVE || current == State.STATE_FAILING_CANCELING || current == State.STATE_FAILING_COMPENSATING) {
                deleteRequired = this.persisted;
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".failed. State: " + current));
        }
        if (deleteRequired && !XTSBARecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
            WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantCompletionParticipantEngine_failed_1(this.id);
        }
        if (current == State.STATE_FAILING_ACTIVE || current == State.STATE_FAILING_CANCELING || current == State.STATE_FAILING_COMPENSATING) {
            this.ended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notCompleted(NotificationType notCompleted, MAP map, ArjunaContext arjunaContext) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".notCompleted"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_NOT_COMPLETING) {
                this.ended();
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".notCompleted. State: " + current));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStatus(NotificationType getStatus, MAP map, ArjunaContext arjunaContext) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".getStatus"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".getStatus. State: " + current));
        }
        this.sendStatus(current);
    }

    @Override
    public void status(StatusType status, MAP map, ArjunaContext arjunaContext) {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".status"));
        }
        this.checkStatus = false;
        this.updateResendPeriod(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recovery() {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".recovery"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".recovery. State: " + current));
        }
        if (current == State.STATE_COMPLETED) {
            this.sendCompleted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
        boolean checkingStatus;
        boolean deleteRequired;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".soapFault"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            deleteRequired = this.persisted;
            this.persisted = false;
            checkingStatus = this.state == State.STATE_COMPLETED && this.checkStatus;
            this.ended();
        }
        try {
            boolean isInvalidState = soapFault.getSubcode().equals(CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME);
            if (checkingStatus && isInvalidState) {
                WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantCompletionParticipantEngine_soapFault_2(this.id);
                this.participant.compensate();
            } else {
                WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantCompletionParticipantEngine_soapFault_3(this.id);
                this.participant.error();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (deleteRequired && !XTSBARecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
            WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantCompletionParticipantEngine_soapFault_1(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State completed() {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".completed"));
        }
        boolean failRequired = false;
        boolean deleteRequired = false;
        boolean confirm = this.participant instanceof ConfirmCompletedParticipant;
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                BAParticipantRecoveryRecord recoveryRecord = new BAParticipantRecoveryRecord(this.id, this.participant, true, this.coordinator);
                if (XTSBARecoveryManager.getRecoveryManager().writeParticipantRecoveryRecord(recoveryRecord)) {
                    this.changeState(State.STATE_COMPLETED);
                    this.persisted = true;
                    if (confirm) {
                        ((ConfirmCompletedParticipant)((Object)this.participant)).confirmCompleted(true);
                    }
                } else {
                    WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantCompletionParticipantEngine_completed_1(this.id);
                    failRequired = true;
                }
            }
        }
        if (failRequired) {
            current = this.fail(BusinessActivityConstants.WSBA_ELEMENT_FAIL_QNAME);
            if (confirm) {
                ((ConfirmCompletedParticipant)((Object)this.participant)).confirmCompleted(false);
            }
        } else if (current == State.STATE_ACTIVE || current == State.STATE_COMPLETED) {
            this.sendCompleted();
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".completed. State: " + current));
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State exit() {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".completed"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_EXITING);
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".completed. State: " + current));
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_EXITING) {
            this.sendExit();
        }
        return this.waitForState(State.STATE_EXITING, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State fail(QName exceptionIdentifier) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".fail"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_FAILING_ACTIVE);
            } else if (current == State.STATE_CANCELING) {
                this.changeState(State.STATE_FAILING_CANCELING);
            } else if (current == State.STATE_COMPENSATING) {
                this.changeState(State.STATE_FAILING_COMPENSATING);
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".fail. State: " + current));
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_FAILING_ACTIVE) {
            this.sendFail(exceptionIdentifier);
            return this.waitForState(State.STATE_FAILING_ACTIVE, this.timeout);
        }
        if (current == State.STATE_CANCELING || current == State.STATE_FAILING_CANCELING) {
            this.sendFail(exceptionIdentifier);
            return this.waitForState(State.STATE_FAILING_CANCELING, this.timeout);
        }
        if (current == State.STATE_COMPENSATING || current == State.STATE_FAILING_COMPENSATING) {
            this.sendFail(exceptionIdentifier);
            return this.waitForState(State.STATE_FAILING_COMPENSATING, this.timeout);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State cannotComplete() {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".cannotComplete"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_NOT_COMPLETING);
            }
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".cannotComplete. State: " + current));
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_NOT_COMPLETING) {
            this.sendCannotComplete();
            return this.waitForState(State.STATE_NOT_COMPLETING, this.timeout);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commsTimeout(TimerTask caller) {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".commsTimeout"));
        }
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            if (!this.timerTask.equals(caller)) {
                return;
            }
            current = this.state;
        }
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".commsTimeout. State: " + current));
        }
        if (current == State.STATE_COMPLETED) {
            this.sendCompleted(true);
        }
    }

    private void sendExit() {
        block3: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendExit. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendExit(this.coordinator, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception while sending Exit", (Object)th);
            }
        }
    }

    private void sendCompleted() {
        this.sendCompleted(false);
    }

    private void sendCompleted(boolean timedOut) {
        block5: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCompleted. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                if (timedOut && this.checkStatus) {
                    ParticipantCompletionCoordinatorClient.getClient().sendGetStatus(this.coordinator, map, this.instanceIdentifier);
                } else {
                    ParticipantCompletionCoordinatorClient.getClient().sendCompleted(this.coordinator, map, this.instanceIdentifier);
                }
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block5;
                WSTLogger.logger.tracev("Unexpected exception while sending Completed", (Object)th);
            }
        }
        this.updateResendPeriod(timedOut);
        this.initiateTimer();
    }

    private synchronized void updateResendPeriod(boolean timedOut) {
        if (timedOut) {
            if (this.resendPeriod < this.maxResendPeriod) {
                long newPeriod = this.resendPeriod * 14L / 10L;
                if (newPeriod > this.maxResendPeriod) {
                    newPeriod = this.maxResendPeriod;
                }
                this.resendPeriod = newPeriod;
            } else {
                this.checkStatus = true;
            }
        } else {
            if (this.resendPeriod > this.initialResendPeriod) {
                this.resendPeriod = this.initialResendPeriod;
            }
            if (this.checkStatus) {
                this.checkStatus = false;
            }
        }
    }

    private void sendFail(QName message) {
        block3: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendFail. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendFail(this.coordinator, map, this.instanceIdentifier, message);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception while sending Fault", (Object)th);
            }
        }
    }

    private void sendCancelled() {
        block3: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCancelled. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendCancelled(this.coordinator, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception while sending Cancelled", (Object)th);
            }
        }
    }

    private void sendClosed() {
        block3: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendClosed. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendClosed(this.coordinator, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception while sending Closed", (Object)th);
            }
        }
    }

    private void sendCompensated() {
        block3: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCompensated. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendCompensated(this.coordinator, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception while sending Compensated", (Object)th);
            }
        }
    }

    private void sendStatus(State state) {
        block3: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendStatus. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendStatus(this.coordinator, map, this.instanceIdentifier, state.getValue());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception while sending Status", (Object)th);
            }
        }
    }

    private void sendCannotComplete() {
        block3: {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".sendCannotComplete. Coordinator: " + this.coordinator + ", instance identifier: " + this.instanceIdentifier));
            }
            MAP map = this.createContext();
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendCannotComplete(this.coordinator, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block3;
                WSTLogger.logger.tracev("Unexpected exception while sending Status", (Object)th);
            }
        }
    }

    public String getId() {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".getId. Id: " + this.id));
        }
        return this.id;
    }

    public W3CEndpointReference getCoordinator() {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".getCoordinator. Coordinator: " + this.coordinator));
        }
        return this.coordinator;
    }

    public BusinessAgreementWithParticipantCompletionParticipant getParticipant() {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".getParticipant. Participant: " + this.participant));
        }
        return this.participant;
    }

    public boolean isRecovered() {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".isRecovered. Recovered: " + this.recovered));
        }
        return this.recovered;
    }

    private synchronized void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private State waitForState(State origState, long delay) {
        long end = System.currentTimeMillis() + delay;
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            long remaining;
            while (this.state == origState && (remaining = end - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(remaining);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCancel() {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".executeCancel. Participant: " + this.participant));
        }
        try {
            this.participant.cancel();
        }
        catch (FaultedException fe) {
            WSTLogger.i18NLogger.warn_messaging_engines_ParticipantCompletionParticipantEngine_executeCancel_1(fe);
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev((Throwable)fe, "Faulted exception from participant cancel for WS-BA participant", new Object[0]);
            }
            this.fail(BusinessActivityConstants.WSBA_ELEMENT_FAIL_QNAME);
            return;
        }
        catch (Throwable th) {
            WSTLogger.i18NLogger.warn_messaging_engines_ParticipantCompletionParticipantEngine_executeCancel_2(th);
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev(th, "Unexpected exception from participant cancel for WS-BA participant", new Object[0]);
            }
            ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
            synchronized (participantCompletionParticipantEngine) {
                if (this.state == State.STATE_CANCELING) {
                    this.changeState(State.STATE_ACTIVE);
                }
            }
            return;
        }
        this.sendCancelled();
        this.ended();
    }

    private void executeClose() {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".executeClose. Participant: " + this.participant));
        }
        try {
            this.participant.close();
        }
        catch (Throwable th) {
            WSTLogger.i18NLogger.warn_messaging_engines_ParticipantCompletionParticipantEngine_executeClose_1(th);
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev(th, "Unexpected exception from participant close for WS-BA participant", new Object[0]);
            }
            this.changeState(State.STATE_COMPLETED);
            this.initiateTimer();
            return;
        }
        if (this.persisted && !XTSBARecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
            WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantCompletionParticipantEngine_executeClose_2(this.id);
            this.changeState(State.STATE_COMPLETED);
            this.initiateTimer();
            return;
        }
        this.sendClosed();
        this.ended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCompensate() {
        State current;
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.trace((Object)(this.getClass().getSimpleName() + ".executeCompensate. Participant: " + this.participant));
        }
        try {
            this.participant.compensate();
        }
        catch (FaultedException fe) {
            WSTLogger.i18NLogger.warn_messaging_engines_ParticipantCompletionParticipantEngine_executeCompensate_1(fe);
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev((Throwable)fe, "Faulted exception from participant compensate for WS-BA participant", new Object[0]);
            }
            this.fail(BusinessActivityConstants.WSBA_ELEMENT_FAIL_QNAME);
            return;
        }
        catch (Throwable th) {
            State current2;
            ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
            synchronized (participantCompletionParticipantEngine) {
                current2 = this.state;
                if (current2 == State.STATE_COMPENSATING) {
                    this.changeState(State.STATE_COMPLETED);
                }
            }
            if (current2 == State.STATE_COMPENSATING) {
                this.initiateTimer();
            }
            WSTLogger.i18NLogger.warn_messaging_engines_ParticipantCompletionParticipantEngine_executeCompensate_2(th);
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev(th, "Unexpected exception from participant compensate for WS-BA participant", new Object[0]);
            }
            return;
        }
        boolean failRequired = false;
        ParticipantCompletionParticipantEngine participantCompletionParticipantEngine = this;
        synchronized (participantCompletionParticipantEngine) {
            current = this.state;
            if (current == State.STATE_COMPENSATING) {
                if (this.persisted && !XTSBARecoveryManager.getRecoveryManager().deleteParticipantRecoveryRecord(this.id)) {
                    WSTLogger.i18NLogger.warn_wst11_messaging_engines_ParticipantCompletionParticipantEngine_executeCompensate_3(this.id);
                    failRequired = true;
                    this.changeState(State.STATE_FAILING_COMPENSATING);
                }
                if (!failRequired) {
                    this.ended();
                }
            }
        }
        if (failRequired) {
            this.fail(BusinessActivityConstants.WSBA_ELEMENT_FAIL_QNAME);
        } else if (current == State.STATE_COMPENSATING) {
            this.sendCompensated();
        }
    }

    private void ended() {
        this.changeState(State.STATE_ENDED);
        ParticipantCompletionParticipantProcessor.getProcessor().deactivateParticipant(this);
    }

    private synchronized void initiateTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.state == State.STATE_COMPLETED) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    ParticipantCompletionParticipantEngine.this.commsTimeout(this);
                }
            };
            TransportTimer.getTimer().schedule(this.timerTask, this.resendPeriod);
        } else {
            this.timerTask = null;
        }
    }

    private MAP createContext() {
        String messageId = MessageId.getMessageId();
        return AddressingHelper.createNotificationContext(messageId);
    }
}

