/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import org.wildfly.common.Assert;
import org.wildfly.security.permission.AbstractNameSetOnlyPermission;
import org.wildfly.security.util.StringEnumeration;
import org.wildfly.security.util.StringMapping;

public final class BatchPermission
extends AbstractNameSetOnlyPermission<BatchPermission> {
    private static final long serialVersionUID = 6124294238228442419L;
    private static final StringEnumeration strings = StringEnumeration.of((String[])new String[]{"start", "stop", "restart", "abandon", "read"});
    private static final StringMapping<BatchPermission> mapping = new StringMapping(strings, BatchPermission::new);
    private static final BatchPermission allPermission = new BatchPermission("*");

    public BatchPermission(String name) {
        this(name, null);
    }

    public BatchPermission(String name, String actions) {
        super(name, strings);
        BatchPermission.requireEmptyActions((String)actions);
    }

    public BatchPermission withName(String name) {
        return BatchPermission.forName(name);
    }

    public static BatchPermission forName(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return "*".equals(name) ? allPermission : (BatchPermission)((Object)mapping.getItemByString(name));
    }
}

