/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.serializing;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayDeque;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;

public final class XMLExtendedStreamWriterImpl
implements XMLExtendedStreamWriter,
XMLStreamConstants {
    private static final String NO_NAMESPACE = new String();
    private final XMLStreamWriter delegate;
    private final ArrayDeque<ArgRunnable> attrQueue = new ArrayDeque();
    private int level;
    private int state = 7;
    private boolean indentEndElement = false;
    private ArrayDeque<String> unspecifiedNamespaces = new ArrayDeque();

    public XMLExtendedStreamWriterImpl(XMLStreamWriter delegate) {
        this.delegate = delegate;
        this.unspecifiedNamespaces.push(NO_NAMESPACE);
    }

    private void nl() throws XMLStreamException {
        this.delegate.writeCharacters("\n");
    }

    private void indent() throws XMLStreamException {
        int level = this.level;
        XMLStreamWriter delegate = this.delegate;
        for (int i = 0; i < level; ++i) {
            delegate.writeCharacters("    ");
        }
    }

    @Override
    public void setUnspecifiedElementNamespace(String namespace) {
        ArrayDeque<String> namespaces = this.unspecifiedNamespaces;
        namespaces.pop();
        namespaces.push(namespace == null ? NO_NAMESPACE : namespace);
    }

    private String nestUnspecifiedNamespace() {
        ArrayDeque<String> namespaces = this.unspecifiedNamespaces;
        String clone = namespaces.getFirst();
        namespaces.push(clone);
        return clone;
    }

    @Override
    public void writeStartElement(final String localName) throws XMLStreamException {
        ArrayDeque<String> namespaces = this.unspecifiedNamespaces;
        String namespace = namespaces.getFirst();
        if (namespace != NO_NAMESPACE) {
            this.writeStartElement(namespace, localName);
            return;
        }
        this.unspecifiedNamespaces.push(namespace);
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                if (arg == 0) {
                    XMLExtendedStreamWriterImpl.this.delegate.writeStartElement(localName);
                } else {
                    XMLExtendedStreamWriterImpl.this.delegate.writeEmptyElement(localName);
                }
            }
        });
        ++this.level;
        this.state = 1;
        this.indentEndElement = false;
    }

    @Override
    public void writeStartElement(final String namespaceURI, final String localName) throws XMLStreamException {
        this.nestUnspecifiedNamespace();
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                if (arg == 0) {
                    XMLExtendedStreamWriterImpl.this.delegate.writeStartElement(namespaceURI, localName);
                } else {
                    XMLExtendedStreamWriterImpl.this.delegate.writeEmptyElement(namespaceURI, localName);
                }
            }
        });
        ++this.level;
        this.state = 1;
        this.indentEndElement = false;
    }

    @Override
    public void writeStartElement(Enum<?> localNameEnum) throws XMLStreamException {
        this.writeStartElement(localNameEnum.toString());
    }

    @Override
    public void writeStartElement(final String prefix, final String localName, final String namespaceURI) throws XMLStreamException {
        this.nestUnspecifiedNamespace();
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                if (arg == 0) {
                    XMLExtendedStreamWriterImpl.this.delegate.writeStartElement(prefix, namespaceURI, localName);
                } else {
                    XMLExtendedStreamWriterImpl.this.delegate.writeEmptyElement(prefix, namespaceURI, localName);
                }
            }
        });
        ++this.level;
        this.state = 1;
        this.indentEndElement = false;
    }

    @Override
    public void writeEmptyElement(Enum<?> localNameEnum) throws XMLStreamException {
        this.writeEmptyElement(localNameEnum.toString());
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.delegate.writeEmptyElement(namespaceURI, localName);
        this.state = 2;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.delegate.writeEmptyElement(prefix, namespaceURI, localName);
        this.state = 2;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        String namespace = this.unspecifiedNamespaces.getFirst();
        if (namespace != NO_NAMESPACE) {
            this.writeEmptyElement(namespace, localName);
            return;
        }
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.delegate.writeEmptyElement(localName);
        this.state = 2;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.level;
        if (this.state != 1) {
            this.runAttrQueue();
            if (this.state != 4 || this.indentEndElement) {
                this.nl();
                this.indent();
                this.indentEndElement = false;
            }
            this.delegate.writeEndElement();
        } else {
            ArgRunnable start = this.attrQueue.poll();
            start.run(1);
            this.runAttrQueue();
        }
        this.unspecifiedNamespaces.pop();
        this.state = 2;
    }

    private void runAttrQueue() throws XMLStreamException {
        ArgRunnable attr;
        while ((attr = this.attrQueue.poll()) != null) {
            attr.run(0);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
        this.state = 8;
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
        this.state = 8;
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public void writeAttribute(final String localName, final String value) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                try {
                    XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(localName, value);
                }
                catch (XMLStreamException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
    }

    @Override
    public void writeAttribute(Enum<?> name, String property) throws XMLStreamException {
        this.writeAttribute(name.toString(), property);
    }

    @Override
    public void writeAttribute(final String prefix, final String namespaceURI, final String localName, final String value) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
            }
        });
    }

    @Override
    public void writeAttribute(final String namespaceURI, final String localName, final String value) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(namespaceURI, localName, value);
            }
        });
    }

    @Override
    public void writeAttribute(final String localName, final String[] values) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(localName, XMLExtendedStreamWriterImpl.join(values));
            }
        });
    }

    @Override
    public void writeAttribute(final String prefix, final String namespaceURI, final String localName, final String[] values) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(prefix, namespaceURI, localName, XMLExtendedStreamWriterImpl.join(values));
            }
        });
    }

    @Override
    public void writeAttribute(final String namespaceURI, final String localName, final String[] values) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(namespaceURI, localName, XMLExtendedStreamWriterImpl.join(values));
            }
        });
    }

    @Override
    public void writeAttribute(final String localName, final Iterable<String> values) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(localName, XMLExtendedStreamWriterImpl.join(values));
            }
        });
    }

    @Override
    public void writeAttribute(final String prefix, final String namespaceURI, final String localName, final Iterable<String> values) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(prefix, namespaceURI, localName, XMLExtendedStreamWriterImpl.join(values));
            }
        });
    }

    @Override
    public void writeAttribute(final String namespaceURI, final String localName, final Iterable<String> values) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeAttribute(namespaceURI, localName, XMLExtendedStreamWriterImpl.join(values));
            }
        });
    }

    @Override
    public void writeNamespace(final String prefix, final String namespaceURI) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeNamespace(prefix, namespaceURI);
            }
        });
    }

    @Override
    public void writeDefaultNamespace(final String namespaceURI) throws XMLStreamException {
        this.attrQueue.add(new ArgRunnable(){

            @Override
            public void run(int arg) throws XMLStreamException {
                XMLExtendedStreamWriterImpl.this.delegate.writeDefaultNamespace(namespaceURI);
            }
        });
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.delegate.writeProcessingInstruction(target);
        this.state = 3;
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.runAttrQueue();
        this.nl();
        this.indent();
        this.delegate.writeProcessingInstruction(target, data);
        this.state = 3;
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.runAttrQueue();
        this.delegate.writeCData(data);
        this.state = 12;
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.nl();
        this.indent();
        this.delegate.writeDTD(dtd);
        this.state = 11;
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.runAttrQueue();
        this.delegate.writeEntityRef(name);
        this.state = 9;
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
        this.nl();
        this.state = 7;
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
        this.nl();
        this.state = 7;
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
        this.nl();
        this.state = 7;
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.runAttrQueue();
        if (this.state != 4) {
            this.nl();
            this.indent();
        }
        String[] split = text.split("\\n");
        for (int i = 0; i < split.length; ++i) {
            this.delegate.writeCharacters(split[i]);
            if (i >= split.length - 1) continue;
            this.nl();
            this.indent();
        }
        this.state = 4;
        this.indentEndElement = true;
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.runAttrQueue();
        this.delegate.writeCharacters(text, start, len);
        this.state = 4;
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.runAttrQueue();
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    private static String join(String[] values) {
        StringBuilder b = new StringBuilder();
        int valuesLength = values.length;
        for (int i = 0; i < valuesLength; ++i) {
            String s = values[i];
            if (s == null) continue;
            if (i > 0) {
                b.append(' ');
            }
            b.append(s);
        }
        return b.toString();
    }

    private static String join(Iterable<String> values) {
        StringBuilder b = new StringBuilder();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (s == null) continue;
            b.append(s);
            if (!iterator.hasNext()) continue;
            b.append(' ');
        }
        return b.toString();
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
    }

    public static interface ArgRunnable {
        public void run(int var1) throws XMLStreamException;
    }
}

