/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Set;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class IntersectionTypeBinding18
extends ReferenceBinding {
    public ReferenceBinding[] intersectingTypes;
    private ReferenceBinding javaLangObject;
    int length;

    public IntersectionTypeBinding18(ReferenceBinding[] intersectingTypes, LookupEnvironment environment) {
        this.intersectingTypes = intersectingTypes;
        this.length = intersectingTypes.length;
        if (!intersectingTypes[0].isClass()) {
            this.javaLangObject = environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            this.modifiers |= 0x200;
        }
    }

    private IntersectionTypeBinding18(IntersectionTypeBinding18 prototype) {
        this.intersectingTypes = prototype.intersectingTypes;
        this.length = prototype.length;
        if (!this.intersectingTypes[0].isClass()) {
            this.javaLangObject = prototype.javaLangObject;
            this.modifiers |= 0x200;
        }
    }

    @Override
    public TypeBinding clone(TypeBinding enclosingType) {
        return new IntersectionTypeBinding18(this);
    }

    @Override
    protected MethodBinding[] getInterfaceAbstractContracts(Scope scope, boolean replaceWildcards) throws InvalidInputException {
        int typesLength = this.intersectingTypes.length;
        MethodBinding[][] methods = new MethodBinding[typesLength][];
        int contractsLength = 0;
        for (int i = 0; i < typesLength; ++i) {
            methods[i] = this.intersectingTypes[i].getInterfaceAbstractContracts(scope, replaceWildcards);
            contractsLength += methods[i].length;
        }
        MethodBinding[] contracts = new MethodBinding[contractsLength];
        int idx = 0;
        for (int i = 0; i < typesLength; ++i) {
            int len = methods[i].length;
            System.arraycopy(methods[i], 0, contracts, idx, len);
            idx += len;
        }
        return contracts;
    }

    @Override
    public boolean hasTypeBit(int bit) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.intersectingTypes[i].hasTypeBit(bit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public boolean canBeSeenBy(PackageBinding invocationPackage) {
        for (int i = 0; i < this.length; ++i) {
            if (this.intersectingTypes[i].canBeSeenBy(invocationPackage)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(Scope scope) {
        for (int i = 0; i < this.length; ++i) {
            if (this.intersectingTypes[i].canBeSeenBy(scope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(ReferenceBinding receiverType, ReferenceBinding invocationType) {
        for (int i = 0; i < this.length; ++i) {
            if (this.intersectingTypes[i].canBeSeenBy(receiverType, invocationType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public char[] constantPoolName() {
        return this.intersectingTypes[0].constantPoolName();
    }

    @Override
    public PackageBinding getPackage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceBinding[] getIntersectingTypes() {
        return this.intersectingTypes;
    }

    @Override
    public ReferenceBinding superclass() {
        return this.intersectingTypes[0].isClass() ? this.intersectingTypes[0] : this.javaLangObject;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.intersectingTypes[0].isClass()) {
            ReferenceBinding[] superInterfaces = new ReferenceBinding[this.length - 1];
            System.arraycopy(this.intersectingTypes, 1, superInterfaces, 0, this.length - 1);
            return superInterfaces;
        }
        return this.intersectingTypes;
    }

    @Override
    public boolean isBoxedPrimitiveType() {
        return this.intersectingTypes[0].isBoxedPrimitiveType();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding right, Scope scope) {
        if (TypeBinding.equalsEquals(this, right)) {
            return true;
        }
        int rightKind = right.kind();
        ReferenceBinding[] rightIntersectingTypes = null;
        if (rightKind == 8196 && right.boundKind() == 1) {
            TypeBinding allRightBounds = ((WildcardBinding)right).allBounds();
            if (allRightBounds instanceof IntersectionTypeBinding18) {
                rightIntersectingTypes = ((IntersectionTypeBinding18)allRightBounds).intersectingTypes;
            }
        } else if (rightKind == 32772) {
            rightIntersectingTypes = ((IntersectionTypeBinding18)right).intersectingTypes;
        }
        if (rightIntersectingTypes != null) {
            int numRequired = rightIntersectingTypes.length;
            TypeBinding[] required = new TypeBinding[numRequired];
            System.arraycopy(rightIntersectingTypes, 0, required, 0, numRequired);
            block0: for (int i = 0; i < this.length; ++i) {
                ReferenceBinding provided = this.intersectingTypes[i];
                for (int j = 0; j < required.length; ++j) {
                    if (required[j] == null || !((TypeBinding)provided).isCompatibleWith(required[j], scope)) continue;
                    required[j] = null;
                    if (--numRequired != 0) continue block0;
                    return true;
                }
            }
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (!this.intersectingTypes[i].isCompatibleWith(right, scope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding other) {
        if (TypeBinding.equalsEquals(this, other)) {
            return true;
        }
        for (int i = 0; i < this.intersectingTypes.length; ++i) {
            if (!this.intersectingTypes[i].isSubtypeOf(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public char[] qualifiedSourceName() {
        StringBuffer qualifiedSourceName = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            qualifiedSourceName.append(this.intersectingTypes[i].qualifiedSourceName());
            if (i == this.length - 1) continue;
            qualifiedSourceName.append(" & ");
        }
        return qualifiedSourceName.toString().toCharArray();
    }

    @Override
    public char[] sourceName() {
        StringBuffer srcName = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            srcName.append(this.intersectingTypes[i].sourceName());
            if (i == this.length - 1) continue;
            srcName.append(" & ");
        }
        return srcName.toString().toCharArray();
    }

    @Override
    public char[] readableName() {
        StringBuffer readableName = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            readableName.append(this.intersectingTypes[i].readableName());
            if (i == this.length - 1) continue;
            readableName.append(" & ");
        }
        return readableName.toString().toCharArray();
    }

    @Override
    public char[] shortReadableName() {
        StringBuffer shortReadableName = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            shortReadableName.append(this.intersectingTypes[i].shortReadableName());
            if (i == this.length - 1) continue;
            shortReadableName.append(" & ");
        }
        return shortReadableName.toString().toCharArray();
    }

    @Override
    public boolean isIntersectionType18() {
        return true;
    }

    @Override
    public int kind() {
        return 32772;
    }

    @Override
    public String debugName() {
        StringBuffer debugName = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            debugName.append(this.intersectingTypes[i].debugName());
            if (i == this.length - 1) continue;
            debugName.append(" & ");
        }
        return debugName.toString();
    }

    public String toString() {
        return this.debugName();
    }

    public TypeBinding getSAMType(Scope scope) {
        for (ReferenceBinding typeBinding : this.intersectingTypes) {
            MethodBinding methodBinding = ((TypeBinding)typeBinding).getSingleAbstractMethod(scope, true);
            if (methodBinding == null || methodBinding.problemId() == 17) continue;
            return typeBinding;
        }
        return null;
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> variables) {
        for (int i = 0; i < this.intersectingTypes.length; ++i) {
            this.intersectingTypes[i].collectInferenceVariables(variables);
        }
    }

    @Override
    public boolean mentionsAny(TypeBinding[] parameters, int idx) {
        if (super.mentionsAny(parameters, idx)) {
            return true;
        }
        for (int i = 0; i < this.intersectingTypes.length; ++i) {
            if (!this.intersectingTypes[i].mentionsAny(parameters, -1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long updateTagBits() {
        for (ReferenceBinding intersectingType : this.intersectingTypes) {
            this.tagBits |= intersectingType.updateTagBits();
        }
        return super.updateTagBits();
    }
}

