/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import nu.xom.Attribute;
import nu.xom.CycleException;
import nu.xom.Elements;
import nu.xom.IllegalAddException;
import nu.xom.IllegalNameException;
import nu.xom.MalformedURIException;
import nu.xom.MultipleParentException;
import nu.xom.NamespaceConflictException;
import nu.xom.Namespaces;
import nu.xom.NoSuchAttributeException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.URIUtil;
import nu.xom.Verifier;

public class Element
extends ParentNode {
    private String localName;
    private String prefix;
    private String URI;
    private Attribute[] attributes = null;
    private int numAttributes = 0;
    Namespaces namespaces = null;

    public Element(String name) {
        this(name, "");
    }

    public Element(String name, String uri) {
        String prefix = "";
        String localName = name;
        int colon = name.indexOf(58);
        if (colon > 0) {
            prefix = name.substring(0, colon);
            localName = name.substring(colon + 1);
        }
        this._setNamespacePrefix(prefix);
        this._setNamespaceURI(uri);
        try {
            this._setLocalName(localName);
        }
        catch (IllegalNameException ex) {
            ex.setData(name);
            throw ex;
        }
    }

    private Element() {
    }

    static Element build(String name, String uri, String localName) {
        Element result = new Element();
        String prefix = "";
        int colon = name.indexOf(58);
        if (colon >= 0) {
            prefix = name.substring(0, colon);
        }
        result.prefix = prefix;
        result.localName = localName;
        if (!"".equals(uri)) {
            Verifier.checkAbsoluteURIReference(uri);
        }
        result.URI = uri;
        return result;
    }

    public Element(Element element) {
        this.prefix = element.prefix;
        this.localName = element.localName;
        this.URI = element.URI;
        if (element.namespaces != null) {
            this.namespaces = element.namespaces.copy();
        }
        if (element.attributes != null) {
            this.attributes = element.copyAttributes(this);
            this.numAttributes = element.numAttributes;
        }
        this.actualBaseURI = element.findActualBaseURI();
        Element.copyChildren(element, this);
    }

    private Attribute[] copyAttributes(Element newParent) {
        if (this.numAttributes == 0) {
            return null;
        }
        Attribute[] copy = new Attribute[this.numAttributes];
        for (int i = 0; i < this.numAttributes; ++i) {
            copy[i] = (Attribute)this.attributes[i].copy();
            copy[i].setParent(newParent);
        }
        return copy;
    }

    private static Element copyTag(Element source) {
        Element result = source.shallowCopy();
        if (source.namespaces != null) {
            result.namespaces = source.namespaces.copy();
        }
        if (source.attributes != null) {
            result.attributes = source.copyAttributes(result);
            result.numAttributes = source.numAttributes;
        }
        result.actualBaseURI = source.findActualBaseURI();
        return result;
    }

    private static void copyChildren(Element sourceElement, Element resultElement) {
        if (sourceElement.getChildCount() == 0) {
            return;
        }
        Node resultParent = resultElement;
        Node sourceCurrent = sourceElement;
        int index = 0;
        int[] indexes = new int[10];
        int top = 0;
        indexes[0] = 0;
        boolean endTag = false;
        while (true) {
            Node child;
            if (!endTag && sourceCurrent.getChildCount() > 0) {
                sourceCurrent = sourceCurrent.getChild(0);
                index = 0;
                indexes = Element.grow(indexes, ++top);
                indexes[top] = 0;
            } else {
                endTag = false;
                ParentNode sourceParent = sourceCurrent.getParent();
                if (sourceParent.getChildCount() - 1 == index) {
                    sourceCurrent = sourceParent;
                    --top;
                    if (sourceCurrent == sourceElement) break;
                    resultParent = (Element)resultParent.getParent();
                    index = indexes[top];
                    endTag = true;
                    continue;
                }
                indexes[top] = ++index;
                sourceCurrent = sourceParent.getChild(index);
            }
            if (sourceCurrent.isElement()) {
                child = Element.copyTag((Element)sourceCurrent);
                resultParent.appendChild(child);
                if (sourceCurrent.getChildCount() <= 0) continue;
                resultParent = child;
                continue;
            }
            child = sourceCurrent.copy();
            resultParent.appendChild(child);
        }
    }

    private static int[] grow(int[] indexes, int top) {
        if (top < indexes.length) {
            return indexes;
        }
        int[] result = new int[indexes.length * 2];
        System.arraycopy(indexes, 0, result, 0, indexes.length);
        return result;
    }

    public final Elements getChildElements(String name) {
        return this.getChildElements(name, "");
    }

    public final Elements getChildElements(String localName, String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (localName == null) {
            localName = "";
        }
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node child = this.getChild(i);
            if (!child.isElement() || !localName.equals((element = (Element)child).getLocalName()) && localName.length() != 0 || !namespaceURI.equals(element.getNamespaceURI())) continue;
            elements.add(element);
        }
        return elements;
    }

    public final Elements getChildElements() {
        Elements elements = new Elements();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!child.isElement()) continue;
            Element element = (Element)child;
            elements.add(element);
        }
        return elements;
    }

    public final Element getFirstChildElement(String name) {
        return this.getFirstChildElement(name, "");
    }

    public final Element getFirstChildElement(String localName, String namespaceURI) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Element element;
            Node child = this.getChild(i);
            if (!child.isElement() || !localName.equals((element = (Element)child).getLocalName()) || !namespaceURI.equals(element.getNamespaceURI())) continue;
            return element;
        }
        return null;
    }

    public void addAttribute(Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new MultipleParentException("Attribute already has a parent");
        }
        String attPrefix = attribute.getNamespacePrefix();
        if (attPrefix.length() != 0 && !"xml".equals(attPrefix)) {
            String existing;
            if (this.prefix.equals(attribute.getNamespacePrefix()) && !this.getNamespaceURI().equals(attribute.getNamespaceURI())) {
                throw new NamespaceConflictException("Prefix of " + attribute.getQualifiedName() + " conflicts with element prefix " + this.prefix);
            }
            if (this.namespaces != null && (existing = this.namespaces.getURI(attribute.getNamespacePrefix())) != null && !existing.equals(attribute.getNamespaceURI())) {
                throw new NamespaceConflictException("Attribute prefix  " + attPrefix + " conflicts with namespace declaration.");
            }
        }
        if (this.attributes == null) {
            this.attributes = new Attribute[1];
        }
        this.checkPrefixConflict(attribute);
        Attribute oldAttribute = this.getAttribute(attribute.getLocalName(), attribute.getNamespaceURI());
        if (oldAttribute != null) {
            this.remove(oldAttribute);
        }
        this.add(attribute);
        attribute.setParent(this);
    }

    private void add(Attribute attribute) {
        if (this.numAttributes == this.attributes.length) {
            Attribute[] newAttributes = new Attribute[this.attributes.length * 2];
            System.arraycopy(this.attributes, 0, newAttributes, 0, this.numAttributes);
            this.attributes = newAttributes;
        }
        this.attributes[this.numAttributes] = attribute;
        ++this.numAttributes;
    }

    private boolean remove(Attribute attribute) {
        int index = -1;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] != attribute) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        int toCopy = this.numAttributes - index - 1;
        if (toCopy > 0) {
            System.arraycopy(this.attributes, index + 1, this.attributes, index, toCopy);
        }
        --this.numAttributes;
        this.attributes[this.numAttributes] = null;
        return true;
    }

    void fastAddAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new Attribute[1];
        }
        this.add(attribute);
        attribute.setParent(this);
    }

    public Attribute removeAttribute(Attribute attribute) {
        if (this.attributes == null) {
            throw new NoSuchAttributeException("Tried to remove attribute " + attribute.getQualifiedName() + " from non-parent element");
        }
        if (attribute == null) {
            throw new NullPointerException("Tried to remove null attribute");
        }
        if (this.remove(attribute)) {
            attribute.setParent(null);
            return attribute;
        }
        throw new NoSuchAttributeException("Tried to remove attribute " + attribute.getQualifiedName() + " from non-parent element");
    }

    public final Attribute getAttribute(String name) {
        return this.getAttribute(name, "");
    }

    public final Attribute getAttribute(String localName, String namespaceURI) {
        if (this.attributes == null) {
            return null;
        }
        for (int i = 0; i < this.numAttributes; ++i) {
            Attribute a = this.attributes[i];
            if (!a.getLocalName().equals(localName) || !a.getNamespaceURI().equals(namespaceURI)) continue;
            return a;
        }
        return null;
    }

    public final String getAttributeValue(String name) {
        return this.getAttributeValue(name, "");
    }

    public final int getAttributeCount() {
        return this.numAttributes;
    }

    public final Attribute getAttribute(int index) {
        if (this.attributes == null) {
            throw new IndexOutOfBoundsException("Element does not have any attributes");
        }
        return this.attributes[index];
    }

    public final String getAttributeValue(String localName, String namespaceURI) {
        Attribute attribute = this.getAttribute(localName, namespaceURI);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespaceURI(String prefix) {
        ParentNode parent;
        Element current = this;
        String result = this.getLocalNamespaceURI(prefix);
        while (result == null && (parent = current.getParent()) != null && !parent.isDocument()) {
            current = (Element)parent;
            result = current.getLocalNamespaceURI(prefix);
        }
        if (result == null && "".equals(prefix)) {
            result = "";
        }
        return result;
    }

    final String getLocalNamespaceURI(String prefix) {
        String result;
        if (prefix.equals(this.prefix)) {
            return this.URI;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "";
        }
        if (this.namespaces != null && (result = this.namespaces.getURI(prefix)) != null) {
            return result;
        }
        if (prefix.length() != 0 && this.attributes != null) {
            for (int i = 0; i < this.numAttributes; ++i) {
                Attribute a = this.attributes[i];
                if (!a.getNamespacePrefix().equals(prefix)) continue;
                return a.getNamespaceURI();
            }
        }
        return null;
    }

    public void setLocalName(String localName) {
        this._setLocalName(localName);
    }

    private void _setLocalName(String localName) {
        Verifier.checkNCName(localName);
        this.localName = localName;
    }

    public void setNamespaceURI(String uri) {
        this._setNamespaceURI(uri);
    }

    private void _setNamespaceURI(String uri) {
        String result;
        if (uri == null) {
            uri = "";
        }
        if (uri.equals(this.URI)) {
            return;
        }
        if (uri.length() == 0) {
            if (this.prefix.length() != 0) {
                throw new NamespaceConflictException("Prefixed elements must have namespace URIs.");
            }
        } else {
            Verifier.checkAbsoluteURIReference(uri);
        }
        if (this.namespaces != null && (result = this.namespaces.getURI(this.prefix)) != null) {
            throw new NamespaceConflictException("new URI conflicts with existing prefix");
        }
        if (uri.length() > 0 && this.attributes != null) {
            for (int i = 0; i < this.numAttributes; ++i) {
                Attribute a = this.attributes[i];
                String attPrefix = a.getNamespacePrefix();
                if (attPrefix.length() == 0 || !a.getNamespacePrefix().equals(this.prefix)) continue;
                throw new NamespaceConflictException("new element URI " + uri + " conflicts with attribute " + a.getQualifiedName());
            }
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri) && !"xml".equals(this.prefix)) {
            throw new NamespaceConflictException("Wrong prefix " + this.prefix + " for the http://www.w3.org/XML/1998/namespace namespace URI");
        }
        if ("xml".equals(this.prefix) && !"http://www.w3.org/XML/1998/namespace".equals(uri)) {
            throw new NamespaceConflictException("Wrong namespace URI " + uri + " for the xml prefix");
        }
        this.URI = uri;
    }

    public void setNamespacePrefix(String prefix) {
        this._setNamespacePrefix(prefix);
    }

    private void _setNamespacePrefix(String prefix) {
        String uri;
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.length() != 0) {
            Verifier.checkNCName(prefix);
        }
        if ((uri = this.getLocalNamespaceURI(prefix)) != null) {
            if (!uri.equals(this.URI) && !"xml".equals(prefix)) {
                throw new NamespaceConflictException(prefix + " conflicts with existing prefix");
            }
        } else if ("".equals(this.URI) && !"".equals(prefix)) {
            throw new NamespaceConflictException("Cannot assign prefix to element in no namespace");
        }
        this.prefix = prefix;
    }

    @Override
    void insertionAllowed(Node child, int position) {
        if (child == null) {
            throw new NullPointerException("Tried to insert a null child in the tree");
        }
        if (child.getParent() != null) {
            throw new MultipleParentException(child.toString() + " child already has a parent.");
        }
        if (child.isElement()) {
            Element.checkCycle(child, this);
            return;
        }
        if (child.isText() || child.isProcessingInstruction() || child.isComment()) {
            return;
        }
        throw new IllegalAddException("Cannot add a " + child.getClass().getName() + " to an Element.");
    }

    private static void checkCycle(Node child, ParentNode parent) {
        if (child == parent) {
            throw new CycleException("Cannot add a node to itself");
        }
        if (child.getChildCount() == 0) {
            return;
        }
        while ((parent = parent.getParent()) != null) {
            if (parent != child) continue;
            throw new CycleException("Cannot add an ancestor as a child");
        }
    }

    public void insertChild(String text, int position) {
        if (text == null) {
            throw new NullPointerException("Inserted null string");
        }
        super.fastInsertChild(new Text(text), position);
    }

    public void appendChild(String text) {
        this.insertChild(new Text(text), this.getChildCount());
    }

    public Nodes removeChildren() {
        int length = this.getChildCount();
        Nodes result = new Nodes();
        for (int i = 0; i < length; ++i) {
            Node child = this.getChild(i);
            if (child.isElement()) {
                this.fillInBaseURI((Element)child);
            }
            child.setParent(null);
            result.append(child);
        }
        this.children = null;
        this.childCount = 0;
        return result;
    }

    public void addNamespaceDeclaration(String prefix, String uri) {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (prefix.equals("xmlns")) {
            if (uri.equals("")) {
                return;
            }
            throw new NamespaceConflictException("The xmlns prefix cannot bound to any URI");
        }
        if (prefix.equals("xml")) {
            if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + uri);
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceConflictException("Wrong prefix for http://www.w3.org/XML/1998/namespace namespace: " + prefix);
        }
        if (prefix.length() != 0) {
            Verifier.checkNCName(prefix);
            Verifier.checkAbsoluteURIReference(uri);
        } else if (uri.length() != 0) {
            Verifier.checkAbsoluteURIReference(uri);
        }
        String currentBinding = this.getLocalNamespaceURI(prefix);
        if (currentBinding != null && !currentBinding.equals(uri)) {
            String message = prefix.equals("") ? "Additional namespace " + uri + " conflicts with existing default namespace " + currentBinding : "Additional namespace " + uri + " for the prefix " + prefix + " conflicts with existing namespace binding " + currentBinding;
            throw new NamespaceConflictException(message);
        }
        if (this.namespaces == null) {
            this.namespaces = new Namespaces();
        }
        this.namespaces.put(prefix, uri);
    }

    public void removeNamespaceDeclaration(String prefix) {
        if (this.namespaces != null) {
            this.namespaces.remove(prefix);
        }
    }

    public final int getNamespaceDeclarationCount() {
        HashSet<String> allPrefixes = null;
        if (this.namespaces != null) {
            allPrefixes = new HashSet<String>(this.namespaces.getPrefixes());
            allPrefixes.add(this.prefix);
        }
        if ("xml".equals(this.prefix)) {
            allPrefixes = new HashSet();
        }
        int count = this.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            Attribute att = this.attributes[i];
            String attPrefix = att.getNamespacePrefix();
            if (attPrefix.length() == 0 || "xml".equals(attPrefix)) continue;
            if (allPrefixes == null) {
                allPrefixes = new HashSet();
                allPrefixes.add(this.prefix);
            }
            allPrefixes.add(attPrefix);
        }
        if (allPrefixes == null) {
            return 1;
        }
        return allPrefixes.size();
    }

    Map getNamespacePrefixesInScope() {
        HashMap namespaces = new HashMap();
        Element current = this;
        while (true) {
            ParentNode parent;
            int i;
            if (!"xml".equals(current.prefix)) {
                this.addPrefixIfNotAlreadyPresent(namespaces, current, current.prefix);
            }
            if (current.attributes != null) {
                int count = current.numAttributes;
                for (i = 0; i < count; ++i) {
                    Attribute att = current.attributes[i];
                    String attPrefix = att.getNamespacePrefix();
                    if (attPrefix.length() == 0 || "xml".equals(attPrefix)) continue;
                    this.addPrefixIfNotAlreadyPresent(namespaces, current, attPrefix);
                }
            }
            if (current.namespaces != null) {
                int namespaceCount = current.namespaces.size();
                for (i = 0; i < namespaceCount; ++i) {
                    String nsPrefix = current.namespaces.getPrefix(i);
                    this.addPrefixIfNotAlreadyPresent(namespaces, current, nsPrefix);
                }
            }
            if ((parent = current.getParent()) == null || parent.isDocument() || parent.isDocumentFragment()) break;
            current = (Element)parent;
        }
        return namespaces;
    }

    private void addPrefixIfNotAlreadyPresent(HashMap namespaces, Element current, String prefix) {
        if (!namespaces.containsKey(prefix)) {
            namespaces.put(prefix, current.getLocalNamespaceURI(prefix));
        }
    }

    public final String getNamespacePrefix(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative prefix number " + index);
        }
        if (index == 0 && !"xml".equals(this.prefix)) {
            return this.prefix;
        }
        Set allPrefixes = this.getNamespacePrefixes();
        Iterator iterator = allPrefixes.iterator();
        try {
            for (int i = 0; i < index; ++i) {
                iterator.next();
            }
            return (String)iterator.next();
        }
        catch (NoSuchElementException ex) {
            throw new IndexOutOfBoundsException("No " + index + "th namespace");
        }
    }

    private Set getNamespacePrefixes() {
        LinkedHashSet<String> allPrefixes = new LinkedHashSet<String>();
        if (!"xml".equals(this.prefix)) {
            allPrefixes.add(this.prefix);
        }
        if (this.namespaces != null) {
            allPrefixes.addAll(this.namespaces.getPrefixes());
        }
        if (this.attributes != null) {
            int count = this.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                Attribute att = this.attributes[i];
                String attPrefix = att.getNamespacePrefix();
                if (attPrefix.length() == 0 || "xml".equals(attPrefix)) continue;
                allPrefixes.add(attPrefix);
            }
        }
        return allPrefixes;
    }

    @Override
    public void setBaseURI(String URI) {
        this.setActualBaseURI(URI);
    }

    @Override
    public String getBaseURI() {
        String baseURI;
        block7: {
            String currentEntity;
            baseURI = "";
            String sourceEntity = this.getActualBaseURI();
            ParentNode current = this;
            do {
                currentEntity = current.getActualBaseURI();
                if (sourceEntity.length() != 0 && !sourceEntity.equals(currentEntity)) {
                    baseURI = URIUtil.absolutize(sourceEntity, baseURI);
                    break block7;
                }
                if (current.isDocument()) {
                    baseURI = URIUtil.absolutize(currentEntity, baseURI);
                    break block7;
                }
                Attribute baseAttribute = current.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
                if (baseAttribute == null) continue;
                String baseIRI = baseAttribute.getValue();
                String base = URIUtil.toURI(baseIRI);
                if ("".equals(base)) {
                    baseURI = this.getEntityURI();
                    break block7;
                }
                if (!this.legalURI(base)) continue;
                if ("".equals(baseURI)) {
                    baseURI = base;
                } else {
                    if (URIUtil.isOpaque(base)) break block7;
                    baseURI = URIUtil.absolutize(base, baseURI);
                }
                if (URIUtil.isAbsolute(base)) break block7;
            } while ((current = current.getParent()) != null);
            baseURI = URIUtil.absolutize(currentEntity, baseURI);
        }
        if (URIUtil.isAbsolute(baseURI)) {
            return baseURI;
        }
        return "";
    }

    private String getEntityURI() {
        for (ParentNode current = this; current != null; current = current.getParent()) {
            if (current.actualBaseURI == null || current.actualBaseURI.length() == 0) continue;
            return current.actualBaseURI;
        }
        return "";
    }

    private boolean legalURI(String base) {
        try {
            Verifier.checkURIReference(base);
            return true;
        }
        catch (MalformedURIException ex) {
            return false;
        }
    }

    @Override
    public final String toXML() {
        StringBuffer result = new StringBuffer(1024);
        Node current = this;
        boolean endTag = false;
        int index = -1;
        int[] indexes = new int[10];
        int top = 0;
        indexes[0] = -1;
        while (true) {
            if (!endTag && current.getChildCount() > 0) {
                Element.writeStartTag((Element)current, result);
                current = current.getChild(0);
                index = 0;
                indexes = Element.grow(indexes, ++top);
                indexes[top] = 0;
                continue;
            }
            if (endTag) {
                Element.writeEndTag((Element)current, result);
                if (current == this) {
                    break;
                }
            } else if (current.isElement()) {
                Element.writeStartTag((Element)current, result);
                if (current == this) {
                    break;
                }
            } else {
                result.append(current.toXML());
            }
            endTag = false;
            ParentNode parent = current.getParent();
            if (parent.getChildCount() - 1 == index) {
                current = parent;
                --top;
                if (current != this) {
                    index = indexes[top];
                }
                endTag = true;
                continue;
            }
            indexes[top] = ++index;
            current = parent.getChild(index);
        }
        return result.toString();
    }

    private static void writeStartTag(Element element, StringBuffer result) {
        int i;
        result.append('<');
        result.append(element.getQualifiedName());
        ParentNode parentNode = element.getParent();
        for (i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            Element parentElement;
            String additionalPrefix = element.getNamespacePrefix(i);
            String uri = element.getNamespaceURI(additionalPrefix);
            if (parentNode != null && parentNode.isElement() ? uri.equals((parentElement = (Element)parentNode).getNamespaceURI(additionalPrefix)) : uri.length() == 0) continue;
            result.append(" xmlns");
            if (additionalPrefix.length() > 0) {
                result.append(':');
                result.append(additionalPrefix);
            }
            result.append("=\"");
            result.append(Element.escape(uri));
            result.append('\"');
        }
        if (element.attributes != null) {
            for (i = 0; i < element.numAttributes; ++i) {
                Attribute attribute = element.attributes[i];
                result.append(' ');
                result.append(attribute.toXML());
            }
        }
        if (element.getChildCount() > 0) {
            result.append('>');
        } else {
            result.append(" />");
        }
    }

    private static String escape(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length + 12);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static void writeEndTag(Element element, StringBuffer result) {
        result.append("</");
        result.append(element.getQualifiedName());
        result.append('>');
    }

    @Override
    public final String getValue() {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return "";
        }
        Node current = this.getChild(0);
        if (childCount == 1 && current.isText()) {
            return current.getValue();
        }
        StringBuffer result = new StringBuffer();
        int index = 0;
        int[] indexes = new int[10];
        int top = 0;
        indexes[0] = 0;
        boolean endTag = false;
        while (true) {
            ParentNode parent;
            if (!endTag && current.getChildCount() > 0) {
                current = current.getChild(0);
                index = 0;
                indexes = Element.grow(indexes, ++top);
                indexes[top] = 0;
                continue;
            }
            endTag = false;
            if (current.isText()) {
                result.append(current.getValue());
            }
            if ((parent = current.getParent()).getChildCount() - 1 == index) {
                current = parent;
                --top;
                if (current == this) break;
                index = indexes[top];
                endTag = true;
                continue;
            }
            indexes[top] = ++index;
            current = parent.getChild(index);
        }
        return result.toString();
    }

    @Override
    public Node copy() {
        Element result = Element.copyTag(this);
        Element.copyChildren(this, result);
        return result;
    }

    protected Element shallowCopy() {
        return new Element(this.getQualifiedName(), this.getNamespaceURI());
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "]";
    }

    @Override
    boolean isElement() {
        return true;
    }

    private void checkPrefixConflict(Attribute attribute) {
        String prefix = attribute.getNamespacePrefix();
        String namespaceURI = attribute.getNamespaceURI();
        for (int i = 0; i < this.numAttributes; ++i) {
            Attribute a = this.attributes[i];
            if (!a.getNamespacePrefix().equals(prefix)) continue;
            if (a.getNamespaceURI().equals(namespaceURI)) {
                return;
            }
            throw new NamespaceConflictException("Prefix of " + attribute.getQualifiedName() + " conflicts with " + a.getQualifiedName());
        }
    }

    Iterator attributeIterator() {
        return new AttributeIterator();
    }

    private class AttributeIterator
    implements Iterator {
        private int next = 0;

        private AttributeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next < Element.this.numAttributes;
        }

        public Object next() throws NoSuchElementException {
            if (this.hasNext()) {
                Attribute a = Element.this.attributes[this.next];
                ++this.next;
                return a;
            }
            throw new NoSuchElementException("No such attribute");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

