/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.hostexclude;

import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.jboss.HostExclude;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.HostExcludeResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;

public class AddHostExclude<S>
extends ManageableResourceLeafTask.Builder<S, HostExcludeResource.Parent> {
    public AddHostExclude(HostExclude hostExclude) {
        String hostExcludeName = hostExclude.getName();
        this.name("host-exclude." + hostExcludeName + ".add");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debugf("Adding host-exclude %s...", (Object)hostExcludeName));
        this.runBuilder(params -> taskContext -> {
            List excludedExtensions;
            HostExclude.Release hostRelease;
            HostExcludeResource.Parent parent = (HostExcludeResource.Parent)params.getResource();
            if (parent.hasHostExcludeResource(hostExcludeName)) {
                parent.removeHostExcludeResource(hostExcludeName);
                taskContext.getLogger().debugf("Legacy host-exclude %s found and removed...", (Object)hostExclude.getName());
            }
            PathAddress hostExcludePathAddress = parent.getHostExcludeResourcePathAddress(hostExclude.getName());
            ModelNode addOp = Util.createAddOperation((PathAddress)hostExcludePathAddress);
            HostExclude.ApiVersion apiVersion = hostExclude.getApiVersion();
            if (apiVersion != null) {
                addOp.get("management-major-version").set(apiVersion.getMajorVersion());
                addOp.get("management-minor-version").set(apiVersion.getMinorVersion());
                if (apiVersion.getMicroVersion() != null) {
                    addOp.get("management-micro-version").set(apiVersion.getMicroVersion());
                }
            }
            if ((hostRelease = hostExclude.getRelease()) != null) {
                addOp.get("host-release").set(hostRelease.getId());
            }
            if ((excludedExtensions = hostExclude.getExcludedExtensions()) != null && !excludedExtensions.isEmpty()) {
                ModelNode modelNode = addOp.get("excluded-extensions").setEmptyList();
                for (HostExclude.ExcludedExtension excludedExtension : excludedExtensions) {
                    modelNode.add(excludedExtension.getModule());
                }
            }
            params.getServerConfiguration().executeManagementOperation(addOp);
            taskContext.getLogger().debugf("Host-exclude %s added.", (Object)hostExcludeName);
            return ServerMigrationTaskResult.SUCCESS;
        });
    }
}

