/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.driver.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;

public class DriverRegistryImpl
implements DriverRegistry {
    private final Map<String, InstalledDriver> drivers = Collections.synchronizedMap(new HashMap());

    @Override
    public void registerInstalledDriver(InstalledDriver driver) throws IllegalArgumentException {
        if (driver == null) {
            throw new IllegalArgumentException(ConnectorLogger.ROOT_LOGGER.nullVar("driver"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Adding driver: %s", driver);
        this.drivers.put(driver.getDriverName(), driver);
    }

    @Override
    public void unregisterInstalledDriver(InstalledDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(ConnectorLogger.ROOT_LOGGER.nullVar("driver"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Removing deployment: %s", driver);
        this.drivers.remove(driver.getDriverName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InstalledDriver> getInstalledDrivers() {
        Map<String, InstalledDriver> map = this.drivers;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<InstalledDriver>(this.drivers.values()));
        }
    }

    @Override
    public InstalledDriver getInstalledDriver(String name) throws IllegalStateException {
        return this.drivers.get(name);
    }
}

