/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class IntersectionCastTypeReference
extends TypeReference {
    public TypeReference[] typeReferences;

    public IntersectionCastTypeReference(TypeReference[] typeReferences) {
        this.typeReferences = typeReferences;
        this.sourceStart = typeReferences[0].sourceStart;
        int length = typeReferences.length;
        this.sourceEnd = typeReferences[length - 1].sourceEnd;
        int max = typeReferences.length;
        for (int i = 0; i < max; ++i) {
            if ((typeReferences[i].bits & 0x100000) == 0) continue;
            this.bits |= 0x100000;
            break;
        }
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int additionalDimensions, Annotation[][] additionalAnnotations, boolean isVarargs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char[] getLastToken() {
        return null;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    @Override
    public TypeReference[] getTypeReferences() {
        return this.typeReferences;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope, boolean checkBounds, int location) {
        int length = this.typeReferences.length;
        ReferenceBinding[] intersectingTypes = new ReferenceBinding[length];
        boolean hasError = false;
        int typeCount = 0;
        block0: for (int i = 0; i < length; ++i) {
            TypeReference typeReference = this.typeReferences[i];
            TypeBinding type = typeReference.resolveType(scope, checkBounds, location);
            if (type == null || (type.tagBits & 0x80L) != 0L) {
                hasError = true;
                continue;
            }
            if (i == 0) {
                if (type.isBaseType()) {
                    scope.problemReporter().onlyReferenceTypesInIntersectionCast(typeReference);
                    hasError = true;
                    continue;
                }
                if (type.isArrayType()) {
                    scope.problemReporter().illegalArrayTypeInIntersectionCast(typeReference);
                    hasError = true;
                    continue;
                }
            } else if (!type.isInterface()) {
                scope.problemReporter().boundMustBeAnInterface(typeReference, type);
                hasError = true;
                continue;
            }
            for (int j = 0; j < typeCount; ++j) {
                ReferenceBinding priorType = intersectingTypes[j];
                if (TypeBinding.equalsEquals(priorType, type)) {
                    scope.problemReporter().duplicateBoundInIntersectionCast(typeReference);
                    hasError = true;
                    continue;
                }
                if (!priorType.isInterface()) continue;
                if (TypeBinding.equalsEquals(type.findSuperTypeOriginatingFrom(priorType), priorType)) {
                    intersectingTypes[j] = (ReferenceBinding)type;
                    continue block0;
                }
                if (TypeBinding.equalsEquals(priorType.findSuperTypeOriginatingFrom(type), type)) continue block0;
            }
            intersectingTypes[typeCount++] = (ReferenceBinding)type;
        }
        if (hasError) {
            return null;
        }
        if (typeCount != length) {
            if (typeCount == 1) {
                this.resolvedType = intersectingTypes[0];
                return this.resolvedType;
            }
            ReferenceBinding[] referenceBindingArray = intersectingTypes;
            intersectingTypes = new ReferenceBinding[typeCount];
            System.arraycopy(referenceBindingArray, 0, intersectingTypes, 0, typeCount);
        }
        IntersectionTypeBinding18 intersectionType = (IntersectionTypeBinding18)scope.environment().createIntersectionType18(intersectingTypes);
        ReferenceBinding itsSuperclass = null;
        ReferenceBinding[] interfaces = intersectingTypes;
        ReferenceBinding firstType = intersectingTypes[0];
        if (firstType.isClass()) {
            itsSuperclass = firstType.superclass();
            interfaces = new ReferenceBinding[typeCount - 1];
            System.arraycopy(intersectingTypes, 1, interfaces, 0, typeCount - 1);
        }
        HashMap invocations = new HashMap(2);
        int interfaceCount = interfaces.length;
        for (int i = 0; i < interfaceCount; ++i) {
            ReferenceBinding two;
            ReferenceBinding one = interfaces[i];
            if (one == null || itsSuperclass != null && scope.hasErasedCandidatesCollisions(itsSuperclass, one, invocations, intersectionType, this)) continue;
            for (int j = 0; !(j >= i || (two = interfaces[j]) != null && scope.hasErasedCandidatesCollisions(one, two, invocations, intersectionType, this)); ++j) {
            }
        }
        if ((intersectionType.tagBits & 0x20000L) != 0L) {
            return null;
        }
        this.resolvedType = intersectionType;
        return this.resolvedType;
    }

    @Override
    public char[][] getTypeName() {
        return this.typeReferences[0].getTypeName();
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int length = this.typeReferences == null ? 0 : this.typeReferences.length;
            for (int i = 0; i < length; ++i) {
                this.typeReferences[i].traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope scope) {
        throw new UnsupportedOperationException("Unexpected traversal request: IntersectionTypeReference in class scope");
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        int length = this.typeReferences == null ? 0 : this.typeReferences.length;
        IntersectionCastTypeReference.printIndent(indent, output);
        for (int i = 0; i < length; ++i) {
            this.typeReferences[i].printExpression(0, output);
            if (i == length - 1) continue;
            output.append(" & ");
        }
        return output;
    }
}

