/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.hibernate.search.backend.impl.LocalBackend;
import org.hibernate.search.backend.impl.ReflectionBasedBackend;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackend;
import org.hibernate.search.backend.spi.Backend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class InternalBackendFactory {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final String JMS_BACKEND = "org.hibernate.search.backend.jms.impl.JndiJMSBackend";
    private static final String JGROUPS_AUTO_BACKEND = "org.hibernate.search.backend.jgroups.impl.JGroupsBackend";
    private static final String JGROUPS_MASTER_BACKEND = "org.hibernate.search.backend.jgroups.impl.JGroupsMasterBackend";
    private static final String JGROUPS_SLAVE_BACKEND = "org.hibernate.search.backend.jgroups.impl.JGroupsSlaveBackend";

    private InternalBackendFactory() {
    }

    public static Backend createBackend(String backendName, String indexName, Properties properties, WorkerBuildContext buildContext) {
        Backend backend;
        if (StringHelper.isEmpty(backendName) || "local".equalsIgnoreCase(backendName)) {
            backend = LocalBackend.INSTANCE;
        } else if ("lucene".equalsIgnoreCase(backendName)) {
            log.deprecatedBackendName();
            backend = LocalBackend.INSTANCE;
        } else if ("jms".equalsIgnoreCase(backendName)) {
            backend = ClassLoaderHelper.instanceFromName(Backend.class, JMS_BACKEND, "JMS backend", buildContext.getServiceManager());
        } else if ("blackhole".equalsIgnoreCase(backendName)) {
            backend = BlackHoleBackend.INSTANCE;
        } else if ("jgroupsMaster".equals(backendName)) {
            backend = InternalBackendFactory.createJGroupsBackend(JGROUPS_MASTER_BACKEND, buildContext);
        } else if ("jgroupsSlave".equals(backendName)) {
            backend = InternalBackendFactory.createJGroupsBackend(JGROUPS_SLAVE_BACKEND, buildContext);
        } else if ("jgroups".equals(backendName)) {
            backend = InternalBackendFactory.createJGroupsBackend(JGROUPS_AUTO_BACKEND, buildContext);
        } else {
            ServiceManager serviceManager = buildContext.getServiceManager();
            try {
                backend = ClassLoaderHelper.instanceFromName(Backend.class, backendName, "Backend", serviceManager);
            }
            catch (SearchException backendException) {
                try {
                    Class<BackendQueueProcessor> backendQueueProcessorClass = ClassLoaderHelper.classForName(BackendQueueProcessor.class, backendName, "BackendQueueProcessor", serviceManager);
                    backend = new ReflectionBasedBackend(backendQueueProcessorClass);
                }
                catch (SearchException backendQueueProcessorException) {
                    backendException.addSuppressed(backendQueueProcessorException);
                    throw backendException;
                }
            }
        }
        boolean enlistInTransaction = ConfigurationParseHelper.getBooleanValue(properties, "hibernate.search.worker.enlist_in_transaction", false);
        if (enlistInTransaction && !backend.isTransactional()) {
            backendName = StringHelper.isEmpty(backendName) ? "lucene" : backendName;
            throw log.backendNonTransactional(indexName, backendName);
        }
        backend.initialize(properties, buildContext);
        return backend;
    }

    public static boolean isConfiguredAsSync(Properties properties) {
        return !"async".equalsIgnoreCase(properties.getProperty("worker.execution"));
    }

    private static Backend createJGroupsBackend(String backendClassName, WorkerBuildContext context) {
        try {
            return ClassLoaderHelper.instanceFromName(Backend.class, backendClassName, "JGroups backend", context.getServiceManager());
        }
        catch (Exception e) {
            throw log.getUnableToCreateJGroupsBackendException(e);
        }
    }
}

