/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandException;
import org.aesh.command.completer.OptionCompleter;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.cli.AbstractDistributionCommand;
import org.jboss.as.patching.cli.PatchRollbackActivator;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;

public class PatchIdCompleter
implements OptionCompleter<CLICompleterInvocation> {
    public void complete(CLICompleterInvocation completerInvocation) {
        AbstractDistributionCommand cmd = (AbstractDistributionCommand)completerInvocation.getCommand();
        try {
            List<ModelNode> patches = PatchRollbackActivator.getPatches(completerInvocation.getCommandContext(), cmd, cmd.getPatchStream(), cmd.getHost());
            ArrayList<String> names = new ArrayList<String>();
            for (ModelNode mn : patches) {
                if (!mn.hasDefined("patch-id")) continue;
                names.add(mn.get("patch-id").asString());
            }
            String buffer = completerInvocation.getGivenCompleteValue();
            if (buffer == null || buffer.isEmpty()) {
                completerInvocation.addAllCompleterValues(names);
            } else {
                for (String n : names) {
                    if (!n.startsWith(buffer)) continue;
                    completerInvocation.addCompleterValue(n);
                    completerInvocation.setOffset(buffer.length());
                }
            }
        }
        catch (CommandException | PatchingException ex) {
            return;
        }
    }
}

