/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.wildfly.clustering.marshalling.protostream.FunctionalMarshaller;
import org.wildfly.clustering.marshalling.protostream.FunctionalScalarMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamBuilderFieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.ValueMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.CalendarMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.CollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.EnumMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.EnumSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.LinkedHashMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.MapEntryMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.MapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.OptionalMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SingletonCollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SingletonMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.UUIDBuilder;
import org.wildfly.clustering.marshalling.protostream.util.UUIDMarshaller;
import org.wildfly.common.function.Functions;

public enum UtilMarshallerProvider implements ProtoStreamMarshallerProvider
{
    ARRAY_DEQUE(new CollectionMarshaller<ArrayDeque>(ArrayDeque::new)),
    ARRAY_LIST(new CollectionMarshaller<ArrayList>(ArrayList::new)),
    BIT_SET(new FunctionalScalarMarshaller<BitSet, byte[]>(Scalar.BYTE_ARRAY.cast(byte[].class), BitSet::new, BitSet::isEmpty, BitSet::toByteArray, BitSet::valueOf)),
    CALENDAR(new CalendarMarshaller()),
    CURRENCY(new FunctionalScalarMarshaller<Currency, String>(Currency.class, Scalar.STRING.cast(String.class), Functions.constantSupplier((Object)UtilMarshallerProvider.getDefaultCurrency()), Currency::getCurrencyCode, Currency::getInstance)),
    DATE(new FunctionalMarshaller<Date, Instant>(Date.class, Instant.class, Date::toInstant, Date::from)),
    EMPTY_ENUMERATION(new ValueMarshaller<Enumeration<T>>(Collections.emptyEnumeration())),
    EMPTY_ITERATOR(new ValueMarshaller<Iterator<T>>(Collections.emptyIterator())),
    EMPTY_LIST(new ValueMarshaller<List<T>>(Collections.emptyList())),
    EMPTY_LIST_ITERATOR(new ValueMarshaller<ListIterator<T>>(Collections.emptyListIterator())),
    EMPTY_MAP(new ValueMarshaller<Map<K, V>>(Collections.emptyMap())),
    EMPTY_NAVIGABLE_MAP(new ValueMarshaller<NavigableMap<K, V>>(Collections.emptyNavigableMap())),
    EMPTY_NAVIGABLE_SET(new ValueMarshaller<NavigableSet<E>>(Collections.emptyNavigableSet())),
    EMPTY_SET(new ValueMarshaller<Set<T>>(Collections.emptySet())),
    EMPTY_SORTED_MAP(new ValueMarshaller<SortedMap<K, V>>(Collections.emptySortedMap())),
    EMPTY_SORTED_SET(new ValueMarshaller<SortedSet<E>>(Collections.emptySortedSet())),
    ENUM_MAP(new EnumMapMarshaller<E>()),
    ENUM_SET(new EnumSetMarshaller<E>()),
    HASH_MAP(new MapMarshaller<HashMap>(HashMap::new)),
    HASH_SET(new CollectionMarshaller<HashSet>(HashSet::new)),
    LINKED_HASH_MAP(new LinkedHashMapMarshaller()),
    LINKED_HASH_SET(new CollectionMarshaller<LinkedHashSet>(LinkedHashSet::new)),
    LINKED_LIST(new CollectionMarshaller<LinkedList>(LinkedList::new)),
    LOCALE(new FunctionalScalarMarshaller<T, String>(Scalar.STRING.cast(String.class), Functions.constantSupplier((Object)Locale.getDefault()), Locale::toLanguageTag, Locale::forLanguageTag)),
    OPTIONAL(OptionalMarshaller.OBJECT),
    OPTIONAL_DOUBLE(OptionalMarshaller.DOUBLE),
    OPTIONAL_INT(OptionalMarshaller.INT),
    OPTIONAL_LONG(OptionalMarshaller.LONG),
    SIMPLE_ENTRY(new MapEntryMarshaller<AbstractMap.SimpleEntry>(AbstractMap.SimpleEntry::new)),
    SIMPLE_IMMUTABLE_ENTRY(new MapEntryMarshaller<AbstractMap.SimpleImmutableEntry>(AbstractMap.SimpleImmutableEntry::new)),
    SINGLETON_LIST(new SingletonCollectionMarshaller<List>(Collections::singletonList)),
    SINGLETON_MAP(new SingletonMapMarshaller(Collections::singletonMap)),
    SINGLETON_SET(new SingletonCollectionMarshaller<Set>(Collections::singleton)),
    TIME_ZONE(new FunctionalScalarMarshaller<TimeZone, String>(TimeZone.class, Scalar.STRING.cast(String.class), Functions.constantSupplier((Object)TimeZone.getDefault()), TimeZone::getID, TimeZone::getTimeZone)),
    TREE_MAP(new SortedMapMarshaller<TreeMap>(TreeMap::new)),
    TREE_SET(new SortedSetMarshaller<TreeSet>(TreeSet::new)),
    UUID(new ProtoStreamBuilderFieldSetMarshaller<UUID, UUIDBuilder>(UUIDMarshaller.INSTANCE));

    private final ProtoStreamMarshaller<?> marshaller;

    private UtilMarshallerProvider(ProtoStreamMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this.marshaller;
    }

    private static Currency getDefaultCurrency() {
        try {
            return Currency.getInstance(Locale.getDefault());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

