/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPDigestCalculatorProviderBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcaPGPDigestCalculatorProviderBuilder() {
    }

    JcaPGPDigestCalculatorProviderBuilder(OperatorHelper helper) {
        this.helper = helper;
    }

    public JcaPGPDigestCalculatorProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPDigestCalculatorProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PGPDigestCalculatorProvider build() throws PGPException {
        return new PGPDigestCalculatorProvider(){

            @Override
            public PGPDigestCalculator get(final int algorithm) throws PGPException {
                DigestOutputStream stream;
                MessageDigest dig;
                try {
                    dig = JcaPGPDigestCalculatorProviderBuilder.this.helper.createDigest(algorithm);
                    stream = new DigestOutputStream(dig);
                }
                catch (GeneralSecurityException e) {
                    throw new PGPException("exception on setup: " + e, e);
                }
                return new PGPDigestCalculator(){

                    @Override
                    public int getAlgorithm() {
                        return algorithm;
                    }

                    @Override
                    public OutputStream getOutputStream() {
                        return stream;
                    }

                    @Override
                    public byte[] getDigest() {
                        return stream.getDigest();
                    }

                    @Override
                    public void reset() {
                        dig.reset();
                    }
                };
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private MessageDigest dig;

        DigestOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes);
        }

        @Override
        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            return this.dig.digest();
        }
    }
}

