/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Duration;
import javax.ejb.ConcurrentAccessTimeoutException;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.util.concurrent.TimeoutException;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBean;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class InfinispanBeanFactory<I, T, C>
implements BeanFactory<I, T> {
    private final String beanName;
    private final BeanGroupFactory<I, T, C> groupFactory;
    private final Cache<BeanKey<I>, BeanEntry<I>> cache;
    private final Cache<BeanKey<I>, BeanEntry<I>> findCache;
    private final Duration timeout;
    private final PassivationListener<T> listener;
    private final MutatorFactory<BeanKey<I>, BeanEntry<I>> mutatorFactory;

    public InfinispanBeanFactory(String beanName, BeanGroupFactory<I, T, C> groupFactory, Cache<BeanKey<I>, BeanEntry<I>> cache, CacheProperties properties, Duration timeout, PassivationListener<T> listener) {
        this.beanName = beanName;
        this.groupFactory = groupFactory;
        this.cache = cache;
        this.findCache = properties.isLockOnRead() ? this.cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK) : this.cache;
        this.timeout = timeout;
        this.listener = listener;
        this.mutatorFactory = new InfinispanMutatorFactory(cache, properties);
    }

    @Override
    public BeanKey<I> createKey(I id) {
        return new InfinispanBeanKey<I>(id);
    }

    @Override
    public Bean<I, T> createBean(I id, BeanEntry<I> entry) {
        Object groupId = entry.getGroupId();
        BeanGroupEntry groupEntry = (BeanGroupEntry)this.groupFactory.findValue(groupId);
        if (groupEntry == null) {
            InfinispanEjbLogger.ROOT_LOGGER.invalidBeanGroup(id, groupId);
            this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).remove(this.createKey(id));
            return null;
        }
        BeanGroup<I, T> group = this.groupFactory.createGroup(groupId, groupEntry);
        Mutator mutator = entry.getLastAccessedTime() == null ? Mutator.PASSIVE : this.mutatorFactory.createMutator(this.createKey(id), entry);
        return new InfinispanBean<I, T>(id, entry, group, mutator, this, this.timeout, this.listener);
    }

    public BeanEntry<I> findValue(I id) {
        try {
            return (BeanEntry)this.findCache.get(this.createKey(id));
        }
        catch (TimeoutException e) {
            throw new ConcurrentAccessTimeoutException(e.getLocalizedMessage());
        }
    }

    public BeanEntry<I> tryValue(I id) {
        return (BeanEntry)this.findCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).get(this.createKey(id));
    }

    public BeanEntry<I> createValue(I id, I groupId) {
        InfinispanBeanEntry<I> entry = new InfinispanBeanEntry<I>(this.beanName, groupId);
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put(this.createKey(id), entry);
        return entry;
    }

    @Override
    public boolean remove(I id, RemoveListener<T> listener) {
        Object groupId;
        BeanGroupEntry groupEntry;
        BeanEntry entry = (BeanEntry)this.cache.getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS).remove(this.createKey(id));
        if (entry != null && (groupEntry = (BeanGroupEntry)this.groupFactory.findValue(groupId = entry.getGroupId())) != null) {
            try (BeanGroup<I, T> group = this.groupFactory.createGroup(groupId, groupEntry);){
                T bean = group.removeBean(id, this.listener);
                if (listener != null) {
                    listener.removed(bean);
                }
            }
        }
        return true;
    }
}

