/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public final class ResourceUtils {
    private static final int READ_BUFFER_SIZE = 2048;

    private ResourceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentsAsString(Reader reader) throws IOException {
        try {
            int count;
            CharArrayWriter writer = new CharArrayWriter();
            char[] buffer = new char[2048];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String getContentsAsString(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            String string = ResourceUtils.getContentsAsString(reader);
            return string;
        }
    }

    public static String getContentsAsString(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = ResourceUtils.getContentsAsString(is);
            return string;
        }
    }

    public static InputStream getResourceAsStream(ClassLoader userClassLoader, String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        ClassLoader[] classLoaders = new ClassLoader[]{userClassLoader, ResourceUtils.class.getClassLoader(), ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()};
        InputStream is = null;
        for (ClassLoader cl : classLoaders) {
            if (cl != null && (is = cl.getResourceAsStream(resourcePath)) != null) break;
        }
        return is;
    }

    public static Reader getResourceAsReader(Class<?> c, String resourcePath) throws UncheckedIOException {
        try {
            InputStream is = c.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new IOException("Resource not found in class path : " + resourcePath);
            }
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsString(Class<?> c, String resourcePath) throws UncheckedIOException {
        try (Reader reader = ResourceUtils.getResourceAsReader(c, resourcePath);){
            String string = ResourceUtils.getContentsAsString(reader);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

