/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.console;

import java.util.ArrayList;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.ReportError;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public class UserChoice {
    protected ConsoleWrapper theConsole;
    protected final String[] messageLines;
    protected final String[] options;
    protected final String prompt;
    protected final ResultHandler resultHandler;
    private static final int DEFAULT_OPTION = 0;

    public UserChoice(ConsoleWrapper theConsole, String[] messageLines, String[] options, String prompt, ResultHandler resultHandler) {
        this.theConsole = theConsole;
        this.messageLines = messageLines;
        this.prompt = prompt;
        this.resultHandler = resultHandler;
        this.options = options;
    }

    public UserChoice(ConsoleWrapper theConsole, String message, String[] options, String prompt, ResultHandler resultHandler) {
        this(theConsole, new String[]{message}, options, prompt, resultHandler);
    }

    public UserChoice(ConsoleWrapper theConsole, String[] options, String prompt, ResultHandler resultHandler) {
        this(theConsole, (String[])null, options, prompt, resultHandler);
    }

    public void execute() {
        if (this.messageLines != null) {
            for (String message : this.messageLines) {
                this.theConsole.printf(message, new Object[0]);
                this.theConsole.printf(ConsoleWrapper.NEW_LINE, new Object[0]);
            }
        }
        for (int i = 0; i < this.options.length; ++i) {
            this.theConsole.printf(i + ". " + this.options[i], new Object[0]);
            this.theConsole.printf(ConsoleWrapper.NEW_LINE, new Object[0]);
        }
        this.theConsole.printf(this.prompt, new Object[0]);
        String temp = this.theConsole.readLine("(0): ", new Object[0]);
        if (temp == null) {
            this.theConsole.printf(ConsoleWrapper.NEW_LINE, new Object[0]);
        } else {
            int choice = 0;
            if (!temp.equals("")) {
                choice = Integer.valueOf(temp);
            }
            if (choice >= 0 && choice < this.options.length) {
                this.resultHandler.onChoice(this.options[choice]);
            } else {
                ArrayList<String> acceptedValues = new ArrayList<String>(4);
                for (int i = 0; i < this.options.length; ++i) {
                    acceptedValues.add(String.valueOf(i));
                }
                StringBuilder sb = new StringBuilder((String)acceptedValues.get(0));
                for (int i = 1; i < acceptedValues.size() - 1; ++i) {
                    sb.append(", ");
                    sb.append((String)acceptedValues.get(i));
                }
                new ReportError(this.theConsole, ServerMigrationLogger.ROOT_LOGGER.invalidResponse(sb.toString(), (String)acceptedValues.get(acceptedValues.size() - 1))).execute();
                this.resultHandler.onError();
            }
        }
    }

    public static interface ResultHandler {
        public void onChoice(String var1);

        public void onError();
    }
}

