/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.env.Environment;

public class SubEnvironment
implements Environment {
    private final Environment environment;
    private final String propertyNamePrefix;

    public SubEnvironment(Environment environment, String propertyNamePrefix) {
        this.environment = environment;
        this.propertyNamePrefix = propertyNamePrefix;
    }

    private String getAbsolutePropertyName(String propertyName) {
        return this.propertyNamePrefix + propertyName;
    }

    @Override
    public Boolean getPropertyAsBoolean(String propertyName) {
        return this.environment.getPropertyAsBoolean(this.getAbsolutePropertyName(propertyName));
    }

    @Override
    public Boolean getPropertyAsBoolean(String propertyName, Boolean defaultValue) {
        return this.environment.getPropertyAsBoolean(this.getAbsolutePropertyName(propertyName), defaultValue);
    }

    @Override
    public String getPropertyAsString(String propertyName) {
        return this.environment.getPropertyAsString(this.getAbsolutePropertyName(propertyName));
    }

    @Override
    public String getPropertyAsString(String propertyName, String defaultValue) {
        return this.environment.getPropertyAsString(this.getAbsolutePropertyName(propertyName), defaultValue);
    }

    @Override
    public List<String> getPropertyAsList(String propertyName) {
        return this.environment.getPropertyAsList(this.getAbsolutePropertyName(propertyName));
    }

    @Override
    public List<String> getPropertyAsList(String propertyName, List<String> defaultValue) {
        return this.environment.getPropertyAsList(this.getAbsolutePropertyName(propertyName), defaultValue);
    }

    @Override
    public Boolean requirePropertyAsBoolean(String propertyName) throws ServerMigrationFailureException {
        return this.environment.requirePropertyAsBoolean(this.getAbsolutePropertyName(propertyName));
    }

    @Override
    public String requirePropertyAsString(String propertyName, boolean failIfEmpty) throws ServerMigrationFailureException {
        return this.environment.requirePropertyAsString(this.getAbsolutePropertyName(propertyName), failIfEmpty);
    }

    @Override
    public List<String> requirePropertyAsList(String propertyName, boolean failIfEmpty) throws ServerMigrationFailureException {
        return this.environment.requirePropertyAsList(this.getAbsolutePropertyName(propertyName), failIfEmpty);
    }

    @Override
    public String setProperty(String propertyName, String propertyValue) {
        return this.environment.setProperty(this.getAbsolutePropertyName(propertyName), propertyValue);
    }

    @Override
    public void setProperties(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            this.setProperty(propertyName, properties.getProperty(propertyName));
        }
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String envPropertyName : this.environment.getPropertyNames()) {
            if (!envPropertyName.startsWith(this.propertyNamePrefix)) continue;
            result.add(envPropertyName.substring(this.propertyNamePrefix.length()));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<String> getPropertyNamesReaded() {
        ArrayList<String> result = new ArrayList<String>();
        for (String envPropertyName : this.environment.getPropertyNamesReaded()) {
            if (!envPropertyName.startsWith(this.propertyNamePrefix)) continue;
            result.add(envPropertyName.substring(this.propertyNamePrefix.length()));
        }
        return Collections.unmodifiableList(result);
    }
}

